// global canvas and context
var fillCanvas, fillContext,  siteCanvas, siteContext, labelCanvas, labelContext;
var outlineImage = new Image();
var colorTable;
var siteViewIni = new Array();
var textLabelConfig = new Array();
var buttonConfig = new Array();
var detNameTable;
var sgNameTable;
var detStatusTable;
var sgExternalStatusTable;
var sgInternalStatusTable;
var outputNameTable;
var outputStatusTable;
var inputNameTable;
var inputStatusTable;
var currentSiteNumber;
var MaxSiteNumber;
var isRunning=false;
var detRefresh= true;
var outputRefresh=true;
var inputRefresh=true;
var sgRefresh=true;
var waitTimer;
var BUT_STATE_NORMAL=0;
var BUT_STATE_SELECTED=1;
var BUT_STATE_PRESSED=2;
var SHORT_TIMEOUT=10;
var LONG_TIMEOUT=50;




function checkIfInsideButtonCoordinates(buttonObj, mouseX, mouseY) 
{                
	if (((mouseX > buttonObj.x)
			&& (mouseX < (buttonObj.x + buttonObj.w)))
		&& ((mouseY > buttonObj.y)
			&& (mouseY < (buttonObj.y + buttonObj.h))))   
		return true;              
	else              
		return false;        
}


window.onload = ( function() 
{
	currentSiteNumber =1;
	loadSiteViewerIni(currentSiteNumber);
	$("#labelCanvas").click(function(eventObject) { 
		mouseX = eventObject.pageX - this.offsetLeft;  
		mouseY = eventObject.pageY - this.offsetTop;  
		var siteviewIdx= currentSiteNumber-1;
		if (buttonConfig[siteviewIdx] != undefined )
		{
			for(var idx=0;idx <buttonConfig[siteviewIdx].length;idx++)
			{
				if(checkIfInsideButtonCoordinates(buttonConfig[siteviewIdx][idx], mouseX, mouseY)) 
				{                     
					buttonConfig[siteviewIdx][idx].state = BUT_STATE_PRESSED;
					drawButton(buttonConfig[siteviewIdx][idx]); 
					$.get(buttonConfig[siteviewIdx][idx].request, function(data)
					{
					}).always(function()
					{
						buttonConfig[siteviewIdx][idx].state = BUT_STATE_SELECTED;
						drawButton(buttonConfig[siteviewIdx][idx]); 
					});
					break;
				}  
			}	
		}
	});

$("#labelCanvas").mousemove(function(eventObject) {      
	mouseX = eventObject.pageX - this.offsetLeft;     
	mouseY = eventObject.pageY - this.offsetTop;     
	var siteviewIdx= currentSiteNumber-1;
	if (buttonConfig[siteviewIdx] != undefined )
	{
		for(var idx=0;idx <buttonConfig[siteviewIdx].length;idx++)
		{

			if(checkIfInsideButtonCoordinates(buttonConfig[siteviewIdx][idx], mouseX, mouseY) &&
					buttonConfig[siteviewIdx][idx].state === BUT_STATE_NORMAL ) 
			{                     
				buttonConfig[siteviewIdx][idx].state = BUT_STATE_SELECTED;
				drawButton(buttonConfig[siteviewIdx][idx]);
				// we are ready;
				break;
			} 
			if (!checkIfInsideButtonCoordinates(buttonConfig[siteviewIdx][idx], mouseX, mouseY) &&
					buttonConfig[siteviewIdx][idx].state != BUT_STATE_NORMAL ) 
			{
				buttonConfig[siteviewIdx][idx].state = BUT_STATE_NORMAL;
				drawButton(buttonConfig[siteviewIdx][idx]);
				// we are ready;
				break;
			}
		}
	}
});
	
});

function drawSiteview(number)
{
	fillCanvas = document.getElementById('fillCanvas');
	fillContext = fillCanvas.getContext('2d');
	labelCanvas = document.getElementById('labelCanvas');
	labelContext = labelCanvas.getContext('2d');
	siteCanvas = document.getElementById('siteviewer'); 
	siteContext = siteCanvas.getContext('2d');
    
	fillContext.clearRect(0,0,650, 550);
	siteContext.clearRect(0,0,650, 550);
	labelContext.clearRect(0,0,650, 550);
	
	outlineImage = new Image();
	
	// Register to the image on-load event. Using JQuery to avoid browser incompatibility issues.
	$(outlineImage).load( function() {
		// draw the loaded image on the source canvas
		siteContext.drawImage(outlineImage, 0, 0);
		//fillContext.drawImage(outlineImage, 0, 0);
		startMonitoring();
	});
	outlineImage.src = './siteview' + number+'.png';
}


function loadSiteViewerIni(number)
{
	$.get("./siteview" + number + ".ini", function(data)
			{
				siteViewIni[number-1]=parseINIString(data);
				//  load all siteview ini's
				loadSiteViewerIni(number+1);
			}).fail(function() { 
				maxSiteNumber = number-1; 
				setSelectionBox();
				setRadioGroup();
				preparetextLabels();
				prepareButtons();
				});
}

function setSelectionBox()
{
    var number=1;
	for(ini in siteViewIni)
		{
			$('#mySelect')
		    .find('option')
		    .end()
		    .append('<option value="' + number + '">' + siteViewIni[ini]["SiteView"]["title"]+'</option>');
		    number++;
		}
	$('#mySelect').change(function() 
			{
			   currentSiteNumber =parseInt($(this).val());
			   drawSiteview(currentSiteNumber);
			   detRefresh = true;
			   sgRefresh = true;
			   outputRefresh = true;
			   inputRefresh = true;
			   
			});
	loadColorTable();
}


function setRadioGroup()
{
	$("input[name='mySG']").change(function() 
			{
		 	  clearTimeout(waitTimer);	      
			   sgRefresh = true;
			   getSGData ( );
			  // startMonitoring();
			   
			});
}

function loadColorTable()
{
	$.get("./statecolors.ini", function(data)
	{
		colorTable=parseINIString(data);

		// convert it into right format
		for (var section in colorTable)
		{
			for (var status in colorTable[section])
			{
				// Fill Colour: Convert the one hex colour to three separate RGB colours
				var StateInfo = colorTable[section][status].split(",");
				var bigintFill = parseInt(StateInfo[0].replace("#",""), 16);
				var fillColorR = (bigintFill >> 16) & 255;
				var fillColorG = (bigintFill >> 8) & 255;
				var fillColorB = bigintFill & 255;
				var fillColor = fillColorR + "," + fillColorG +","+ fillColorB;

				// Hatch Colour: Convert the one hex colour to three separate RGB colours
				// For backwards compatibility check if the new parameter is present
				var hatchColor = undefined
				if (StateInfo[3] != undefined)
				{
					var bigintHatch = parseInt(StateInfo[3].replace("#",""), 16);
					var hatchColorR = (bigintHatch >> 16) & 255;
					var hatchColorG = (bigintHatch >> 8) & 255;
					var hatchColorB = bigintHatch & 255;
					hatchColor = hatchColorR + "," + hatchColorG +","+ hatchColorB;
				}

				var StateInfoArray = new Array();
				StateInfoArray["fillColor"] = fillColor;
				StateInfoArray["hatchMode"] = StateInfo[1];
				StateInfoArray["hatchDensity"] = StateInfo[2];
				StateInfoArray["hatchColor"] = hatchColor;
				colorTable[section][status] = StateInfoArray;			
			}
		}

		loadDetectorNames();
	});
}

function loadDetectorNames()
{
	$.get("./vi?fmt=<t*XDET.I>;", function(data)
	{
		detNameTable = data.split(';');
		loadSGNames();
	});
}

function loadSGNames()
{
	$.get("./vi?fmt=<t*XSG.I>;", function(data)
	{
		sgNameTable = data.split(';');
		loadInputNames();
	});
}

function loadInputNames()
{
    $.get("./vi?fmt=<t*XIN.I>;", function(data)
    {
        inputNameTable = data.split(';');  
        loadOutputNames();      
    });
}

function loadOutputNames()
{
	$.get("./vi?fmt=<t*XOUT.I>;", function(data)
	{
		outputNameTable = data.split(';');
		drawSiteview(currentSiteNumber);
		
	});
}

function prepareButtons()
{
	if ( siteViewIni !=undefined)
	{
		var siteviewerIdx=0;
		// do it for all siteviewers
		for (siteviewer in siteViewIni)
		{
			if (siteViewIni[siteviewer]["Button"] != undefined)
			{
				// there are text labels defined
				buttonConfig[siteviewerIdx] = new Array();
				var labelIdx=0;
				for (labelId in siteViewIni[siteviewer]["Button"])
				{
					// id=x,y,font-type,font-size,font-color,label,pardb/(name)index 
					if (siteViewIni[siteviewer]["Button"][labelId] != undefined)
					{
						/*;id=x,y,w,h,button-color,font-style,font-size,font-color,label,pardb/index,value
						 *    0 1 2 3 4            5          6         7          8     9           10
						 */

						var textParams = siteViewIni[siteviewer]["Button"][labelId].split(',');
						if ( textParams.length == 11)
						{
							{
								var x=parseInt(textParams[0]);
								var y=parseInt(textParams[1]);
								var w=parseInt(textParams[2]);
								var h=parseInt(textParams[3]);
								if (isNaN(x) || isNaN(y) || x < 0 || y < 0 ||
										isNaN(w) || isNaN(h) || w < 0 || h < 0	)
								{
									// no valid coords ignore it.
									continue;								
								}
								var labelFont = "";
								if ( textParams[5] === "BOLD")
								{
									labelFont = "bold";
								}
								else if (textParams[5] === "ITALIC")
								{
									labelFont = "italic";
								}
								var size = parseInt(textParams[6]);
								if ( !isNaN(size))
								{
									labelFont += " " + textParams[6] + "px";
								}
								else
								{
									labelFont += " 10px";
									size=10;
								}
								labelFont += " Arial";
								var color = "#000000";
								if (textParams[7].length == 7)
								{
									color = textParams[7];
								}

								buttonConfig[siteviewerIdx][labelIdx] = new Button(x,y,w,h, labelFont,size,color,
										textParams[8],textParams[9],textParams[10]);
								checkButtonParameter(buttonConfig[siteviewerIdx][labelIdx]);
							}
						}
					}
					labelIdx++;
				}
			}
		}
	}
}

function Button(x,y,w,h,font,fontHeight,color,text,param,value )
{
	this.x = x;
	this.y = y;
	this.w = w;
	this.h=  h;
	this.font = font;
	this.height = fontHeight;
	this.color = color;
	this.text = text;
	this.param = param;
	this.request = "";
	this.value = value;
	this.state = BUT_STATE_NORMAL;
}

function drawButton(buttonObj){
	labelContext.font = buttonObj.font;   
	labelContext.textBaseline = "top";	
	labelContext.clearRect(buttonObj.x-1,buttonObj.y-1,buttonObj.w+6,buttonObj.h+6);

	var origShadowColor = labelContext.shadowColor;

	if ( buttonObj.state === BUT_STATE_NORMAL)
	{
		labelContext.fillStyle = "#AAD6F0";
	}
	else if  ( buttonObj.state === BUT_STATE_SELECTED)
	{
		labelContext.fillStyle = "#7B89EA";	
	}
	else
	{
		labelContext.fillStyle = "#FF8000";		
	}
	labelContext.shadowOffsetX = 2;
	labelContext.shadowOffsetY = 2;
	labelContext.shadowBlur = 2;
	labelContext.shadowColor = "rgba(0,0,0,0.5)";
	labelContext.fillRect(buttonObj.x,buttonObj.y,buttonObj.w,buttonObj.h);
	labelContext.shadowColor = origShadowColor;

	labelContext.fillStyle = buttonObj.color;
	var align = labelContext.textAlign; // the the value
	labelContext.textAlign = "center";
	labelContext.fillText(buttonObj.text, buttonObj.x+(buttonObj.w)/2,buttonObj.y+5);
	labelContext.textAlign = align;
}

// must be called after drawing the labels because the clearing the canvas
function drawButtons(refresh)
{
	var siteviewIdx= currentSiteNumber-1;
	if (buttonConfig[siteviewIdx] != undefined )
	{
		for(var idx=0;idx <buttonConfig[siteviewIdx].length;idx++)
		{
			drawButton(buttonConfig[siteviewIdx][idx]);
		}
	}
}

function checkButtonParameter(button)
{
	// first try a value parameter
	$.get("./parv/"+ button.param, function(data)
			{
				button.request = "./parv/"+ button.param + "?val=" + button.value;			
			}).fail(function() {
				// failed thus assume it is a text parameter
				button.request = "./part/"+ button.param  + "?val=" + button.value;
			});
}

	
function preparetextLabels()
{	
	if ( siteViewIni !=undefined)
	{
		var siteviewerIdx=0;
		// do it for all siteviewers
		for (siteviewer in siteViewIni)
		{
			if (siteViewIni[siteviewer]["Texted"] != undefined)
			{
				// there are text labels defined
				textLabelConfig[siteviewerIdx] = new Array();
				var labelIdx=0;
				for (labelId in siteViewIni[siteviewer]["Texted"])
				{
					// id=x,y,font-type,font-size,font-color,label,pardb/(name)index 
					if (siteViewIni[siteviewer]["Texted"][labelId] != undefined)
					{
						var textParams = siteViewIni[siteviewer]["Texted"][labelId].split(',');
						if ( textParams.length == 7)
						{
							var x=parseInt(textParams[0]);
							var y=parseInt(textParams[1]);
							if (isNaN(x) || isNaN(y) || x < 0 || y < 0)
							{
								// no valid label ignore it.
								continue;								
							}
							var labelFont = "";
							if ( textParams[2] === "BOLD")
							{
								labelFont = "bold";
							}
							else if (textParams[2] === "ITALIC")
							{
								labelFont = "italic";
							}
							var size = parseInt(textParams[3]);
							if ( !isNaN(size))
							{
								labelFont += " " + textParams[3] + "px";
							}
							else
							{
								labelFont += " 10px";
								size=10;
							}
							labelFont += " Arial";
							var color = "#000000";
							if (textParams[4].length == 7)
							{
								color = textParams[4];
							}
							var label = textParams[5];	
							if ( textParams[5].length > 0 && textParams[6] != "*" )
							{
								label += ":";
							}
							
							textLabelConfig[siteviewerIdx][labelIdx] = new textLabel(x,y,labelFont,size,color,label,textParams[6]);
							checkLabelParameter(textLabelConfig[siteviewerIdx][labelIdx]);
						}
					}
					labelIdx++;
				}				
			}
			siteviewerIdx++;
		}			
	}
}

function checkLabelParameter(label)
{
	// first try a value parameter
	$.get("./parv/"+ label.param, function(data)
			{
				label.request = "./parv/"+ label.param;
		        label.value = data;
			}).fail(function() {
				// failed thus assume it is a text parameter
				label.request = "./part/"+ label.param;
				label.value = "";

			});
}

function textLabel(x,y,font,fontHeight,color,label,param )
{
	this.x = x;
	this.y = y;
	this.font = font;
	this.height = fontHeight;
	this.color = color;
	this.label = label;
	this.param = param;
	this.request = "";
	this.value = "";  // stores the current value
	this.isDirty = true; // needs redraw
	this.newValue = "";
}

function drawtextLabels(refresh)
{
	var siteviewIdx= currentSiteNumber-1;
	if ( refresh)
	{
		labelContext.clearRect(0,0,650, 550);
	}
	if ( textLabelConfig[siteviewIdx] != undefined)
	{
		for(var idx=0;idx <textLabelConfig[siteviewIdx].length;idx++)
		{
			if (refresh||textLabelConfig[siteviewIdx][idx].isDirty)
			{
				labelContext.font = textLabelConfig[currentSiteNumber-1][idx].font;
				labelContext.fillStyle = textLabelConfig[currentSiteNumber-1][idx].color;
				labelContext.textBaseline = "top";
				var textDimensions = labelContext.measureText(textLabelConfig[siteviewIdx][idx].label + textLabelConfig[siteviewIdx][idx].value);
				// needs redraw
				labelContext.clearRect(textLabelConfig[siteviewIdx][idx].x,textLabelConfig[siteviewIdx][idx].y
						,textDimensions.width,
						textLabelConfig[siteviewIdx][idx].height); 
				labelContext.fillText(textLabelConfig[currentSiteNumber-1][idx].label + textLabelConfig[currentSiteNumber-1][idx].newValue,
						textLabelConfig[currentSiteNumber-1][idx].x, 
						textLabelConfig[currentSiteNumber-1][idx].y);
				textLabelConfig[siteviewIdx][idx].isDirty = false;
				textLabelConfig[siteviewIdx][idx].value = textLabelConfig[siteviewIdx][idx].newValue;
			}
		}
	}
}


function updateTextLabels(labelIdx)
{
	if (textLabelConfig[currentSiteNumber-1] == undefined)
	{
		// get out a here
		return;
	}
	
	$.get(textLabelConfig[currentSiteNumber-1][labelIdx].request, function(data)
	{
		if (textLabelConfig[currentSiteNumber-1][labelIdx].value != data)
			{
				textLabelConfig[currentSiteNumber-1][labelIdx].newValue = data;
				textLabelConfig[currentSiteNumber-1][labelIdx].isDirty = true;
			}
	}).always(function() { 
		labelIdx++; 
		if (labelIdx >=textLabelConfig[currentSiteNumber-1].length  )
			{ 
				labelIdx=0;
				drawtextLabels(false);
			}
		setTimeout("updateTextLabels(" + labelIdx+")",SHORT_TIMEOUT);
		});
}


function startMonitoring()
{
	// First time we get here?
	if ( !isRunning)
	{
		getDetectorData();	// Starts a background timer-based continuous update of the Detectors, Signalgroups, Outputs and Inputs.
		drawtextLabels(true);
		drawButtons();
		updateTextLabels(0);	// Starts a background timer-based continuous update of the Text Labels.
		isRunning = true;	
	}
	else  // We were already running and the user selected another SiteView (or whatever)
	{
		try
		{
			clearTimeout(waitTimer);	// Stop the background I/O update task.
			drawStatus(detStatusTable,"Detector","Detector",detStatusTable,detNameTable,detRefresh);
			if ($("input[name='mySG']:checked").val() == 'internal')		
			{
				 drawStatus(sgInternalStatusTable,"SG", "SGI",sgInternalStatusTable,sgNameTable,sgRefresh);
			}
			else
			{
				 drawStatus(sgExternalStatusTable,"SG", "SGE", sgExternalStatusTable,sgNameTable,sgRefresh);
			}
			drawStatus(outputStatusTable, "Output", "Output", outputStatusTable, outputNameTable, outputRefresh);
			drawStatus(inputStatusTable,  "Input",  "Input",  inputStatusTable,  inputNameTable,  inputRefresh);
			
		}
		catch(err)
		{
			//Handle errors here
			sgRefresh = true;
			detRefresh=true;
			outputRefresh=true;
			inputRefresh=true;
		}
		getDetectorData();		// Restart the background I/O update task
		drawtextLabels(true);
		drawButtons();
	}
}

// create  objects from ini file
function parseINIString(data)
{
	var regex = {
	    section: /^\s*\[\s*([^\]]*)\s*\]\s*$/,
	    param: /^\s*([\w\.\-\_]+)\s*=\s*(.*?)\s*$/,
	    comment: /^\s*;.*$/
	};
	var value = {};
	var lines = data.split(/\r\n|\r|\n/);
	var section = null;

	for(var x=0;x<lines.length;x++)
	{
	    if(regex.comment.test(lines[x])){
	        return;
	    }else if(regex.param.test(lines[x])){
	        var match = lines[x].match(regex.param);
	        if(section){
	            value[section][match[1]] = match[2];
	        }else{
	            value[match[1]] = match[2];
	        }
	    }else if(regex.section.test(lines[x])){
	        var match = lines[x].match(regex.section);
	        value[match[1]] = {};
	        section = match[1];
	    }else if(lines[x].length == 0 && section){
	        section = null;
	    };
	}

	return value;
}


function getOutputData ( )
{
	if (siteViewIni[currentSiteNumber-1]["Output"] == undefined)
	{
		// nothing todo go to next get data function
		setTimeout("getInputData()",SHORT_TIMEOUT);
		return;
	}
	$.get("./parv/XOUT.CSC/", function(data)
	{
		var status = data.split('\n');
		drawStatus(status,"Output","Output",outputStatusTable,outputNameTable,outputRefresh);
		outputStatusTable=status;
		outputRefresh=false;

	}).fail(function() {outputRefresh=true; })
	.always(function() {waitTimer=setTimeout("getInputData()",LONG_TIMEOUT); });
}

function getInputData ( )
{
    if (siteViewIni[currentSiteNumber-1]["Input"] == undefined)
    {
        // nothing todo go to next get data function
        setTimeout("getDetectorData()",SHORT_TIMEOUT);
        return;
    }
    $.get("./parv/XIN.STS/", function(data)
    {
        var status = data.split('\n');
        drawStatus(status,"Input","Input",inputStatusTable,inputNameTable,inputRefresh);
        inputStatusTable=status;
        inputRefresh=false;

    }).fail(function() {inputRefresh=true; })
    .always(function() {waitTimer=setTimeout("getDetectorData()",LONG_TIMEOUT); });
}


function getSGData ( )
{
	var getString="";
	var table;
	var sgStr="";

	if (siteViewIni[currentSiteNumber-1]["SG"] == undefined)
	{
		// nothing todo go to next get data function
		setTimeout("getOutputData()",SHORT_TIMEOUT);
		return;
	}

	if ( ($("input[name='mySG']:checked").val() == 'internal') )
    {
		getString="./parv/FC.STS/";
		table=sgInternalStatusTable;
		sgStr="SGI";
    }
	else
	{
		getString="./parv/XSG.CSC/";
		table=sgExternalStatusTable;
		sgStr="SGE";
	}
	$.get(getString, function(data)		
	{	
		var status = data.split('\n');
		drawStatus(status,"SG", sgStr,table,sgNameTable,sgRefresh);
		sgRefresh=false;
		if ( ($("input[name='mySG']:checked").val() == 'internal') )
	    {
			sgInternalStatusTable = status;
	    }
		else
		{
			sgExternalStatusTable = status;
		}
	
	}).fail(function() {sgRefresh=true; })
	.always(function() {waitTimer=setTimeout("getOutputData()",LONG_TIMEOUT); });
}

// retrieve the detector data from web interface
function getDetectorData ( )
{
	if (siteViewIni[currentSiteNumber-1]["Detector"] == undefined)
	{
		// nothing todo go to next get data function
		setTimeout("getSGData()",SHORT_TIMEOUT);
		return;
	}
	$.get("./parv/XDET.STS/", function(data)
	{

		var status = data.split('\n');
		drawStatus(status,"Detector","Detector",detStatusTable,detNameTable,detRefresh);
		detRefresh = false;
		detStatusTable = status;
	   
	}).fail(function() {detRefresh=true; })
	.always(function() {waitTimer=setTimeout("getSGData()",LONG_TIMEOUT); });
}


function drawStatus(newStatusTable, tag, colorTag, lastStatusTable, nameTable,refreshToggle)
{
	var width = fillContext.canvas.width;
	var height = fillContext.canvas.height;
	var fillImageData = fillContext.getImageData(0, 0, width, height);
	var outlineData = siteContext.getImageData(0, 0, width, height);
	
	/* In IE11 a problem occurred that the detector status in the siteviewer is not shown correctly */
	/* Problem is that for some reason, in IE11, the getImageData/putImageData functions don't work the first time they are called */
	/* To fix this problem, always refresh the siteviewer while using IE */
	if ((navigator.userAgent.indexOf('MSIE') !== -1) || (navigator.appVersion.indexOf('Trident/') > 0))
	{
		refreshToggle = true;
	}
	
	if (siteViewIni[currentSiteNumber-1][tag] == undefined )
	{
		return;
	}
	if (newStatusTable == undefined)
	{
		// can sometimes happen during switching between SiteViewer, is automatically solved the next time 
		return;
	}
	if (lastStatusTable == undefined)
	{ 
		// for the first time no 
		lastStatusTable = newStatusTable;
	}
	
	for (var i=0;i<newStatusTable.length;i++)
	{
		// Figure out if name is in lower or upper case
		var Name = nameTable[i].toLowerCase();
		var exists = false;
		if(siteViewIni[currentSiteNumber-1][tag][Name]!=undefined) {
			exists = true;
		}
		else if(siteViewIni[currentSiteNumber-1][tag][Name.toUpperCase()]!=undefined) {
			Name = Name.toUpperCase();
			exists = true;
		}

		if(exists) {
			if (Name in colorTable) {
				colorTag = Name;
			}
			if ((refreshToggle || lastStatusTable[i] != newStatusTable[i])
				&& colorTable[colorTag] != undefined
				&& newStatusTable[i] != undefined
				&& colorTable[colorTag][newStatusTable[i]]["fillColor"] != undefined
				)
			{
				var xy = siteViewIni[currentSiteNumber-1][tag][Name].split(',');
				for (var idx=0;idx<xy.length;idx+=2)
				{
					myFloodFill(parseInt(xy[idx]), parseInt(xy[idx+1]),
						colorTable[colorTag][newStatusTable[i]]["fillColor"],
						colorTable[colorTag][newStatusTable[i]]["hatchMode"],
						colorTable[colorTag][newStatusTable[i]]["hatchColor"],
						colorTable[colorTag][newStatusTable[i]]["hatchDensity"],
						fillImageData, outlineData, width, height);
				}
			}
		}
	}

	// redraw the overlay
	fillContext.putImageData(fillImageData, 0, 0);

	return;	
}

// Note: for backwards compatibility the new parameters hatchMode, hatchColor, hatchDensity are allowed to be 'undefined'.
function myFloodFill(x, y, curColor, hatchMode, hatchColor, hatchDensity, fillImageData, outlineData, width, height) {
    var stack = [];
    var oPixels = outlineData.data;
    var hatchPixels = new Array();
    
    var rgb = curColor.split(',');
    var curColorR = parseInt(rgb[0]);
    var curColorG = parseInt(rgb[1]);  
    var curColorB = parseInt(rgb[2]);
    
    // do the first pixel
    pixelAddress = (y * width + x) * 4;
    // take original pixel colour to fill
    var targetColour = new Array();
	targetColour[0] = oPixels[pixelAddress];
	targetColour[1] = oPixels[pixelAddress+1];
	targetColour[2] = oPixels[pixelAddress+2];
	
    if ( compareAndDraw(pixelAddress, oPixels, hatchPixels,fillImageData,curColorR,curColorG,curColorB, targetColour, hatchMode, hatchDensity, x, y) )
    {
        if (!stack.push(x, y)) {
            return;
        }
    }
    
    while (stack.length > 0) {
        y = stack.pop();
        x = stack.pop();
        pixelAddress = (y * width + x) * 4;

        // check the neighbours
        // left
        if ( x >= 0 &&compareAndDraw(pixelAddress-4, oPixels, hatchPixels,fillImageData,curColorR,curColorG,curColorB, targetColour, hatchMode, hatchDensity, x -1, y) )
        {
            if (!stack.push(x-1, y)) {
                return;
            }
        }
                
        // right
        if ( x < width &&compareAndDraw(pixelAddress+4, oPixels, hatchPixels,fillImageData,curColorR,curColorG,curColorB, targetColour, hatchMode, hatchDensity, x +1, y) )
        {
            if (!stack.push(x+1, y)) {
                return;
            }
        }
        
        // below
        if ( y <= height &&compareAndDraw(pixelAddress+ (width*4), oPixels, hatchPixels,fillImageData,curColorR,curColorG,curColorB, targetColour, hatchMode, hatchDensity, x, y +1) )
        {
            if (!stack.push(x, y+1)) {
                return;
            }
        }
        
        // above
        if ( y > 0 &&compareAndDraw(pixelAddress-(width*4), oPixels, hatchPixels,fillImageData,curColorR,curColorG,curColorB, targetColour, hatchMode, hatchDensity, x, y -1) )
        {
            if (!stack.push(x, y-1)) {
                return;
            }
        }
  
        // for debugging...
        //fillCtx.putImageData(fillImageData, 0, 0);
    }

	// Draw the hatch pixels
	if (hatchMode != undefined)		// for backwards compatibility.
	{
		var rgbHatch = hatchColor.split(',');
		var rgbHatchR = parseInt(rgbHatch[0]);
		var rgbHatchG = parseInt(rgbHatch[1]);  
		var rgbHatchB = parseInt(rgbHatch[2]);

		for (var i=0; i<hatchPixels.length; i++) {
			fillImageData.data[hatchPixels[i]] = rgbHatchR;
			fillImageData.data[hatchPixels[i] + 1] = rgbHatchG;
			fillImageData.data[hatchPixels[i] + 2] = rgbHatchB;
			fillImageData.data[hatchPixels[i] + 3] = 255;
		}
	}
}

compareAndDraw = function(pixelAddress, oPixelData, hatchPixels, fillImageData, fillR, fillG, fillB, targetColour, hatchMode, hatchDensity, x, y) {
	// if same as targetColour then it is not a border
	if (oPixelData[pixelAddress] == targetColour[0] &&
		oPixelData[pixelAddress+1] == targetColour[1] &&
		oPixelData[pixelAddress+2] == targetColour[2])
	{
		// If the current pixel matches the fill colour or the hatchcolour
		if (fillImageData.data[pixelAddress] === fillR &&
			fillImageData.data[pixelAddress + 1] === fillG &&
			fillImageData.data[pixelAddress + 2] === fillB)
		{
			// already filled
			return false;
		} else {
			if (isHatchPixel(x, -y, hatchMode, hatchDensity)) {
				// draw the hatch pixel 
				hatchPixels.push(pixelAddress);
			} 
			// draw the fill pixel 
			fillImageData.data[pixelAddress] = fillR;
			fillImageData.data[pixelAddress + 1] = fillG;
			fillImageData.data[pixelAddress + 2] = fillB;
			fillImageData.data[pixelAddress + 3] = 255;

			return true;
		}
	}

	// it is a border
	return false;
};

 
isHatchPixel = function(pixelX, pixelY, hatchMode, hatchDensity) {
	//hatchmode 0 = nohatch
	//hatchmode 1 = lefthatch
	//hatchmode 2 = righthatch
	//hatchmode 3 = bothhatch
	if ( (hatchMode == undefined)
		|| (hatchDensity == undefined)
		|| (hatchMode == 0)
		) {
		return false;
	}
	if (hatchMode == 1 || hatchMode == 3) {
		var pixelTmpA = Math.abs(pixelY) - pixelX;
		if ((pixelTmpA % hatchDensity) === 0) {
			var hatchLeft = true;
		} else {
			var hatchLeft = false;
		}
	}
	if (hatchMode == 2 || hatchMode == 3) {
		var pixelTmpB = pixelY - pixelX;
		if ((pixelTmpB % hatchDensity) === 0) {
			var hatchRight = true;
		} else {
			var hatchRight = false;
		}
	}
	if ( hatchLeft || hatchRight ) {
		return true;  
	} else {
		return false;  
	}
}

