window.onbeforeunload = exit;
// Create a top level variable that indicates that this is a pctree view
// (html) and not a tft view.
top.isPcTree = true;

function tree_init()
{

	rollup();
	SetScrollPosition();
	//ClearCookies();
}

function exit()
{
	SaveTreeStatus();
}

function SetScrollPosition()
{
	var scrollPostion = GetCookie( "line" );
	window.scrollBy(0, scrollPostion );
}

function SetCookie( name, value ) {
  var argv = SetCookie.arguments;
  var argc = SetCookie.arguments.length;
  var expires = (argc > 2) ? argv[2] : null;
  var path = (argc > 3) ? argv[3] : null;
  var domain = (argc > 4) ? argv[4] : null;
  var secure = (argc > 5) ? argv[5] : false;
  document.cookie = name + "=" + escape (value) +
    ((expires == null) ? "" : ("; expires=" + expires.toGMTString())) +
    ((path == null) ? "" : ("; path=" + path)) +
    ((domain == null) ? "" : ("; domain=" + domain)) +
    ((secure == true) ? "; secure" : "");
}

// Get Cookie function
function GetCookie(name) {
   var arg = name+"=";
   var alen = arg.length;
   var clen = document.cookie.length;
   var i = 0;
   while (i < clen) {
      var j = i + alen;
      if (document.cookie.substring(i, j) == arg) return getCookieVal(j);
      i = document.cookie.indexOf(" ", i) + 1;
      if (i == 0) break;
   }
   return null;
}

function getCookieVal(offset) {
   var endstr = document.cookie.indexOf (";", offset);
   if (endstr == -1) endstr = document.cookie.length;
   return unescape (document.cookie.substring(offset, endstr));
}


function showall()
{
  var objMenu =  document.getElementById('mainnav');
  var objNested = objMenu.getElementsByTagName('ul');

  for (var i=0; i<objNested.length; i++)
  {
    var objMenuitem = objNested[i].parentNode;
    rollout( objMenuitem.firstChild, null );	
  } 
}

function SaveTreeStatus()
{
  var scrollTop = 0;
  var expDays = 30; 
  var exp = new Date(); 
  exp.setTime(exp.getTime() + (expDays*30*24*60*60*1000)); 
   	
  var objMenu = document.getElementById('mainnav');
  var objNested = objMenu.getElementsByTagName('ul');
  for (var i=0; i<objNested.length; i++)
  {
    var objNode = objNested[i].parentNode;	
    //alert( "saving: " + i + " = " + objNode.firstChild.nextSibling.style.display );
    SetCookie( i, objNode.firstChild.nextSibling.style.display, exp );
  }
    
  if (document.documentElement && document.documentElement.scrollTop)
    scrollTop = document.documentElement.scrollTop
  else if (document.body)
  	scrollTop = document.body.scrollTop
  else
	  scrollTop = window.pageYOffset;
    
  SetCookie( "line", scrollTop, exp ); 
}

function ClearCookies()
{
  var objMenu = document.getElementById('mainnav');
  var objNested = objMenu.getElementsByTagName('ul');
  
  // Hide each of the nested unordered list
  for (var i=0; i<objNested.length; i++)
  {		
    document.cookie = i += "=; expires= 0" ;
  } 
}

function Highlight( objHighlightedLink )
{
  var strLocation, objSpan, objLinks;
  
  if( top.content_frame.window.location )
  {
    strLocation = top.content_frame.window.location;
  }
  
  objSpan = objHighlightedLink.parentNode.getElementsByTagName('span')[0];
  
  objGlobalSpan = document.getElementsByTagName('span');
  for (var j=0; j<objGlobalSpan.length; j++)
  { 
  
    if( objGlobalSpan[j] == objSpan )
      objSpan.className = 'highlight';
    else
      objGlobalSpan[j].className = '';
  }	
  
  //continueing the link request
  return true;
}


function rollout( objMenuitem, objEvent )
{
  var iKeyCode;
	var BlockLength = 0;
	var scrollTop;

  if (document.documentElement && document.documentElement.scrollTop)
    scrollTop = document.documentElement.scrollTop
  else if (document.body)
  	scrollTop = document.body.scrollTop
  else
	  scrollTop = window.pageYOffset;

  // Check if from a keyboard - non IE, but
  // irrelevant as tab doesn't trigger the 
  // keypress event in IE

  if (objEvent && objEvent.type == 'keypress')
  {
    if (objEvent.keyCode)
      iKeyCode = objEvent.keyCode;
    else if (objEvent.which)
      iKeyCode = objEvent.which;
  
    // If it's not the enter key or space key, 
    // pass control back to the browser
    if (iKeyCode != 13 && iKeyCode != 32)
      return true;
  }
  
  if (objMenuitem.nextSibling.style.display == 'block')
  {
  
    objMenuitem.nextSibling.style.display = 'none';
    var imgObj = objMenuitem.getElementsByTagName('img');
    imgObj[0].setAttribute("src", "picto_folder_closed.gif");
  }    
  else
  {
    objMenuitem.nextSibling.style.display = 'block';
    BlockLength = objMenuitem.style.height ;
    var imgObj = objMenuitem.getElementsByTagName('img');
    imgObj[0].setAttribute("src", "picto_folder_open.gif");
  }
  
  //alert( BlockLength );
  //window.scrollBy(0, scrollTop);
  // Stop the browser requesting the link
  return false;
}

function rollup()
{
  var bRollup, objNode, objAnchor, objSpan;
  var rExp = /_/g;
  
  // Check we're working with a DOM compliant browser
  if (document.getElementById && document.createElement)
  {
    var strLocation = top.content_frame.window.location;
    var objMenu = document.getElementById('mainnav');
    
    var objNested = objMenu.getElementsByTagName('ul');
  
    // Hide each of the nested unordered list
    for (var i=0; i<objNested.length; i++)
    {
      // Only hide, if the current location is not found in the list
      bRollup = true;
  
      objLinks = objNested[i].getElementsByTagName('a');
      for (var j=0; j<objLinks.length; j++)
      {
        objLinks[j].onmouseup = function(event){return Highlight( this );}
      }
  
      // Place the top-level text in an anchor tag
      objNode = objNested[i].parentNode;
      
      strContent = objNode.firstChild.data;
  
      //if ( bRollup == true )
      var CurNestedStyle = GetCookie( i );
      //var CurNested = getElementsByTagName('ul');
      
      //var CurDisplay = CurNested[i].style;
      
      if( CurNestedStyle == 'none' )
      {
        objNested[i].style.display = 'none';
        bRollup = true;
      }
      else
      {
        objNested[i].style.display = 'block';
        bRollup = false;
      }
  
      //strContentReplaced = replaceUnderscores( strContent );
      
      //create a plus sign instead of a standard bullit
  
      var imageObj = document.createElement("img"); 
      if (bRollup == true)
      {
        imageObj.setAttribute("src", "picto_folder_closed.gif"); 
      }
      else
      {
        imageObj.setAttribute("src", "picto_folder_open.gif"); 
      }
       
      objAnchor = document.createElement('a');
      objAnchor.href = '#';
              
      objAnchor.onmousedown = function(event){return rollout(this, event);}
      objAnchor.onkeypress = function(event){return rollout(this, event);}
      
      objAnchor.appendChild(imageObj);
      
      objAnchor.appendChild( document.createTextNode( strContent.replace( rExp, ' ' ) ) );
      
      objNode.replaceChild(objAnchor, objNode.firstChild);
    }
  }
    
  objSpan = document.getElementsByTagName('span');
  for( i = 0; i < objSpan.length; i++ )
  {
    var strText= objSpan[i].lastChild.nodeValue;
    if( strText )
    {
      var newText = strText.replace( rExp, ' ' );
      if( newText != strText )
      {
        var newObj = document.createElement('span');
        newObj.appendChild( document.createTextNode( newText ) );
        objSpan[i].replaceChild( newObj, objSpan[i].firstChild );
      }
    }	
  }
}


