var button = new Array();          // button array
var state = new Array();           // state of the detector [0/1]
var swico = new Array();           // state of the swico in text (ie. [ON/OFF/-])
var old_state = new Array();
var old_swico = new Array();
var swico_state = new Array();     // state of the swico [0/1/2]

var initialized = 0;
var http_status = 0;

var nr_pages = 0;
var last_page_size = 0;
var cur_page = 1;
var editable = 0;

var BTN_BACK_TEXT     = top.error_msg[3];

function init() {
  /* Update the titles */
  var title_div = document.getElementById('title'); 
  title_div.innerHTML = title;
  var title2_div = document.getElementById('title2'); 
  title2_div.innerHTML = title2;

  if (alert_msg) {
    alert(alert_msg);  
  }

  refreshPage();
}

function refreshPage()
{
  timerid = setTimeout("refreshPage()", 500);

  if (http_status == 0) {
    makeHttpRequest("/hvi?file=" + data_file, "getConfig");
  }
}

function showPage(page) {
  var s = new Array();
  var bgcol = '';
  var i = 0;
  var j = 0;

  /* Calculate the button start and end positions */
  var start_item = (page - 1) * nr_buttons;
  var end_item = (page * nr_buttons);
  if( end_item > button.length ) {
    end_item = button.length;
  }

  cur_page = page;

  s.push('<table><tr>');
  
  for(i = start_item; i < end_item; i++) {
    j++;
    
    /* Change the background color if the detector is occupied */
    if (state[i] == 1) {
      bgcol = '#FF0000';
    } else {
      bgcol = '#dddddd'; 
    }
    
    s.push('<td id="det_' + button[i] + '" style="background-color: ' + bgcol + ';">');
    s.push(button[i]);
    s.push('<br>');
    if (editable == 1) {
      /* the background color of the button
         ON / OFF = lightblue
         VA       = lightgrey  */
      var bgcolor = '';
      if( swico_state[i] == '0' ) {
      	bgcolor = '#dddddd';
      } else {
        bgcolor = 'lightblue';
      }
      /* Create a 'normal' button */
      s.push('<button class="detswico" id="but_' + button[i] + '" type="button" style="background-color: ' + bgcolor + '" onclick=\'doEdit("SWICO ' + button[i] + ' = ' + swico[i] + '",\"xdet.r20/' + i + '")\'>' + swico[i] + '</button>');
    } else {
      /* Create a 'dummy' button */
      s.push('<button class="detswico_dummy" id="but_' + button[i] + '" type="button">' + swico[i] + '</button>');
    }
    s.push('</td>');
    
    /* Make a row of 8 items */
    if (j == 8) {
      s.push('</tr><tr>');
      j = 0;
    }
  }

  s.push('</tr></table>');

  var data_div = document.getElementById('buttonpad'); 
  data_div.innerHTML = s.join('');
}

function updatePage() {
  var i = 0;

  var start_item = (cur_page - 1) * nr_buttons;
  var end_item = (cur_page * nr_buttons);
  
  for(i = start_item; i < end_item; i++) {
    /* Update the button text */
    var det_but = document.getElementById('but_' + button[i]);
    if (old_swico[i] != swico[i]) {
      det_but.innerHTML = swico[i];

      if( editable ) {
        /* the background color of the button
           ON / OFF = lightblue
           VA       = lightgrey  */
        var bgcolor = '';
        if( swico_state[i] == '0' ) {
      	  bgcolor = '#dddddd';
        } else {
          bgcolor = 'lightblue';
        }
        det_but.style.backgroundColor = bgcolor;
      }
    }
    
    /* Update the detector status color */
    var det_div = document.getElementById('det_' + button[i]); 
    if( old_state[i] != state[i] ) {
      if( state[i] == 1 ) {
        det_div.style.backgroundColor = '#FF0000';
      } else {
        det_div.style.backgroundColor = '#dddddd';
      }
    }
  }
}

function doEdit(label, parname, format) 
{
  document.settingstable.edit_caption.value = title;
  document.settingstable.edit_label.value = label;
  document.settingstable.edit_par.value = parname;
  document.settingstable.edit_format.value = "r20";

  document.settingstable.edit_file.value = "edit_r20_form.hvi";
    
  savePagePosition();
  document.settingstable.submit();    
}

function makeHttpRequest(url, callback_function, return_xml)
{
  var http_request = false;

  if (window.XMLHttpRequest) { // Mozilla, Safari,...
    http_request = new XMLHttpRequest();
    if (http_request.overrideMimeType) {
      http_request.overrideMimeType('text/xml');
    }
  } else if (window.ActiveXObject) { // IE
    try {
      http_request = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
      try {
        http_request = new ActiveXObject("Microsoft.XMLHTTP");
      } catch (e) {}
    }
  }

  if (!http_request) {
    eval(callback_function + '("Unfortunatelly you browser doesn\'t support this feature.")');
    return false;
  }

  http_request.onreadystatechange = function() {
    if (http_request.readyState == 4) {
      http_status = 0;
      if (http_request.status == 200) {
        if (return_xml) {
          eval(callback_function + '(http_request.responseXML)');
        } else {
          eval(callback_function + '(http_request.responseText)');
        }
      } else {
        eval(callback_function + '("' + top.error_msg[0] + '")');
      }
    }
  }
    
  http_request.open('GET', url, true);
  http_request.send(null);
  
  /* Set the page load indicator */
  this.loadPageIndicator(1);
  
  http_status = 1;
}

function getConfig(data_string)
{
  var data_array = data_string.split('\n');
  var detector = 0;
  
  /* Clear the page load indicator */
  loadPageIndicator(0);
  
  /* copy the arrays */
  old_state = state.slice(0);
  old_swico = swico.slice(0);
  
  /* scan the file */
  for (var line_index in data_array) {
    var item_array = data_array[line_index].split(';');
    if (item_array[0] == ':DET') {
      /* :DET;Detector name;AAN;1;0 */
      if(item_array.length == 5) {
        button[detector] = item_array[1];
        swico[detector] = item_array[2];
        state[detector] = item_array[3];
        swico_state[detector] = item_array[4];
      }
      detector++;
    } else if (item_array[0] == ':E') {
      /* if ':E;1' is in the file set editable true */ 
      if (item_array.length == 2) {
        if (item_array[1] == 1) {
          editable = 1;
        }
      }
    }
  }
  
  if (initialized == 0) {
    initialized = 1;

    if (top.viewmode == 0) { 
      /* View mode = tft */
      nr_pages = parseInt(button.length / nr_buttons);
      last_page_size = (parseInt(button.length % nr_buttons)) ? (parseInt(button.length % nr_buttons)) : 0;
      nr_pages = last_page_size ? (nr_pages + 1) : nr_pages;
    } else if (top.viewmode == 1) {
      /* View mode = pc */
      nr_buttons = button.length;
      nr_pages = 1;
      last_pagesize = 0;
    }

    /* Load the page position if saved */
    loadPagePosition();
    
    /* Show the first page */
    showPage(cur_page);
    
    if (top.viewmode == 0) { 
      /* View mode = tft */
      /* Show the navigation bar */
      showNav();
    } 
  }
  
  updatePage();
}

function loadPageIndicator(s)
{
  var load_div;
  
  // check if inst_frame exists
  if (top.frames['inst_frame']) {
    load_div = top.inst_frame.document.getElementById('loadind'); 
  }
  
  if (load_div) {
    if (s) {
      load_div.style.backgroundColor = '#00c700';
    } else {
      load_div.style.backgroundColor = '#DDDDDD';  
    }    
  } 
}

function showNav() {
  var s = new Array();
  
  s.push('<form name="NavForm">');
  s.push('<table cellpadding="0" cellspacing="0" border="0" width="100%">');
  s.push('<tr><td align="left">');
  s.push('<button type="button" class="big" OnClick="top.doBack()">' + BTN_BACK_TEXT + '</button>');
  s.push('</td><td align="center" width="100%">');
  s.push('<button type="button" OnClick="doNavBack()">&lt;&lt;</button>');
  s.push('<input type="text" name="tekst">');
  s.push('<button type="button" OnClick="doNavForward()">&gt;&gt;</button>');
  s.push('</td><td align="right"><div style="width: 86px"></div>');
  s.push('</td></tr>');
  s.push('</table>');
  s.push('</form>');   
  
  /* convert the array to a big string and replace the content in the <div id="nav"> element */
  var nav_div = document.getElementById('nav'); 
  nav_div.innerHTML = s.join('');

  /* update the [1/3] text in the navigation bar */
  printNavText();
}

function printNavText() {
  document.NavForm.tekst.value = "" + cur_page + "/" + nr_pages;
}

function doNavBack() {
  if(cur_page > 1) {
    /* display the previous page */
    showPage(cur_page - 1);
  }
  
  /* update the navigation text */
  printNavText();
}

function doNavForward() {
  if(cur_page < nr_pages) {
    /* display the next page */
    showPage(cur_page + 1);
  }

  /* update the navigation text */
  printNavText();
}

function savePagePosition() {
  top.dp_datapage = 'detswico';
  top.dp_page = cur_page;
}

function loadPagePosition() 
{
  if(top.dp_datapage == 'detswico') {
    cur_page = top.dp_page;
  } else {
    top.dp_datapage = ''; 
  }
}