var datapage = top.homepage;
var pagesize = 25;
var refresh = 1;
var buttons = 0; 

var pos1 = 0;
var pos2 = pagesize - 1;
var tijd;
var maxpage = 1;
var page = 0;
var lastpagesize = 0;
var editpos = 0;

var isPcTrue = false;

//Load data options.
var title;
var subtitle;
var edit = 0;
var nav = 0;
var refresh_lock = -1;
var min_items = 0;
var max_items = 0;

var http_buffer = "";
var http_status = 0;
var timerid;

//Button texts.
var BTN_BACK_TEXT     = top.error_msg[3];
var BTN_REFRESH_TEXT1 = top.error_msg[4];
var BTN_REFRESH_TEXT2 = top.error_msg[5];
var BTN_EDIT_TEXT1    = top.error_msg[6];
var BTN_EDIT_TEXT2    = top.error_msg[7];

//
// init() - Initiazation.
//
window.onload  = function()
{
 init();	
};
function init()
{
  if(checkBrowserMode() == 0) {
  btn = top.menu_frame.document.getElementById('siteview');
  if (btn != null)
  {
    btn.disabled = 0; // enabled  
  }
    if (alert_msg) {
      alert(alert_msg);  
    }
    
    title = null;
    subtitle = null;
    edit = 0;
    nav = 0;
    min_items = 0;
    max_items = 0;
    loadPage(3);
    timerid = setTimeout("refreshPage();", 1000);
  } else {
    document.write('<h2>This browser is not supported!</h2> (' + err + ')');  
  }
}

//
// refreshPage() - Refreshes the content of the page.
//
function refreshPage()
{
  timerid = setTimeout("refreshPage()", 1000);  //Reset the timer.

  if (refresh == 1) {                           
    if (http_status == 0) {
      loadPage(1);	
    }
  }
}

//
// loadPage(p)
//
//  p:
//  1 - download page and load page contents
//  2 - download page and load configuration
//  3 - download page and load configuration and page contents
//
function loadPage(p)
{
  makeHttpRequest("/hvi?file=" + datapage + "&pos1=" + pos1 + "&pos2=" + pos2, "bufferPage", p);
}

//
// bufferPage(p, page)
//
//  p:
//   1 - load page contents
//   2 - load configuration
//   3 - load configuration and page contents
//
//  page:
//   complete html page
//
function bufferPage(p, page)
{
  http_buffer = page;

  if (p == 1) {
    printData();    
  } else if(p == 2) {
    getConfig();      
  } else {
    if(getConfig() == 1) {
      loadPage(3);   
    } else {
      printData();  
    }
  }
}

//
// makeHttpRequest()
//
function makeHttpRequest(url, callback_function, callback_parameters, return_xml)
{
  var http_request = false;

  if (window.XMLHttpRequest) { // Mozilla, Safari,...
    http_request = new XMLHttpRequest();
  } else if (window.ActiveXObject) { // IE
    try {
      http_request = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
      try {
        http_request = new ActiveXObject("Microsoft.XMLHTTP");
      } catch (e) {}
    }
  }

  if (!http_request) {
    eval(callback_function + '("Unfortunatelly you browser doesn\'t support this feature.")');
    return false;
  }

  http_request.onreadystatechange = function() {
    if (http_request.readyState == 4) {
      try {
        if (http_request.status == 200) {
          if (return_xml) {
            eval(callback_function + '(' + callback_parameters + ', http_request.responseXML)');
          } else {
            eval(callback_function + '(' + callback_parameters + ', http_request.responseText)');
          }
        } else {
          http_status = 0;
          eval(callback_function + '(' + callback_parameters + ',"' + top.error_msg[0] + '")');
        }
      } catch(e) { }
      http_status = 0;
    }
  }
  
  http_request.open('GET', url, true);
  http_request.send(null);
  this.loadPageIndicator(1);
  http_status = 1;
}

//
// getConfig() - Get the configuration from HTML file. 
//
function getConfig()
{
  var legende = new Array();
  var leg_line = 0;

  //Get the data from the global buffer.
  var data_array = http_buffer.split('\n');

  //Update load indicator (green square).
  loadPageIndicator(0);

  if (top.viewmode == 0) { 
    //View mode = tft.
    buttons = 1; 
  } else {
    //View mode = pc.
    buttons = top.buttons;
  }

  for (var line_index in data_array) {
    var item_array = data_array[line_index].split(';');
    
    switch(item_array[0]) {
  	  case ':TITLE':
        title = item_array[1];
  	    break;
  	  case ':SUBTITLE':
        subtitle = item_array[1];
  	    break;
  	  case ':MAX':
        max_items = parseInt(item_array[1]);
  	    break;
  	  case ':MIN':
        min_items = parseInt(item_array[1]);
  	    break;
  	  case ':REFRESH_LOCK':
        refresh_lock = parseInt(item_array[1]);
  	    break;
  	  case ':TFT_NAVBAR':
        if (top.viewmode == 0) { //tft
          nav = parseInt(item_array[1]);
        }
  	    break;
  	  case ':TFT_EDIT':
        if (top.viewmode == 0) { //tft
          edit = parseInt(item_array[1]);
        }
  	    break;
  	  case ':TFT_PAGESIZE':
        if (top.viewmode == 0) { //tft
          pagesize = parseInt(item_array[1]);
        }
  	    break;
  	  case ':BEGINHELP':
  	    leg_line = 1;
  	    break;
  	  case ':ENDHELP':
  	    leg_line = 0;
  	    break;
     }

    if (leg_line > 1) {
      //Copy text line 'legende' array
      legende.push(data_array[line_index]);	
    }

    if (leg_line > 0) {
      leg_line++;
    }
  }

  var leg_str = legende.join('');     //Join 'legende' array to one string

  if (leg_str != '') {
    var html = new Array();
    var legende_div = document.getElementById('comment'); 
    html.push('<h1>' + top.legend_title + '</h1>');
    html.push(leg_str);
    legende_div.innerHTML = html.join(''); //Fill the div with help contents
    legende_div.style.display = 'block';   //Show the div
  }
  
  //Update the refresh state.
  if (refresh_lock == 0) {
    refresh = 0;	
  } else if(refresh_lock == 1) {
    refresh = 1;
  }

  var oldpos1 = pos1;
  var oldpos2 = pos2;

  //Set the pagesize to the maximum number of items in PC viewmode.
  if (top.viewmode == 1) {
    pagesize = max_items - min_items; 
  }
  
  loadPagePosition();

  //Create the navigation bar in TFT viewmode.
  if (top.viewmode == 0) {
    printNav();
  }
  
  //Initialize the refresh button of the inst_frame only in PC viewmode.
  if (top.viewmode == 1) {
    initRefreshButton();
  }

  switch(nav) {
    case 0:
      pos1 = min_items;
      pos2 = max_items;
      break;
    case 1:
      pos1 = min_items;
      pos2 = max_items;
      break;
    case 2:
      pos1 = min_items;
      pos2 = max_items;
      break;
    case 3:
    case 4:
      countPages();
      navText();
      break;  
    default:
      pos1 = min_items;
      pos2 = max_items;
      break;  
  }
  
  //If the row positions are not in sync load the page again.
  if((oldpos1 != pos1)||(oldpos2 != pos2)) {
    return 1;  
  }
  
  return 0;
}

//
// printData()
//
function printData() 
{ 
  var data_div = document.getElementById('data'); 

  var time1 = new Date().getTime();

  var e_row = new Array();   //column edit info
  var f_row = new Array();   //column format info
  var p_row = new Array();   //column parameter info
  var h_row = new Array();   //column header info
  var w_row = new Array();   //column width info
  var dotable = 0;
  var edit_naam;
  var edit_index;
  var row_index = -1;
  var t = new Array();       //table in html
  var h = new Array();       //table header in html
  var d = new Array();       //table data in html
  var data = new Array();    //all data in html
  var help = false;

  loadPageIndicator(0);

  var data_array = http_buffer.split('\n');

  for (var line_index in data_array) {
    if (data_array[line_index].substr(0,1) != ':') {
      //HTML-line
      if (!dotable && !help) { data.push(data_array[line_index]); }
    } else {
      //Data-line
      var item_array = data_array[line_index].split(';');
      //Update min_items and max_items for tables that grow in size.
      if (item_array[0] == ':MIN') {
        min_items = parseInt(item_array[1]);
        if (top.viewmode == 1) {
          pagesize = max_items - min_items; 
        }
      }
      if (item_array[0] == ':MAX') {
        max_items = parseInt(item_array[1]);
        if (top.viewmode == 1) {
          pagesize = max_items - min_items; 
        }
      }
      if (item_array[0] == ':BEGINHELP') {
        help = true;
      }
      if (item_array[0] == ':ENDHELP') {
        help = false;
      }
      if ((item_array[0] == ':BEGINTABLE') || (item_array[0] == ':BEGINMAINTABLE')) {
        t = null;
        d = null;
        h = null;
        e_row = null;
        f_row = null;
        p_row = null;
        h_row = null;
        w_row = null;
        t = new Array();
        h = new Array();
        d = new Array();
        e_row = new Array();
        f_row = new Array();
        p_row = new Array();
        h_row = new Array();
        w_row = new Array();
        t.push('<TABLE>');
        h.push('<THEAD>');
        d.push('<TBODY>');
        dotable = 1;
      }
      if (item_array[0] == ':BEGINTABLE') {
        dotable = 1;
      }
      if (item_array[0] == ':BEGINMAINTABLE') {
        dotable = 2;
        row_index = 0;
      }
      /* End table */
      if ((item_array[0] == ':ENDTABLE') || (item_array[0] == ':ENDMAINTABLE')) {
        /* Add tableheader to table  */
        h.push('</THEAD>');
        if (h.join('') != '<THEAD></THEAD>') {
          t.push(h.join(''));
        }
        /* Add tablebody to table */
        d.push('</TBODY>');
        if (d.join('') != '<TBODY></TBODY>') {
          t.push(d.join(''));
        }
        /* Add Table */
        t.push('</TABLE><BR>');
        if (t.join('') != '<TABLE></TABLE><BR>') {
          data.push(t.join(''));
        }
        dotable = 0;
      }
      /* Column options */
      if ((item_array[0] == ':E') && (dotable)) {
        for (var item_index in item_array) {
          if (item_index > 0) {
            e_row[item_index] = item_array[item_index];
            if (item_array[item_index - 1] == 'N') {
              edit_naam = item_index - 1;
            }
            if (item_array[item_index - 1] == 'I') {
              edit_index = item_index - 1;
            }
          }
        }
      }
      
      /* Formats */
      if ((item_array[0] == ':F') && (dotable)) {
        for (var item_index in item_array) {
          if (item_index > 0) {
            f_row[item_index] = item_array[item_index];
          }
        }
      }
      /* Parameters */
      if ((item_array[0] == ':P') && (dotable)) {
        while(p_row.pop()) {}
        for (var item_index in item_array) {
          if (item_index > 0) {
            p_row[item_index] = item_array[item_index];
          }
        }
      }
      /* Column width */
      if ((item_array[0] == ':W') && (dotable)) {
        while(w_row.pop()) {}
        for (var item_index in item_array) {
          if (item_index > 0) {
            w_row[item_index] = item_array[item_index];
          }
        }
      }
      /* Table header */
      if ((item_array[0] == ':H') && (dotable)) {
        h.push('<TR>');
        for (var item_index in item_array) {
          h_row[item_index] = item_array[item_index];
          if (item_index > 1) {
            h.push('<TD>' + item_array[item_index] + '</TD>');
          }
        }
        h.push('</TR>');
      }
      /* Table data */
      if ((item_array[0] == ':D') && (dotable)) {
        if ((nav == 3 || nav == 4) && (editpos == row_index) && (refresh == 0) && (edit == 1)) {
          d.push('<TR class="edit">');
        } else if((nav == 3 || nav == 4) && (refresh == 0) && (edit == 1)) {
          d.push('<TR onclick="changeEditPos(' + row_index + ')">');
        } else {
          d.push('<TR>');
        }
        for (var item_index in item_array) {
          if (item_index > 1) {
            /* Create column width item */
            width = (w_row[item_index] ? ' width="' + w_row[item_index] + '"' : '');

            if (nav < 3) {
              /* hole page view */
              if (((e_row[item_index] == 'U') || (e_row[item_index] == 'UB'))&& (refresh == 0)) {
                /* als deze kolom editable is en er mag gewijzigd worden */
                if (f_row[item_index] == 'UF') {
                  if (buttons) {
                    d.push('<TD' + width + ' class="edit"><BUTTON type="button" onclick=\'doUserFunction("' + p_row[item_index] + '","' + item_array[edit_index] + '")\'>' + item_array[item_index] + '</BUTTON></TD>');
                  } else {
                    d.push('<TD' + width + ' class="edit" ondblclick=\'doUserFunction("' + p_row[item_index] + '","' + item_array[edit_index] + '")\'>' + item_array[item_index] + '</TD>');
                  }
                } else {
                  if (buttons || (e_row[item_index] == 'UB')) {
                    d.push('<TD' + width + ' class="edit"><BUTTON type="button" onclick=\'doEdit("' + (h_row[item_index] ? h_row[item_index]: '') + ' ' + item_array[edit_naam] + ' = ' + item_array[item_index] + '","' + p_row[item_index] + '/' + item_array[edit_index] + '","' + f_row[item_index] + '")\'>' + item_array[item_index] + '</BUTTON></TD>');
                  } else {
                    d.push('<TD' + width + ' class="edit" ondblclick=\'doEdit("' + (h_row[item_index] ? h_row[item_index]: '') + ' ' + item_array[edit_naam] + ' = ' + item_array[item_index] + '","' + p_row[item_index] + '/' + item_array[edit_index] + '","' + f_row[item_index] + '")\'>' + item_array[item_index] + '</TD>');
                  }
                }
              } else {
                /* data gewoon laten zien */
                d.push('<TD' + width + '>' + item_array[item_index] + '</TD>');
              }
            } else {
              /* page view */
              if ((editpos == row_index) || (dotable == 1)) {
                /* rij mag gewijzigd worden */
                if (((e_row[item_index] == 'U') || (e_row[item_index] == 'UB')) && (refresh == 0)) {
                  /* kolom mag gewijzigd worden */
                  if (f_row[item_index] == 'UF') {
                    if (buttons) {
                      d.push('<TD' + width + ' class="edit"><BUTTON type="button" onclick=\'doUserFunction("' + p_row[item_index]+ '","' + item_array[edit_index] + '")\'>' + item_array[item_index] + '</BUTTON></TD>');
                    } else {
                      d.push('<TD' + width + ' class="edit" ondblclick=\'doUserFunction("' + p_row[item_index] + '","' + item_array[edit_index] + '")\'>' + item_array[item_index] + '</TD>');
                    }
                  } else {
                    if (buttons || (e_row[item_index] == 'UB')) {
                      d.push('<TD' + width + ' class="edit"><BUTTON type="button" onclick=\'doEdit("' + (h_row[item_index] ? h_row[item_index]: '') + ' ' + item_array[edit_naam] + ' = ' + item_array[item_index] + '","' + p_row[item_index] + '/' + item_array[edit_index] + '","' + f_row[item_index] + '")\'>' + item_array[item_index] + '</BUTTON></TD>');
                    } else {
                      d.push('<TD' + width + ' class="edit" ondblclick=\'doEdit("' + (h_row[item_index] ? h_row[item_index]: '') + ' ' + item_array[edit_naam] + ' = ' + item_array[item_index] + '","' + p_row[item_index] + '/' + item_array[edit_index] + '","' + f_row[item_index] + '")\'>' + item_array[item_index] + '</TD>');
                    }
                  }
                } else {
                  /* kolom mag niet gewijzigd worden; data laten zien */
                  d.push('<TD' + width + '>' + item_array[item_index] + '</TD>');
                }
              } else {
                /* rij mag niet gewijzigd worden; data laten zien */
                d.push('<TD' + width + '>' + item_array[item_index] + '</TD>');
              }
            }
          }
        }
        d.push('</TR>');
        if (dotable == 2) {
          row_index++;
        }
      }
    }
  }
  //Update the page counters, if we got new min/max values we need new amounts of pages.
  countPages();
  navText();
  
  //Push tables and html into the div.
  data_div.innerHTML = data.join('');

  if (title) {
    var title_div = document.getElementById('title'); 
    title_div.innerHTML = title;
  }

  if (subtitle) {
    var title2_div = document.getElementById('title2'); 
    title2_div.innerHTML = subtitle;
  }
  
  loadScrollPosition();
}

//
// printHTML()
//
function printHTML(data_string) 
{ 
  var data_div = document.getElementById('data'); 
  var s = new Array();
  var data_array = data_string.split('\n');

  for (var line_index in data_array) {
    if (data_array[line_index].substr(0,1) != ':') {
      s.push(data_array[line_index]);      
    }
  }
  
  data_div.innerHTML = s.join('');
}

//
// doEdit(label, parname, format)
//
function doEdit(label, parname, format) 
{
  document.settingstable.edit_caption.value = title;
  document.settingstable.edit_label.value = label;
  document.settingstable.edit_par.value = parname;
  document.settingstable.edit_format.value = format;

  switch( format )
  { 
    case "R1":
    case "R2":
        if(parname == "TIME.SYS/0")
        {
            document.settingstable.edit_mask.value = top.time_second_mask;
        }	
    case "P":
      document.settingstable.edit_file.value = "edit_r1_form.hvi";
      break;
    case "YYYYMMDD":
      document.settingstable.edit_file.value = "edit_yyyymmdd_form.hvi";
      break;
    case "R20":
      document.settingstable.edit_file.value = "edit_r20_form.hvi";
      break;
    case "R21":
      document.settingstable.edit_file.value = "edit_r21_form.hvi";
      break;
    case "TPGM":
      document.settingstable.edit_file.value = "edit_tpgm_form.hvi";
      break;
    case "TPGF":
      document.settingstable.edit_file.value = "edit_tpgf_form.hvi";
      break;
    case "DET":
      document.settingstable.edit_file.value = "edit_det_form.hvi";
      break;
    case "SG":
      document.settingstable.edit_file.value = "edit_sg_form.hvi";
      break;
    case "PERA":
      document.settingstable.edit_file.value = "edit_pera_form.hvi";
      break;
    case "MDAY":
      document.settingstable.edit_file.value = "edit_mday_form.hvi";
      break;
    case "KARDET":
      document.settingstable.edit_file.value = "edit_kardet_form.hvi";
      break;
	case "VCULOOP":
      document.settingstable.edit_file.value = "edit_vculoop_form.hvi";
      break;
    case "KARLM":
      document.settingstable.edit_file.value = "edit_karlm_form.hvi";
      break;
    case "BDAY":
      document.settingstable.edit_file.value = "edit_bday_form.hvi";
      break;
    case "WDAY":
      document.settingstable.edit_file.value = "edit_wday_form.hvi";
      break;
    case "TBUCHF":
      document.settingstable.edit_file.value = "edit_tbuchf_form.hvi";
      break;
    case "R11":
      document.settingstable.edit_mask.value = top.time_mask;
      document.settingstable.edit_file.value = "edit_r1_form.hvi";
      break;
    case "PTDET":
      document.settingstable.edit_file.value = "edit_ptdet_form.hvi";
      break;
    case "PTVEHTYPE":
      document.settingstable.edit_file.value = "edit_ptveh_type_form.hvi";
      break;
    case "PTVEHSTAT":
      document.settingstable.edit_file.value = "edit_ptveh_status_form.hvi";
      break;
    case "PTVEHPRIO":
      document.settingstable.edit_file.value = "edit_ptveh_prioclass_form.hvi";
      break;
    case "PTVEHPUNCC":
      document.settingstable.edit_file.value = "edit_ptveh_puncclass_form.hvi";
      break;
    case "PTVEHCLEAR":
      document.settingstable.edit_file.value = "edit_ptveh_condclear_form.hvi";
      break;
    case "PTVEHLINE":
      document.settingstable.edit_file.value = "edit_ptveh_linenr_form.hvi";
      break;
    case "PTVEHPUNCT":
      document.settingstable.edit_file.value = "edit_ptveh_punctime_form.hvi";
      break;
    case "TRAFFICCAT":
      document.settingstable.edit_file.value = "edit_xprio_trafficcat_form.hvi";
      break;
    case "DSIEVTYPE":
      document.settingstable.edit_file.value = "edit_xprio_dsievtype_form.hvi";
      break;
    case "PUNCCLASS":
      document.settingstable.edit_file.value = "edit_xprio_puncclass_form.hvi";
      break;
    case "OTUINV":
      document.settingstable.edit_file.value = "edit_otuinv_form.hvi";
      break;
    case "UG405OPMF":
      document.settingstable.edit_file.value = "edit_UG405_operational_form.hvi";
      break;
    default:
      document.settingstable.edit_file.value = "edit_r1_form.hvi";
      break;
  }
    
  savePagePosition();
  document.settingstable.submit();    
}

//
// doUserFunction(uf, val)
//
function doUserFunction(uf,val) 
{
  savePagePosition();
  if (val) {
    top.doUFHref(datapage,uf,val);
  } else {
    top.doUFHref(datapage,uf);
  }
}

//
// printNav()
//
function printNav()
{
  var s = new Array();
  var s2 = new Array();

  switch(nav) {
    case 0: 
      s.push('');	
      break;
    case 1:
      s.push('<form name="NavForm">');
      s.push('<table cellpadding="0" cellspacing="0" border="0" width="100%">');
      s.push('<tr><td align="left">');
      s.push('<button type="button" class="big" OnClick="top.doBack()">' + BTN_BACK_TEXT + '</button>');
      s.push('</td></tr>');
      s.push('</table>');
      s.push('</form>');
      break;
    case 2:
      s.push('<form name="NavForm">');
      s.push('<table cellpadding="0" cellspacing="0" border="0" width="100%">');
      s.push('<tr><td align="left">');
      s.push('<button type="button" class="big" OnClick="top.doBack()">' + BTN_BACK_TEXT + '</button>');
      s.push('</td><td align="right">');
      if (!edit) {
        if (refresh == 0) {
          s.push('<button type="button" class="big" id="refresh_button" OnClick="doNavRefresh()">' + BTN_REFRESH_TEXT1 + '</button>');
        } else {
          s.push('<button type="button" class="big" id="refresh_button" OnClick="doNavRefresh()">' + BTN_REFRESH_TEXT2 + '</button>');
        }
      } else {
        if (refresh == 0) {
          s.push('<button type="button" class="big" id="refresh_button" OnClick="doNavRefresh()">' + BTN_EDIT_TEXT1 + '</button>');
        } else {
          s.push('<button type="button" class="big" id="refresh_button" OnClick="doNavRefresh()">' + BTN_EDIT_TEXT2 + '</button>');
        }
      }
      s.push('</td></tr>');
      s.push('</table>');
      s.push('</form>');
      break;
    case 3: //controls: back, <|, <, >, >|, freeze
      s.push('<form name="NavForm">');
      s.push('<table cellpadding="0" cellspacing="0" border="0" width="100%">');
      s.push('<tr><td align="left">');
      s.push('<button type="button" class="big" OnClick="top.doBack()">' + BTN_BACK_TEXT + '</button>');
      s.push('</td><td align="center" width="100%">');
      s.push('<button type="button" OnClick="doNavBegin()">|&lt;</button>');
      s.push('<button type="button" OnClick="doNavPrevPage()">&lt;</button>');
      s.push('<input type="text" name="tekst">');
      s.push('<button type="button" OnClick="doNavNextPage()">&gt;</button>');
      s.push('<button type="button" OnClick="doNavEnd()">&gt;|</button>');
      s.push('</td>');
      s.push('<td align="right">');
      if (!edit) {
        if (refresh == 0) {
          s.push('<button type="button" class="big" id="refresh_button" OnClick="doNavRefresh()">' + BTN_REFRESH_TEXT1 + '</button>');
        } else {
          s.push('<button type="button" class="big" id="refresh_button" OnClick="doNavRefresh()">' + BTN_REFRESH_TEXT2 + '</button>');
        }
      } else {
        if (refresh == 0) {
          s.push('<button type="button" class="big" id="refresh_button" OnClick="doNavRefresh()">' + BTN_EDIT_TEXT1 + '</button>');
        } else {
          s.push('<button type="button" class="big" id="refresh_button" OnClick="doNavRefresh()">' + BTN_EDIT_TEXT2 + '</button>');
        }
      }
      s.push('</td></tr>');
      s.push('</table>');
      s.push('</form>');
      break;
    case 4: //controls: back, <|, <<, <, >, >>, >|, freeze
      s.push('<form name="NavForm">');
      s.push('<table cellpadding="0" cellspacing="0" border="0" width="100%">');
      s.push('<tr><td align="left">');
      s.push('<button type="button" class="big" OnClick="top.doBack()">' + BTN_BACK_TEXT + '</button>');
      s.push('</td><td align="right" width="40%">');
      s.push('<button type="button" OnClick="doNavBegin()">|&lt;</button>');
      s.push('<button type="button" OnClick="doNavPrevPages(10)">&lt;&lt;</button>');
      s.push('<button type="button" OnClick="doNavPrevPage()">&lt;</button>');
      s.push('</td><td align="center" width="20%">');
      s.push('<input type="text" name="tekst">');
      s.push('<input type="text" name="tekst2">');
      s.push('</td><td align="left" width="40%">');
      s.push('<button type="button" OnClick="doNavNextPage()">&gt;</button>');
      s.push('<button type="button" OnClick="doNavNextPages(10)">&gt;&gt;</button>');
      s.push('<button type="button" OnClick="doNavEnd()">&gt;|</button>');
      s.push('</td>');
      s.push('<td align="right">');
      if (!edit) {
        if (refresh == 0) {
          s.push('<button type="button" class="big" id="refresh_button" OnClick="doNavRefresh()">' + BTN_REFRESH_TEXT1 + '</button>');
        } else {
          s.push('<button type="button" class="big" id="refresh_button" OnClick="doNavRefresh()">' + BTN_REFRESH_TEXT2 + '</button>');
        }
      } else {
        if (refresh == 0) {
          s.push('<button type="button" class="big" id="refresh_button" OnClick="doNavRefresh()">' + BTN_EDIT_TEXT1 + '</button>');
        } else {
          s.push('<button type="button" class="big" id="refresh_button" OnClick="doNavRefresh()">' + BTN_EDIT_TEXT2 + '</button>');
        }
      }
      s.push('</td></tr>');
      s.push('</table>');
      s.push('</form>');
      break;
    case 10:
      s2.push('<br /><br /><br /><br /><br /><br /><br /><br /><ul>');
      s2.push('<li><button type=button OnClick=\'top.doDataHref("cell1370.hvi",1)\'>' + top.error_msg[1] + '</button></li>');
      s2.push('<li><button type=button OnClick=\'top.doDataHref("cell1240.hvi",1)\'>' + top.error_msg[2] + '</button></li>');
      s2.push('<li><button type=button OnClick=\'top.doHref("detswico.hvi",1)\'>' + top.error_msg[10] + '</button></li>');
      s2.push('</ul>');
      break;
    default:
      s.push('');	
      break;
  }
  
  nav_div = document.getElementById('nav'); 
  
  nav_div.innerHTML = s.join('');

  nav_home_div = document.getElementById('nav_home'); 
  
  nav_home_div.innerHTML = s2.join('');
}

//
// doNavRefresh()
//
function doNavRefresh()
{
  if (!edit) {
    if (refresh == 0) {
      document.getElementById("refresh_button").innerHTML = BTN_REFRESH_TEXT2;
      refresh = 1;
    } else {
      document.getElementById("refresh_button").innerHTML = BTN_REFRESH_TEXT1;
      refresh = 0;
    }
  } else {
    if (refresh == 0) {
      document.getElementById("refresh_button").innerHTML = BTN_EDIT_TEXT2;
      refresh = 1;
    } else {
      document.getElementById("refresh_button").innerHTML = BTN_EDIT_TEXT1;
      refresh = 0;
    }
  }
  
  loadPage(1);
}

//
// doNavBegin()
//
function doNavBegin() 
{
  if ((refresh == 0) && (edit)) {
    editpos = 0;
  } else {
    page = 0;
  }
  navText();
  if(refresh == 0) { 
    if (edit == 1) {
      printData();
    } else {
      loadPage(1);
    }
  }
}

//
// doNavEnd()
//
function doNavEnd() 
{
  if ((refresh == 0) && (edit)) {
    if (page == (maxpage-1)) {
      editpos = lastpagesize - 1;
    } else {
      editpos = pagesize - 1;
    }
  } else {
    page = maxpage - 1;
    if (editpos >= lastpagesize) {
      editpos = lastpagesize - 1;
    }
  }
  navText();
  if(refresh == 0) { 
    if (edit == 1) {
      printData();
    } else {
      loadPage(1);
    }
  }
}

//
// doNavNextPages()
// 
// step size can be passed as an argument
// e.g. doNavNextPages(10) will step 10 pages forward
//
function doNavNextPages(step) 
{
  var i = 0;
  
  if (step == null || step < 0) {
	step = 1;
  }
  
  for (i=0;i<step;i++)
  {
	doNavNextPage();
  }
}

//
// doNavNextPage()
// 
function doNavNextPage() 
{
  var load;

  if(edit == 1) { 
    load = 1;
  }
  
  if((refresh == 0) && (edit)) 
  {
    if (page == (maxpage-1)) 
    {
      if (editpos < (lastpagesize-1)) 
      {
		editpos++;
      }
    } 
    else 
    {  
      if (editpos < (pagesize-1)) 
      {
		editpos++;
      } 
      else 
      {
        editpos = 0;
		page++;
        load = 0;
      }
    }
  } else {
    if (page < (maxpage-1)) {
	  page++;
      if ((page == (maxpage-1)) && (editpos > lastpagesize)) {
        editpos = lastpagesize;
      }
    }
  }
  navText();
  if (refresh == 0) {
    if (load == 1) {
      printData();
    } else {
      loadPage(1);  
    }
  }
}

//
// doNavPrevPages()
// 
// step size can be passed as an argument
// e.g. doNavPrevPages(10) will step 10 pages backward
//
function doNavPrevPages(step) 
{
  var i = 0;
  
  if (step == null || step < 0) {
	step = 1;
  }
  
  for (i=0;i<step;i++)
  {
	doNavPrevPage();
  }
}

//
// doNavPrevPage()
//
function doNavPrevPage() 
{
  var load;

  if(edit == 1) { 
    load = 1;
  }
  
  if ((refresh == 0) && (edit)) {
    if (page == 0) {
      if (editpos > 0) {
		editpos--;
      }
    } else {
      if (editpos > 0) {
		editpos--;
      } else {
        editpos = pagesize - 1;
		page--;
        load = 0;
      }
    }
  } else {
    if (page > 0) {
	  page--;
    }
  }
  navText();
  if (refresh == 0) {
    if (load == 1) {
      printData();
    } else {
      loadPage(1);  
    }
  }
}

//
// navText()
//
function navText()
{
  makePos();
  var temp1 = pos1 + editpos - min_items + 1;
  var temp2 = max_items - min_items;
  if (document.NavForm != undefined && document.NavForm.tekst != undefined)
  {
	if (document.NavForm.tekst2 != undefined && nav == 4)
	{
		document.NavForm.tekst.value = "" + temp1;
		document.NavForm.tekst2.value = "" + "/" + temp2;
	}
	else
	{
		document.NavForm.tekst.value = "" + temp1 + "/" + temp2;
	}
  }
}

//
// makePos()
//
function makePos()
{
  pos1 = (page * pagesize) + min_items;
  pos2 = pos1 + pagesize - 1;
  if (pos1 > max_items)
  {
    page = 0;
    pos1 = min_items;
    pos2 = pos1 + pagesize - 1;
  }
}

//
// countPages()
//
function countPages()
{
  maxpage = parseInt((max_items - min_items) / pagesize);
  lastpagesize = parseInt((max_items - min_items) % pagesize);
  if(lastpagesize == 0) 
  {
    if(maxpage) 
    {
      lastpagesize = pagesize;
    }
    else
    {
      /* No data */
      lastpagesize = 0;
      maxpage = 1; 
    }
  }
  else
  {
    maxpage++; 
  }
}

//
// savePagePosition()
//
function savePagePosition()
{
  top.dp_datapage = datapage;
  top.dp_page     = page;
  top.dp_editpos  = editpos;
  top.dp_refresh  = refresh;
  top.dp_scroll_line = (document.all) ? document.documentElement.scrollTop : window.pageYOffset;
}

//
// loadPagePosition()
//
function loadPagePosition() 
{
  if(top.dp_datapage == datapage) {
    page    = top.dp_page;
    editpos = top.dp_editpos;
    refresh = top.dp_refresh;
  } else {
    clearPagePosition();  
  }
}

//
// clearPagePosition()
//
function clearPagePosition()
{
  top.dp_datapage = "";
  top.dp_page     = null;
  top.dp_editpos  = null;
  top.dp_refresh  = null;
  top.dp_scroll_line = null;
}

//
// loadScrollPosition() - Load the old scrollposition.
//
function loadScrollPosition() 
{
  if(top.dp_datapage == datapage) {
    window.scrollBy(0, top.dp_scroll_line); 
  }
}

//
// loadPageIndicator(s) - Update the page load indicator.
//
//  s:
//   0 - off
//   1 - on
//
function loadPageIndicator(s)
{
  var load_div;
  
  // check if inst_frame exists
  if (top.frames['inst_frame']) {
    load_div = top.inst_frame.document.getElementById('loadind'); 
  }
  
  if (load_div) {
    if (s) {
      load_div.style.backgroundColor = '#00c700';  //green
    } else {
      load_div.style.backgroundColor = '#DDDDDD';  //grey
    }    
  } 
}

//
// checkBrowserMode()
//
function checkBrowserMode()
{
  err = 0;
  
  // check if browser can handle W3C DOM
  if (!document.getElementById) {
    err = 1;
  }
  
  //Check if browser supports javascript http requests
  if ((!window.XMLHttpRequest)&&(!window.ActiveXObject)) {
    err = 2;
  }

  //Check if this page is loaded in index.html
  if (parent == self) {
    top.location.href = "index.html";
  }

  //check for history
  if (!top.historyArray[0]) {
    /* Jump to first page */
    top.doDataHref(top.homepage,0);  
  }
  
  return err;
}

//
// changeEditPos(p) - Change the edit row position of the table. (TFT only)
//
function changeEditPos(p)
{
  editpos = p;        //update edit position (row in table)
  loadPage(1);        //rebuild page
  navText();          //update the text in the navigationbar
}


//
// initRefreshButton() - Initializes the refresh button in the inst_frame. (PC only)
//
function initRefreshButton()
{
  if (top.frames['inst_frame']) {         //check if inst_frame exists
    var but = top.inst_frame.document.getElementById('refresh_button');
    if (but) {                            //check if button exists
      if (refresh_lock == -1) {           //if there is no refresh_lock
        refresh = top.inst_frame.refresh; //update refresh with the state of the button
      }
      updateRefreshButton();
      but.onclick = updateRefreshButton;  //register onclick function
    } 
  }
}

//
// updateRefreshButton() - Sync the refresh button in the inst_frame with the refresh state. (PC only)
//
function updateRefreshButton() {
  switch(refresh_lock) {
    case -1:                     //no refresh_lock -> show button
      if (refresh == 1) {
        refresh = 0;
      } else {
        refresh = 1;
      }
      printData();               //rebuild the page without loading it
      top.frames['inst_frame'].updateButton(refresh);
      break;
    case 0:                      //refresh_lock is 'on' -> hide button
    case 1:
    default:
      top.frames['inst_frame'].updateButton(2);
      break;
   }
}
