<?php
session_start();

// Pārbaudiet, vai lietotājs ir pieslēdzies
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: ../login.html");
    exit;
}

$user_id = $_SESSION["id_user"];
$name = $_POST['name'];
$author = $_POST['author'];
$year = $_POST['year'];
$price = $_POST['price'];
$genre = $_POST['genre'];
$type = $_POST['type'];
$id_list = isset($_POST['id_list']) ? $_POST['id_list'] : '';

// Pieslēgums datubāzei
include "connection.php";

// Pārbauda vai žanrs eksistē
$stmt = $conn->prepare("SELECT id_genre FROM dv_book_genre WHERE genre = ?");
$stmt->bind_param("s", $genre);
$stmt->execute();
$stmt->bind_result($id_genre);
$stmt->fetch();
$stmt->close();

if (!$id_genre) {
    // Ja žanrs neeksistē, ievieto jaunu
    $stmt = $conn->prepare("INSERT INTO dv_book_genre(genre) VALUES (?)");
    $stmt->bind_param("s", $genre);
    $stmt->execute();
    $id_genre = $stmt->insert_id;
    $stmt->close();
}

// Pārbauda vai tips eksistē
$stmt = $conn->prepare("SELECT id_type FROM dv_book_type WHERE type = ?");
$stmt->bind_param("s", $type);
$stmt->execute();
$stmt->bind_result($id_type);
$stmt->fetch();
$stmt->close();

if (!$id_type) {
    // Ja tips neeksistē, ievieto jaunu
    $stmt = $conn->prepare("INSERT INTO dv_book_type(type) VALUES (?)");
    $stmt->bind_param("s", $type);
    $stmt->execute();
    $id_type = $stmt->insert_id;
    $stmt->close();
}

if ($id_list) {
    // Labo esošo grāmatu
    $stmt = $conn->prepare("UPDATE dv_book_parameter bp
                            JOIN dv_book_list bl ON bp.id_par = bl.id_par
                            SET bp.name = ?, bp.author = ?, bp.year = ?, bp.price = ?, bl.id_genre = ?, bl.id_type = ?
                            WHERE bl.id_list = ?");
    $stmt->bind_param("sssdiis", $name, $author, $year, $price, $id_genre, $id_type, $id_list);
    $stmt->execute();
    $stmt->close();
} else {
    // Pievieno jaunu grāmatu
    // Ievieto grāmatas parametrus
    $stmt = $conn->prepare("INSERT INTO dv_book_parameter(name, author, year, price) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("sssd", $name, $author, $year, $price);
    $stmt->execute();
    $id_par = $stmt->insert_id;
    $stmt->close();

    // Ievieto grāmatu sarakstā
    $stmt = $conn->prepare("INSERT INTO dv_book_list(id_genre, id_type, id_par) VALUES (?, ?, ?)");
    $stmt->bind_param("iii", $id_genre, $id_type, $id_par);
    $stmt->execute();
    $id_list = $stmt->insert_id;
    $stmt->close();

    // Saista grāmatu ar lietotāju
    $stmt = $conn->prepare("INSERT INTO dv_user_list(id_user, id_list) VALUES (?, ?)");
    $stmt->bind_param("ii", $user_id, $id_list);
    $stmt->execute();
    $stmt->close();
}

// Pēc veiksmīgas pievienošanas vai labojuma, pāradresējiet uz saraksta lapu
header("location: ../index.php");
exit;
?>