<?php
require_once "connection.php";

session_start();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['check_username'])) {
        // Apstrādā AJAX pieprasījumu, lai pārbaudītu, vai lietotājvārds eksistē
        $username = trim($_POST["username"]);

        $sql_check_username = "SELECT id_user FROM dv_user WHERE username = ?";
        if ($stmt_check_username = mysqli_prepare($conn, $sql_check_username)) {
            mysqli_stmt_bind_param($stmt_check_username, "s", $username);
            if (mysqli_stmt_execute($stmt_check_username)) {
                mysqli_stmt_store_result($stmt_check_username);
                if (mysqli_stmt_num_rows($stmt_check_username) > 0) {
                    echo "exists";
                } else {
                    echo "available";
                }
            } else {
                echo "error";
            }
            mysqli_stmt_close($stmt_check_username);
        }
        mysqli_close($conn);
        exit;
    }

    if (isset($_POST['register'])) {
        // Apstrādā veidlapas iesniegšanu
        $username = trim($_POST["username"]);
        $password = trim($_POST["password"]);
        $confirm_password = trim($_POST["confirm_password"]);

        $error = "";

        if (empty($username) || empty($password) || empty($confirm_password)) {
            $error .= "Lūdzu, aizpildiet visus laukus. ";
        }

        if ($password !== $confirm_password) {
            $error .= "Paroles nesakrīt. ";
        }

        $sql_check_username = "SELECT id_user FROM dv_user WHERE username = ?";
        if ($stmt_check_username = mysqli_prepare($conn, $sql_check_username)) {
            mysqli_stmt_bind_param($stmt_check_username, "s", $param_username);
            $param_username = $username;
            if (mysqli_stmt_execute($stmt_check_username)) {
                mysqli_stmt_store_result($stmt_check_username);
                if (mysqli_stmt_num_rows($stmt_check_username) > 0) {
                    $error .= "Lietotājvārds jau eksistē. ";
                }
            } else {
                $error .= "Kaut kas nogāja greizi, pārbaudot lietotājvārdu. ";
            }
            mysqli_stmt_close($stmt_check_username);
        } else {
            $error .= "Kaut kas nogāja greizi, gatavojot lietotājvārda pārbaudi. ";
        }

        if (empty($error)) {
            $sql = "INSERT INTO dv_user (username, password, sign_up_date) VALUES (?, ?, CURDATE())";

            if ($stmt = mysqli_prepare($conn, $sql)) {
                mysqli_stmt_bind_param($stmt, "ss", $param_username, $param_password);

                $param_username = $username;
                $param_password = password_hash($password, PASSWORD_DEFAULT);

                if (mysqli_stmt_execute($stmt)) {
                    echo "success";
                    exit;
                } else {
                    echo "Kaut kas nogāja greizi. Lūdzu, mēģiniet vēlreiz vēlāk.";
                }

                mysqli_stmt_close($stmt);
            } else {
                echo "Kaut kas nogāja greizi, sagatavojot ievietošanas paziņojumu.";
            }
        } else {
            echo $error;
        }

        mysqli_close($conn);
    }
}
?>