<?php
// Iekļauj konfigurācijas failu
require_once "connection.php";

// Sāk sessiju ja tā vēl nav sākta
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Pārbauda, vai lietotājs jau ir pieslēdzies
if (isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true) {
    echo "success";
    exit;
}

// Pārbauda, vai ir iesniegta pieteikšanās veidlapas
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['login'])) {
    // Saglabā mainīgos no POST formas
    $username = trim($_POST["username"]);
    $password = trim($_POST["password"]);

    // Pārbauda, vai lietotājvārds un parole ir ievadīti
    if (empty($username) || empty($password)) {
        echo "Lūdzu, aizpildiet visus laukus.";
        exit;
    }

    // Sagatavo vaicājumu, lai izvēlētos lietotāju no datubāzes
    $sql = "SELECT id_user, username, password FROM dv_user WHERE username = ?";

    if ($stmt = mysqli_prepare($conn, $sql)) {
        // Piesaista mainīgos vaicājumam kā parametrus
        mysqli_stmt_bind_param($stmt, "s", $param_username);

        $param_username = $username;

        // Mēģina izpildīt sagatavoto vaicājumu
        if (mysqli_stmt_execute($stmt)) {
            // Saglabā rezultātu
            mysqli_stmt_store_result($stmt);

            // Pārbauda, vai lietotājvārds eksistē un pārbaudiet paroli
            if (mysqli_stmt_num_rows($stmt) == 1) {
                // Ja lietotājvārds eksistē, saņem rezultātu
                mysqli_stmt_bind_result($stmt, $id_user, $username, $hashed_password);
                if (mysqli_stmt_fetch($stmt)) {
                    if (password_verify($password, $hashed_password)) {
                        // Ja parole ir pareiza, sāk jaunu sesiju
                        // Saglabā datus sesijas mainīgajos
                        $_SESSION["loggedin"] = true;
                        $_SESSION["id_user"] = $id_user;
                        $_SESSION["username"] = $username;

                        // Pāradresē lietotāju uz galveno lapu
                        echo "success";
                    } else {
                        // Ja parole nav pareiza, izvada kļūdas ziņojumu
                        echo "password_incorrect";
                    }
                }
            } else {
                // Ja lietotājvārds neeksistē, izvada kļūdas ziņojumu
                echo "username_not_found";
            }
        } else {
            echo "Kaut kas nogāja greizi. Lūdzu, mēģiniet vēlreiz vēlāk.";
        }

        // Aizver vaicājumu
        mysqli_stmt_close($stmt);
    }

    // Aizver savienojumu ar datu bāzi
    mysqli_close($conn);
}
?>