<?php
session_start();

// Pārbauda, vai lietotājs ir pieslēdzies
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    exit;
}

// Pieslēgums datubāzei
include "connection.php";

$id_list = $_POST['id_list'];

// Dzēst ierakstu no dv_user_list
$stmt = $conn->prepare("DELETE FROM dv_user_list WHERE id_list = ?");
$stmt->bind_param("i", $id_list);
$stmt->execute();
$stmt->close();

// Dzēst ierakstu no dv_book_list
$stmt = $conn->prepare("DELETE FROM dv_book_list WHERE id_list = ?");
$stmt->bind_param("i", $id_list);
$stmt->execute();
$stmt->close();

// Pārbauda, vai parametru tabula tiek izmantota citur, ja nē, dzēš šo ierakstu
$stmt = $conn->prepare("SELECT COUNT(*) FROM dv_book_list WHERE id_par = (SELECT id_par FROM dv_book_list WHERE id_list = ?)");
$stmt->bind_param("i", $id_list);
$stmt->execute();
$stmt->bind_result($count);
$stmt->fetch();
$stmt->close();

if ($count == 0) {
    $stmt = $conn->prepare("DELETE FROM dv_book_parameter WHERE id_par = (SELECT id_par FROM dv_book_list WHERE id_list = ?)");
    $stmt->bind_param("i", $id_list);
    $stmt->execute();
    $stmt->close();
}

echo "Grāmata veiksmīgi dzēsta.";
?>