function validateRegisterForm() {
    var isValid = true;
    var username = document.getElementById("username");
    var password = document.getElementById("password");
    var confirmPassword = document.getElementById("confirm_password");

    // Nodzēš iepriekšējās kļūdas paziņojumu
    document.querySelectorAll('.error-message').forEach(function (el) {
        el.textContent = "";
    });
    document.querySelectorAll('.input-field').forEach(function (el) {
        el.classList.remove('error');
    });

    // Lietotājvārda pārbaude
    if (username.value.trim() === "") {
        username.parentElement.classList.add("error");
        document.getElementById("usernameError").textContent = "Lūdzu, aizpildiet lietotājvārda lauku.";
        isValid = false;
    }

    // Paroles pārbude
    if (password.value.trim() === "") {
        password.parentElement.classList.add("error");
        document.getElementById("passwordError").textContent = "Lūdzu, aizpildiet paroles lauku.";
        isValid = false;
    } else if (password.value.trim().length < 6) {
        password.parentElement.classList.add("error");
        document.getElementById("passwordError").textContent = "Parolei jābūt vismaz 6 simboliem garai.";
        isValid = false;
    } else if (password.value.includes(" ")) {
        password.parentElement.classList.add("error");
        document.getElementById("passwordError").textContent = "Parolē nevar būt atstarpes.";
        isValid = false;
    }

    //Atkārtotās paroles ievadlauka pārbude
    if (confirmPassword.value.trim() === "") {
        confirmPassword.parentElement.classList.add("error");
        document.getElementById("confirmPasswordError").textContent = "Lūdzu, aizpildiet atkārtotās paroles lauku.";
        isValid = false;
    }
    // Pārbauda, vai parole un atkārtotā parole sakrīt
    if (password.value !== confirmPassword.value) {
        confirmPassword.parentElement.classList.add("error");
        document.getElementById("confirmPasswordError").textContent = "Paroles nesakrīt.";
        isValid = false;
    }

    // Ja pārbaude veiksmīga, tiek veikta lietotājvārda pārbaude
    if (isValid) {
        console.log("Pārbaude ir veiksmīga, pārbauda lietotājvārda esamību...");

        var xhr = new XMLHttpRequest();
        xhr.open("POST", "php/register.php", true);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4) {
                console.log("AJAX pieprasījums pabeigts ar statusu: " + xhr.status);
                if (xhr.status === 200) {
                    var response = xhr.responseText.trim();
                    console.log("Atbilde no servera: " + response);
                    if (response === "exists") {
                        document.getElementById("usernameError").textContent = "Lietotājvārds jau eksistē.";
                        username.parentElement.classList.add("error");
                    } else if (response === "available") {
                        // Ja lietotājs neeksistē, tiek iesūtīta reģistrācijas forma
                        console.log("Lietotājvārds pieejams, iesniedz formu...");
                        var registerXhr = new XMLHttpRequest();
                        registerXhr.open("POST", "php/register.php", true);
                        registerXhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                        registerXhr.onreadystatechange = function () {
                            if (registerXhr.readyState === 4) {
                                console.log("Formas iesniegšanas pieprasījums pabeigts ar statusu: " + registerXhr.status);
                                if (registerXhr.status === 200) {
                                    var registerResponse = registerXhr.responseText.trim();
                                    console.log("Atbilde no servera par formas iesniegšanu: " + registerResponse);
                                    if (registerResponse === "success") {
                                        // Pēc veiksmīgas reģistrācijas novirzīt uz pieteikšanās lapu
                                        alert("Reģistrācija veiksmīga!");
                                        window.location.href = 'login.html';
                                    } else {
                                        console.log("Negaidīta atbilde par formas iesniegšanu: " + registerResponse);
                                    }
                                } else {
                                    console.log("Servera kļūda formas iesniegšanas laikā: " + registerXhr.statusText);
                                }
                            }
                        };
                        var formData = "username=" + encodeURIComponent(username.value.trim()) +
                            "&password=" + encodeURIComponent(password.value.trim()) +
                            "&confirm_password=" + encodeURIComponent(confirmPassword.value.trim()) +
                            "&register=true";
                        registerXhr.send(formData);
                    } else {
                        console.log("Negaidīta atbilde no servera: " + response);
                    }
                } else {
                    console.log("Servera kļūda: " + xhr.statusText);
                }
            }
        };
        xhr.send("username=" + encodeURIComponent(username.value.trim()) + "&check_username=true");
    } else {
        console.log("Pārbaude neveiksmīga.");
    }

    // Novērst formas nosūtīšanu pēc noklusējuma
    return false;
}