function validateLoginForm() {
    var isValid = true;
    var username = document.getElementById("username");
    var password = document.getElementById("password");

    // Nodzēš iepriekšējās kļūdas paziņojumu
    document.querySelectorAll('.error-message').forEach(function (el) {
        el.textContent = "";
    });
    document.querySelectorAll('.input-field').forEach(function (el) {
        el.classList.remove('error');
    });

    // Lietotājvārda pārbaude
    if (username.value.trim() === "") {
        username.parentElement.classList.add("error");
        document.getElementById("usernameError").textContent = "Lūdzu, aizpildiet lietotājvārda lauku.";
        isValid = false;
    }

    // Paroles pārbude
    if (password.value.trim() === "") {
        password.parentElement.classList.add("error");
        document.getElementById("passwordError").textContent = "Lūdzu, aizpildiet paroles lauku.";
        isValid = false;
    }

    // Veic pieprasījumu uz serveri, lai pārbaudītu lietotāja ievadīto informāciju
    if (isValid) {
        var xhr = new XMLHttpRequest();
        xhr.open("POST", "php/login.php", true);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4 && xhr.status === 200) {
                console.log("Atbilde: " + xhr.responseText);
                var response = xhr.responseText.trim();
                if (response === "password_incorrect") {
                    document.getElementById("passwordError").textContent = "Nepareiza parole!";
                    document.getElementById("password").parentElement.classList.add("error");
                } else if (response === "username_not_found") {
                    document.getElementById("usernameError").textContent = "Lietotājvārds nav atrasts!";
                    document.getElementById("username").parentElement.classList.add("error");
                } else if (response === "success") {
                    console.log("Pieteikšanās veiksmīga, novirza...");
                    window.location.href = 'index.php';
                } else {
                    console.error("Negaidīta atbilde: " + response);
                }
            }
        };
        xhr.send("username=" + encodeURIComponent(username.value.trim()) + "&password=" + encodeURIComponent(password.value.trim()) + "&login=true");
    }

    // Novērst formas nosūtīšanu pēc noklusējuma
    return false;
}
