<?php
// Sākt sesiju ar drošības parametriem
if (session_status() == PHP_SESSION_NONE) {
    session_start([
        'cookie_lifetime' => 86400,
        'cookie_secure' => true,
        'cookie_httponly' => true,
        'use_strict_mode' => true,
    ]);
}
// Lietotāja neaktivitātes laiks sekundēs 
define('INACTIVITY_TIMEOUT', 1200);

if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY'] > INACTIVITY_TIMEOUT)) {
    session_unset();
    session_destroy();
    header("location: login.html");
    exit;
}
$_SESSION['LAST_ACTIVITY'] = time();

include "php/connection.php";

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: login.html");
    exit;
}

$user_id = $_SESSION["id_user"];
?>

<!DOCTYPE html>
<html lang="lv">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Grāmatu Saraksts</title>
    <link rel="stylesheet" href="css/index.css">
</head>

<body>
    <div class="top-bar">
        <span class="username">
            <?php
            if (isset($_SESSION["username"])) {
                echo htmlspecialchars($_SESSION["username"]);
            }
            ?>
        </span>
        <a href="php/logout.php" class="logout">Atvienoties</a>
    </div>
    <div class="container">
        <h1>Grāmatu Saraksts</h1>
        <div class="search">
            <input type="text" placeholder="Meklēt" name="search" id="search">
        </div>
        <div class="button-form">
            <form action="book_add.php">
                <button type="submit" name="submit">Pievienot</button>
            </form>
        </div>
        <div class="table">
            <table>
                <thead>
                    <tr>
                        <th>Nosaukums</th>
                        <th>Autors</th>
                        <th>Izdošanas gads</th>
                        <th>Žanrs</th>
                        <th>Cena</th>
                        <th>Tips</th>
                        <th>Izlasīts</th>
                        <th>Dzēst</th>
                        <th>Labot</th>
                    </tr>
                </thead>
                <tbody id="book-list">
                    <?php
                    $search = isset($_GET['search']) ? "%" . $_GET['search'] . "%" : "%";
                    $stmt = $conn->prepare("
                    SELECT bp.name, bp.author, bp.year, bg.genre, bp.price, bt.type, ul.is_read, ul.id_list 
                    FROM dv_book_parameter bp 
                    JOIN dv_book_list bl ON bp.id_par = bl.id_par
                    JOIN dv_book_genre bg ON bl.id_genre = bg.id_genre
                    JOIN dv_book_type bt ON bl.id_type = bt.id_type
                    JOIN dv_user_list ul ON bl.id_list = ul.id_list
                    WHERE ul.id_user = ? AND (bp.name LIKE ? OR bp.author LIKE ?)
                    ");
                    $stmt->bind_param("iss", $user_id, $search, $search);
                    $stmt->execute();
                    $stmt->bind_result($name, $author, $year, $genre, $price, $type, $is_read, $id_list);
                    while ($stmt->fetch()) {
                        echo "<tr>";
                        echo "<td>" . htmlspecialchars($name) . "</td>";
                        echo "<td>" . htmlspecialchars($author) . "</td>";
                        echo "<td>" . htmlspecialchars($year) . "</td>";
                        echo "<td>" . htmlspecialchars($genre) . "</td>";
                        echo "<td>" . htmlspecialchars($price) . " €</td>";
                        echo "<td>" . htmlspecialchars($type) . "</td>";
                        echo "<td><input type='checkbox' name='read' data-id='$id_list' " . ($is_read ? "checked" : "") . "></td>";
                        echo "<td><button class='delete' data-id='$id_list'>Dzēst</button></td>";
                        echo "<td><button class='edit' data-id='$id_list'>Labot</button></td>";
                        echo "</tr>";
                    }
                    $stmt->close();
                    ?>
                </tbody>
            </table>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            console.log("DOM pilnībā ielādēts un parsēts.");

            // Pievieno notikumu klausītājus visiem izvēlētajiem checkbox.
            document.querySelectorAll('input[name="read"]').forEach(checkbox => {
                checkbox.addEventListener('change', function () {
                    const idList = this.getAttribute('data-id');
                    const isChecked = this.checked ? 1 : 0;
                    updateReadStatus(idList, isChecked);
                });
            });

            // Pievieno notikumu klausītājus visām dzēšanas pogām.
            document.querySelectorAll('.delete').forEach(button => {
                button.addEventListener('click', function () {
                    const idList = this.getAttribute('data-id');
                    confirmAndDeleteBook(idList);
                });
            });

            // Pievieno notikumu klausītājus visām labošanas pogām.
            document.querySelectorAll('.edit').forEach(button => {
                button.addEventListener('click', function () {
                    const idList = this.getAttribute('data-id');
                    redirectToEditPage(idList);
                });
            });

            // Pievieno notikumu klausītāju meklēšanas joslai.
            document.getElementById('search').addEventListener('input', function () {
                const query = this.value;
                searchAndUpdateBooks(query);
            });

            // Funkcija, kas atjauno checkbox statusu.
            function updateReadStatus(idList, isChecked) {
                fetch('php/update_read_status.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded'
                    },
                    body: `id_list=${idList}&is_read=${isChecked}`,
                    credentials: 'same-origin'
                }).then(response => {
                    if (!response.ok) {
                        alert('Radās problēma atjauninot lasīšanas statusu.');
                    }
                });
            }

            // Funkcija, kas apstiprina un dzēš grāmatu.
            function confirmAndDeleteBook(idList) {
                if (confirm('Vai tiešām vēlaties dzēst šo grāmatu?')) {
                    fetch('php/delete_book.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded'
                        },
                        body: `id_list=${idList}`,
                        credentials: 'same-origin'
                    }).then(response => {
                        if (response.ok) {
                            location.reload();
                        } else {
                            alert('Radās problēma dzēšot grāmatu.');
                        }
                    });
                }
            }

            // Funkcija, kas novirza uz labošanas lapu ar grāmatas ID.
            function redirectToEditPage(idList) {
                window.location.href = `book_add.php?id=${idList}`;
            }

            // Funkcija, kas veic meklēšanu un atjauno grāmatu sarakstu.
            function searchAndUpdateBooks(query) {
                fetch(`index.php?search=${query}`)
                    .then(response => response.text())
                    .then(html => {
                        const parser = new DOMParser();
                        const doc = parser.parseFromString(html, 'text/html');
                        document.getElementById('book-list').innerHTML = doc.getElementById('book-list').innerHTML;
                        // Pievieno notikumu klausītājus dinamiskajiem elementiem.
                        addEventListenersToDynamicElements();
                    });
            }
        });
    </script>
</body>

</html>