<!DOCTYPE html>
<html lang="lv">

<head>
    <meta charset="utf-8">
    <title>Grāmatas pievienošana</title>
    <link rel="stylesheet" href="css/add.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>

<body>
    <div class="container">
        <form action="php/send.php" method="post" class="book-form" id="bookForm" onsubmit="return validateForm()">
            <h1 id="form-title">Pievienot grāmatu</h1>
            <?php
            include "php/connection.php";

            // Inicializēt mainīgos
            $name = $author = $year = $genre = $price = $type = '';
            $is_edit = false;

            // Iegūst grāmatas datus, ja labo
            if (isset($_GET['id'])) {
                $id_list = $_GET['id'];
                $stmt = $conn->prepare("SELECT bp.name, bp.author, bp.year, bg.genre, bp.price, bt.type 
                                        FROM dv_book_parameter bp 
                                        JOIN dv_book_list bl ON bp.id_par = bl.id_par
                                        JOIN dv_book_genre bg ON bl.id_genre = bg.id_genre
                                        JOIN dv_book_type bt ON bl.id_type = bt.id_type
                                        WHERE bl.id_list = ?");
                $stmt->bind_param("i", $id_list);
                $stmt->execute();
                $stmt->bind_result($name, $author, $year, $genre, $price, $type);
                $stmt->fetch();
                $stmt->close();
                $is_edit = true;
            }
            ?>
            <input type="hidden" name="id_list" value="<?php echo $is_edit ? htmlspecialchars($id_list) : ''; ?>">
            <div class="form-group">
                <label for="name">Nosaukums</label>
                <input type="text" maxlength="50" name="name" id="name" value="<?php echo htmlspecialchars($name); ?>" required>
                <span class="error" id="nameError"></span>
            </div>
            <div class="form-group">
                <label for="author">Autors</label>
                <input type="text" maxlength="50" name="author" id="author" value="<?php echo htmlspecialchars($author); ?>" required>
                <span class="error" id="authorError"></span>
            </div>
            <div class="form-group">
                <label for="year">Izdošanas gads</label>
                <input type="text" maxlength="4" pattern="[0-9]{4}" name="year" id="year" value="<?php echo htmlspecialchars($year); ?>" required>
                <span class="error" id="yearError"></span>
            </div>
            <div class="form-group">
                <label for="price">Cena (€)</label>
                <input type="text" pattern="^\d{1,3}(\.\d{1,2})?$" maxlength="6" name="price" id="price" value="<?php echo htmlspecialchars($price); ?>">
                <span class="error" id="priceError"></span>
            </div>
            <div class="form-group">
                <label for="genre">Žanrs</label>
                <select name="genre" id="genre" required>
                    <option value="" disabled <?php echo !$is_edit ? 'selected' : ''; ?>>Izvēlieties žanru</option>
                    <?php
                    $genres = ["Darbība", "Kriminālromāns", "Romantika", "Piedzīvojumi", "Fantastika", "Trilleris", "Mistērija", "Horror", "Zinātniskā fantastika", "Drama", "Humors", "Biogrāfija", "Psiholoģija", "Fantāzija", "Mistika", "Romantiskā komēdija", "Bērnu literatūra", "Noslēpumainā tēma", "Politiskais trilleris", "Vēsturisks romāns", "Sāgās"];
                    foreach ($genres as $g) {
                        echo "<option value='$g'" . ($is_edit && $genre == $g ? " selected" : "") . ">$g</option>";
                    }
                    ?>
                </select>
                <span class="error" id="genreError"></span>
            </div>
            <div class="form-group">
                <label for="type">Tips</label>
                <select name="type" id="type" required>
                    <option value="Grāmata" <?php echo $is_edit && $type == "Grāmata" ? "selected" : ""; ?>>Grāmata</option>
                    <option value="E-Grāmata" <?php echo $is_edit && $type == "E-Grāmata" ? "selected" : ""; ?>>E-Grāmata</option>
                </select>
            </div>
            <div class="buttons">
                <button type="submit" name="submit"><?php echo $is_edit ? 'Labot' : 'Pievienot'; ?></button>
                <button type="button" onclick="window.location.href='index.php'">Saraksts</button>
            </div>
        </form>
    </div>
    <script>
        // Pārbaude vai visi lauki ir aizpildīti 
        function validateForm() {
            var name = document.getElementById("name").value;
            var author = document.getElementById("author").value;
            var year = document.getElementById("year").value;
            var genre = document.getElementById("genre").value;
            var type = document.getElementById("type").value;

            if (name === "" || author === "" || year === "" || genre === "" || type === "") {
                alert("Lūdzu, aizpildiet visus laukus!");
                return false;
            }
            return true;
        }

        // Tulko validācijas paziņojumus latviešu valodā
        document.addEventListener('DOMContentLoaded', function() {
            var elements = document.getElementById('bookForm').elements;
            for (var i = 0; i < elements.length; i++) {
                elements[i].oninvalid = function(e) {
                    e.target.setCustomValidity('');
                    if (!e.target.validity.valid) {
                        switch (e.target.id) {
                            case 'name':
                                e.target.setCustomValidity('Lūdzu, ievadiet grāmatas nosaukumu.');
                                break;
                            case 'author':
                                e.target.setCustomValidity('Lūdzu, ievadiet autora vārdu.');
                                break;
                            case 'year':
                                e.target.setCustomValidity('Lūdzu, ievadiet derīgu izdošanas gadu.');
                                break;
                            case 'price':
                                e.target.setCustomValidity('Lūdzu, ievadiet derīgu cenu.');
                                break;
                            case 'genre':
                                e.target.setCustomValidity('Lūdzu, izvēlieties žanru.');
                                break;
                            case 'type':
                                e.target.setCustomValidity('Lūdzu, izvēlieties tipu.');
                                break;
                            default:
                                e.target.setCustomValidity('Lūdzu, aizpildiet šo lauku.');
                        }
                    }
                };
                elements[i].oninput = function(e) {
                    e.target.setCustomValidity('');
                };
            }
        });
    </script>
</body>

</html>