document.addEventListener(
    'DOMContentLoaded', 
    function() {
        const exchangeList = document.getElementById('exchange-list');

        const exchangeRates = [
            { pair: 'USD/EUR', rate: 0.85, change: '+1.2%' },
            { pair: 'GBP/USD', rate: 1.39, change: '-0.5%' },
            { pair: 'JPY/USD', rate: 0.0091, change: '+0.8%' },
            { pair: 'AUD/USD', rate: 0.74, change: '+0.4%' },
            { pair: 'CAD/USD', rate: 0.80, change: '-0.3%' },
            { pair: 'CHF/USD', rate: 1.08, change: '+0.2%' },
            { pair: 'CNY/USD', rate: 0.15, change: '+0.1%' },
            { pair: 'USD/GBP', rate: 0.72, change: '+0.3%' },
            { pair: 'EUR/GBP', rate: 0.86, change: '-0.2%' },
            { pair: 'USD/JPY', rate: 110.47, change: '-0.1%' },
            { pair: 'USD/AUD', rate: 1.35, change: '+0.6%' },
            { pair: 'USD/CAD', rate: 1.25, change: '-0.4%' },
            { pair: 'USD/CHF', rate: 0.93, change: '+0.1%' },
            { pair: 'USD/CNY', rate: 6.36, change: '-0.2%' },
            { pair: 'EUR/JPY', rate: 129.56, change: '+0.4%' },
            { pair: 'GBP/JPY', rate: 153.59, change: '-0.3%' },
            { pair: 'AUD/JPY', rate: 81.28, change: '+0.5%' },
            { pair: 'CAD/JPY', rate: 88.46, change: '+0.2%' },
            { pair: 'CHF/JPY', rate: 118.84, change: '-0.1%' },
            { pair: 'CNY/JPY', rate: 17.35, change: '+0.3%' },
            { pair: 'EUR/AUD', rate: 1.58, change: '-0.5%' },
            { pair: 'GBP/AUD', rate: 1.87, change: '+0.4%' },
            { pair: 'AUD/CAD', rate: 0.95, change: '-0.2%' },
            { pair: 'AUD/CHF', rate: 0.80, change: '+0.3%' },
            { pair: 'AUD/CNY', rate: 4.73, change: '+0.1%' },
            { pair: 'CAD/CHF', rate: 0.86, change: '-0.1%' },
            { pair: 'CAD/CNY', rate: 5.00, change: '+0.2%' },
            { pair: 'CHF/CNY', rate: 5.79, change: '-0.2%' },
            { pair: 'EUR/CAD', rate: 1.46, change: '+0.4%' },
            { pair: 'GBP/CAD', rate: 1.74, change: '-0.3%' },
            { pair: 'NZD/USD', rate: 0.69, change: '+0.4%' },
            { pair: 'SGD/USD', rate: 0.75, change: '-0.1%' },
            { pair: 'HKD/USD', rate: 0.13, change: '+0.2%' },
            { pair: 'INR/USD', rate: 0.014, change: '-0.3%' },
            { pair: 'BRL/USD', rate: 0.19, change: '+0.1%' },
            { pair: 'MXN/USD', rate: 0.05, change: '-0.4%' },
            { pair: 'ZAR/USD', rate: 0.07, change: '+0.3%' },
            { pair: 'RUB/USD', rate: 0.013, change: '-0.2%' }
            // Add more exchange rates as needed
          ];
        
        exchangeRates.forEach(
            rate => {
                const li = document.createElement('li');
                li.innerHTML = `
                    <span>${rate.pair}</span>
                    <span>${rate.rate}</span>
                    <span>${rate.change}</span>
                `;
                exchangeList.appendChild(li);
          }
        );
    }
);




