// Mock data for demonstration
const labels = ["January", "February", "March", "April", "May", "June"];
const data = {
  labels: labels,
  datasets: [
    {
      label: "USD to EUR",
      backgroundColor: "rgba(255, 99, 132, 0.2)",
      borderColor: "rgba(255, 99, 132, 1)",
      borderWidth: 1,
      data: [1.2, 1.3, 1.4, 1.5, 1.6, 1.7],
    },
    {
      label: "USD to GBP",
      backgroundColor: "rgba(54, 162, 235, 0.2)",
      borderColor: "rgba(54, 162, 235, 1)",
      borderWidth: 1,
      data: [0.8, 0.9, 0.85, 0.82, 0.78, 0.75],
    },
    {
      label: "USD to JPY",
      backgroundColor: "rgba(255, 205, 86, 0.2)",
      borderColor: "rgba(255, 205, 86, 1)",
      borderWidth: 1,
      data: [110, 108, 107, 105, 103, 100],
    },
    {
      label: "USD to AUD",
      backgroundColor: "rgba(75, 192, 192, 0.2)",
      borderColor: "rgba(75, 192, 192, 1)",
      borderWidth: 1,
      data: [1.5, 1.6, 1.7, 1.8, 1.9, 2.0],
    },
    {
      label: "USD to CAD",
      backgroundColor: "rgba(153, 102, 255, 0.2)",
      borderColor: "rgba(153, 102, 255, 1)",
      borderWidth: 1,
      data: [1.3, 1.32, 1.35, 1.38, 1.4, 1.42],
    },
    {
      label: "USD to CHF",
      backgroundColor: "rgba(255, 159, 64, 0.2)",
      borderColor: "rgba(255, 159, 64, 1)",
      borderWidth: 1,
      data: [1.1, 1.12, 1.15, 1.18, 1.2, 1.22],
    },
    {
      label: "USD to CNY",
      backgroundColor: "rgba(255, 99, 71, 0.2)",
      borderColor: "rgba(255, 99, 71, 1)",
      borderWidth: 1,
      data: [6.5, 6.48, 6.45, 6.42, 6.4, 6.38],
    },
    {
      label: "USD to INR",
      backgroundColor: "rgba(128, 0, 128, 0.2)",
      borderColor: "rgba(128, 0, 128, 1)",
      borderWidth: 1,
      data: [70, 72, 75, 78, 80, 82],
    },
    {
      label: "USD to RUB",
      backgroundColor: "rgba(255, 0, 0, 0.2)",
      borderColor: "rgba(255, 0, 0, 1)",
      borderWidth: 1,
      data: [70, 72, 75, 78, 80, 82],
    },
    {
      label: "USD to BRL",
      backgroundColor: "rgba(0, 128, 0, 0.2)",
      borderColor: "rgba(0, 128, 0, 1)",
      borderWidth: 1,
      data: [5.3, 5.35, 5.4, 5.45, 5.5, 5.55],
    },
  ],
};

// Configuration options
const config = {
  type: "line",
  data: data,
  options: {
    scales: {
      y: {
        beginAtZero: false,
      },
    },
    plugins: {
      title: {
        display: true,
        text: "Valūtas grafiks",
        font: {
          size: 18,
        },
      },
      legend: {
        labels: {
          font: {
            size: 14,
          },
        },
      },
    },
  },
};

// Create the chart
var myChart = new Chart(document.getElementById("myChart"), config);
