import Button from "../ui/Button.jsx";
import {useState} from "react";
import apiClient from "../services/api-client.js";

function SignInView() {
    const [name, setName] = useState('')
    const [surname, setSurname] = useState('')
    const [email, setEmail] = useState('')
    const [password, setPassword] = useState('')
    const [age, setAge] = useState(null)
    const [gender, setGender] = useState(null)
    const [confirmedPassword, setConfirmedPassword] = useState('')

    const [isNameValid, setNameValid] = useState(true)
    const [isSurnameValid, setSurnameValid] = useState(true)
    const [isEmailValid, setEmailValid] = useState(true)
    const [isPasswordValid, setPasswordValid] = useState(true)
    const [isAgeValid, setAgeValid] = useState(true)
    const [isGenderValid, setGenderValid] = useState(true)
    const [isConfirmedPasswordValid, setConfirmedPasswordValid] = useState(true)
    const [passwordsMatch, setPasswordsMatch] = useState(true)
    const [isLoading, setLoading] = useState(false)
    const [error, setError] = useState(null)

    function handleFormSubmit() {
        setError(null)

        setLoading(true)
        apiClient
            .post('/user/sign-up', {name, surname, email, age, gender, password, "password_confirmation": confirmedPassword})
            .then(result => {
                setLoading(false)
                localStorage.setItem('user', JSON.stringify(result.data.data.user))
                localStorage.setItem('token', result.data.data.token.access_string)
                localStorage.setItem('token_valid_until', result.data.data.token.valid_until)
            }).then(() => {window.location = '/'})
            .catch(error => {
                setLoading(false)
                if (error.code === 'ERR_NETWORK') {
                    setError('Could not reach the server.')
                    return
                }
                setError(error.response.data.message)
            })
    }

    function validateEmail(value) {
        setEmail(value)
        if (value.match(/^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|.(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/)) {
            setEmailValid(true)
        } else {
            setEmailValid(false)
        }
    }

    function validatePassword(value) {
        setPassword(value)
        if (value.match(/^(?=.*?[0-9])(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[^0-9A-Za-z]).{8,32}$/)) {
            setPasswordValid(true)
        } else {
            setPasswordValid(false)
        }
    }

    function validateConfirmPassword(value) {
        setConfirmedPassword(value)
        if (value.match(/^(?=.*?[0-9])(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[^0-9A-Za-z]).{8,32}$/)) {
            setConfirmedPasswordValid(true)
        } else {
            setConfirmedPasswordValid(false)
        }
    }

    function validateAge(value) {
        setAge(value)
        if (value.match(/^[0-9]*$/) && value >= 13 && value <= 149) {
            setAgeValid(true)
        } else {
            setAgeValid(false)
        }
    }

    return <main className='flex justify-center items-center min-h-screen bg-cover bg-register-view-background -mt-[3.75rem]'>
        <div className='flex flex-col items-center text-zinc-700 bg-white/90 backdrop-blur-sm shadow-md w-11/12 sm:w-112 rounded-md px-3 py-4'>
            <h1 className='font-bold text-4xl mb-5'>Sign up!</h1>
            <form className='flex flex-col items-center overflow-hidden w-full space-y-4'>
                <div className='flex gap-3 w-full'>
                    <div className='flex flex-col w-full'>
                        <label className={`text-md ${!isNameValid ? 'text-red-500' : ''}`}
                               htmlFor="email">Name</label>
                        <input className='text-black rounded-md px-2 py-1.5 border w-full' id="name" type="text"
                               onChange={(current) => {
                                   setNameValid(current.target.value.trim().length >= 1)
                                   setName(current.target.value.trim())
                               }}/>
                    </div>
                    <div className='flex flex-col w-full'>
                        <label className={`text-md ${!isSurnameValid ? 'text-red-500' : ''}`}
                               htmlFor="surname">Surname</label>
                        <input className='text-black rounded-md px-2 py-1.5 border w-full' id="surname" type="text"
                               onChange={(current) => {
                                   setSurnameValid(current.target.value.trim().length >= 1)
                                   setSurname(current.target.value.trim())
                               }}/>
                    </div>
                </div>
                <div className='flex flex-col w-full'>
                    <label className={`text-md ${!isEmailValid ? 'text-red-500' : ''}`} htmlFor="email">Email</label>
                    <input className='text-black rounded-md px-2 py-1.5 border' id="email" type="email"
                           onChange={(current) => validateEmail(current.target.value.trim())}/>
                </div>
                <div className='flex gap-3 w-full'>
                    <div className='flex flex-col w-full'>
                        <label className={`text-md ${!isAgeValid ? 'text-red-500' : ''}`}
                               htmlFor="age">Age</label>
                        <input className='text-black rounded-md px-2 py-1.5 border w-full' id="age" type="number"
                               onChange={(current) => validateAge(current.target.value.trim())}/>
                    </div>
                    <div className='flex flex-col w-full'>
                        <label className={`text-md ${!isGenderValid ? 'text-red-500' : ''}`}
                               htmlFor="gender">Gender</label>
                        <select className='text-black rounded-md px-2 py-1.5 h-[2.375rem] border w-full' id="gender"
                                onChange={(current) => {
                                    setGenderValid(!!current.target.value)
                                    setGender(current.target.value)
                                }}>
                            <option defaultValue></option>
                            <option value="male">Male</option>
                            <option value="female">Female</option>
                            <option value="undisclosed">Undisclosed</option>
                        </select>
                    </div>
                </div>
                <div className='flex flex-col w-full !mb-4'>
                    <label className={`text-md ${!isPasswordValid ? 'text-red-500' : ''}`}
                           htmlFor="password">Password</label>
                    <input className='text-black rounded-md px-2 py-1.5 border' id="password" type="password"
                           onChange={(current) => validatePassword(current.target.value.trim())}/>
                </div>
                <div className='flex flex-col w-full !mb-4'>
                    <label className={`text-md ${!isConfirmedPasswordValid ? 'text-red-500' : ''}`}
                           htmlFor="confirm_password">Confirm password</label>
                    <input className='text-black rounded-md px-2 py-1.5 border' id="confirm_password" type="password"
                           onChange={(current) => validateConfirmPassword(current.target.value.trim())}/>
                    {!passwordsMatch && <p className='text-brand-orange'>Passwords do not match!</p>}
                </div>
                <Button type='white' width='full'
                        onClick={handleFormSubmit}>{isLoading ? 'Loading...' : 'Sign up'}</Button>
                {error && <p className='text-brand-orange'>{error}</p>}
            </form>
        </div>
    </main>
}

export default SignInView;