import Button from "../ui/Button.jsx";
import {useState} from "react";
import apiClient from "../services/api-client.js";

function SignInView() {
    const [email, setEmail] = useState('')
    const [password, setPassword] = useState('')
    const [isEmailValid, setEmailValid] = useState(true)
    const [isPasswordValid, setPasswordValid] = useState(true)
    const [isLoading, setLoading] = useState(false)
    const [error, setError] = useState(null)

    function handleFormSubmit() {
        if (!email) {
            setEmailValid(false)
        }

        if (!password) {
            setPasswordValid(false)
        }

        if (!email || !password) {
            return
        }

        if (!isEmailValid || !isPasswordValid) return

        setLoading(true)
        apiClient
            .post('/user/sign-in', {email, password})
            .then(result => {
                setLoading(false)
                localStorage.setItem('user', JSON.stringify(result.data.data.user))
                localStorage.setItem('token', result.data.data.token.access_string)
                localStorage.setItem('token_valid_until', result.data.data.token.valid_until)
            }).then(() => {window.location = '/'})
            .catch(error => {
                setLoading(false)
                if (error.code === 'ERR_NETWORK') {
                    setError('Could not reach the server.')
                    return
                }
                setError(error.response.data.message)
            })
    }

    function validateEmail(value) {
        setEmail(value)
        if (value.match(/^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|.(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/)) {
            setEmailValid(true)
        } else {
            setEmailValid(false)
        }
    }

    function validatePassword(value) {
        setPassword(value)
        if (value.match(/^(?=.*?[0-9])(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[^0-9A-Za-z]).{8,32}$/)) {
            setPasswordValid(true)
        } else {
            setPasswordValid(false)
        }
    }

    return <main className='flex justify-center items-center min-h-screen bg-cover bg-login-view-background -mt-[3.75rem]'>
        <div className='flex flex-col items-center text-zinc-700 bg-white/90 backdrop-blur-sm shadow-md w-11/12 sm:w-112 rounded-md px-3 py-4'>
            <h1 className='font-bold text-4xl mb-5'>Sign in!</h1>
            <form className='flex flex-col items-center overflow-hidden w-full space-y-4'>
                <div className='flex flex-col w-full'>
                    <label className={`text-md ${!isEmailValid ? 'text-red-500' : ''}`} htmlFor="email">Email</label>
                    <input className='text-black rounded-md px-2 py-1.5 border' id="email" type="email" onChange={(current) => validateEmail(current.target.value.trim())}/>
                </div>
                <div className='flex flex-col w-full !mb-4'>
                    <label className={`text-md ${!isPasswordValid ? 'text-red-500' : ''}`} htmlFor="password">Password</label>
                    <input className='text-black rounded-md px-2 py-1.5 border' id="password" type="password" onChange={(current) => validatePassword(current.target.value.trim())}/>
                </div>
                <Button type='white' width='full' onClick={handleFormSubmit}>{isLoading ? 'Loading...' : 'Sign in'}</Button>
                {error && <p className='text-brand-orange'>{error}</p>}
            </form>
        </div>
    </main>
}

export default SignInView;