import {useLocation} from "react-router-dom";
import useData from "../hooks/useData.js";
import CategoriesGrid from "../components/CategoriesGrid.jsx";
import ProductsGrid from "../components/ProductsGrid.jsx";

function ProductsPageView() {
    const { pathname: path } = useLocation();
    const slug = path.slice(path.lastIndexOf('/') + 1, path.length)
    const {data: categories, isLoading, error} = useData(`/categories/${slug}`, null, [slug])
    const {data: products} = useData(`/products`, { params: { 'category': slug }})
    return <main className='flex-1 mx-auto w-11/12'>
        {categories.length !== 0 && <CategoriesGrid categories={categories} />}
        {!!products && <ProductsGrid products={products}/>}
    </main>
}

export default ProductsPageView;