import CategoriesGrid from "../components/CategoriesGrid.jsx";
import useData from "../hooks/useData.js";
import CategoriesList from "../components/CategoriesList.jsx";
import {HashLoader} from "react-spinners"

function HomeView() {
    const {data: categories, isLoading, error} = useData('/categories');

    if (error) return <main className='flex-1 flex justify-center items-center'><p>An error occurred, please try again later!</p></main>

    return <main className='flex-1 mx-auto w-11/12'>
        <div className='sm:hidden'>
            <CategoriesGrid categories={categories} />
        </div>
        <div>
            <CategoriesList categories={categories}/>
        </div>
    </main>
}

export default HomeView;