import {Link} from "react-router-dom";
import PropTypes from "prop-types";
Button.propTypes = {
    link: PropTypes.string,
    children: PropTypes.node,
    type: PropTypes.oneOf(['primary', 'white', 'link', 'danger', 'dimmed']),
    width: PropTypes.oneOf(['full']),
    onClick: PropTypes.func
}

function Button({ link, children, onClick, type = 'primary', width = null }) {
    switch (type) {
        case 'primary':
            return <Link to={link} className={`text-center text-white bg-brand-orange hover:bg-brand-orange-light disabled:bg-zinc-300 transition-colors px-2 py-1 h-9 rounded-md text-lg ${width && 'w-full'}`}>{children}</Link>
        case 'white':
            return <Link to={link} onClick={onClick} className={`text-center text-zinc-800 border bg-white hover:bg-zinc-100 disabled:bg-zinc-300 transition-colors px-2 py-1 h-9 rounded-md text-lg ${width && 'w-full'}`}>{children}</Link>
        case 'link':
            return <Link to={link} className={`text-center text-zinc-500 hover:text-zinc-700 transition-colors px-2 py-1 h-9 rounded-md text-lg ${width && 'w-full'}`}>{children}</Link>;
        case 'danger':
            return <Link to={link} className={`text-center text-white bg-red-700 hover:bg-pink-300 disabled:bg-zinc-300 transition-colors px-2 py-1 h-9 rounded-md text-lg ${width && 'w-full'}`}>{children}</Link>
    }
}

export default Button;