import { createBrowserRouter } from 'react-router-dom';
import Layout from './layout/Layout.jsx';
import HomeView from './views/HomeView.jsx';
import SignInView from "./views/SignInView.jsx";
import SignUpView from "./views/SignUpView.jsx";
import ProductsPageView from "./views/ProductsPageView.jsx";

const router = createBrowserRouter([
    {
        path: '/',
        element: <Layout />,
        children: [
            { index: true, element: <HomeView /> },
            { path: '/sign-in', element: <SignInView /> },
            { path: '/sign-up', element: <SignUpView /> },
            { path: '/category/:slug', element: <ProductsPageView />}
        ]
    },
]);

export default router;