import {Link, useLocation} from "react-router-dom";

import logo from '../assets/logo-dark.svg';
import Button from "../ui/Button.jsx";
import Search from "../ui/Search.jsx";
import {BsSearch} from "react-icons/bs";
import {CgMenu} from "react-icons/cg";
import {useState} from "react";

function Header() {
    const [showMobileSearch, setShowMobileSearch] = useState(false)
    const [showMobileNavigation, setShowMobileNavigation] = useState(false)
    const {pathname: path} = useLocation();
    const fullNavigation = !(path === '/sign-in' || path === '/sign-up')

    return <header
        className={`sticky text-white bg-white/80 backdrop-blur-sm border-b z-10 top-0 h-auto p-3 ${showMobileSearch ? 'pb-2' : ''}`}>
        <div className={`max-w-screen-xl mx-auto flex justify-between items-center px-3 gap-6`}>
            <Link className='min-w-fit' to="/">
                <img className="min-w-28 w-28" src={logo} alt="nand.lv logo"/>
            </Link>
            {fullNavigation && <div className='hidden sm:block w-3/5' >
                <Search />
            </div>}
            <div className='flex gap-3 sm:hidden'>
                {fullNavigation && <BsSearch onClick={() => {setShowMobileSearch(!showMobileSearch)}} className={`bg-brand-orange h-9 w-9 p-2 rounded-md transition-colors duration-150 ${showMobileSearch ? 'bg-brand-orange-light' : 'bg-brand-orange'}`}/>}
                <CgMenu onClick={() => {setShowMobileNavigation(!showMobileNavigation)}} className={`h-9 w-9 p-2 rounded-md bg-brand-orange transition-colors duration-150 ${showMobileNavigation ? 'bg-brand-orange-light' : 'bg-brand-orange'}`}/>
            </div>
            <div className='hidden sm:flex items-center gap-2 whitespace-nowrap '>
                {fullNavigation && <Button link='/sign-in' type='link'>Sign in</Button>}
                {!fullNavigation && <Button link='/contact' type='link'>Contact</Button>}
                {fullNavigation && <Button link='/sign-up'>Sign up</Button>}
                {!fullNavigation && path === '/sign-in' && <Button link='/sign-up' type='white'>Sign up</Button>}
                {!fullNavigation && path === '/sign-up' && <Button link='/sign-in' type='white'>Sign in</Button>}
            </div>
        </div>
        {showMobileSearch && <div className='flex justify-between gap-4 px-3'>
            <Search className='w-full' />
            <Button>Search...</Button>
        </div>}
        {showMobileNavigation && <div>
            <ul>
                <Button type='plain'>Test</Button>
            </ul>
        </div>}
    </header>
;
}

export default Header;