import logo from '../assets/logo-light.svg'
import SocialMediaIcons from "../components/SocialMediaIcons.jsx";
import {Link} from "react-router-dom";
import { IoIosMail } from "react-icons/io";
import Button from "../ui/Button.jsx";

function Footer() {
    return <footer className='bg-zinc-800'>
        <div className='flex flex-col lg:flex-row px-7 md:px-20 gap-12 py-12'>
            <div className='grid grid-cols-2 sm:grid-cols-3 lg:w-3/5 align-middle'>
                <div className='flex w-full col-start-1 sm:col-start-1 col-end-4 sm:col-end-1'>
                    <div className='flex flex-col gap-6 mb-8 sm:mb-0'>
                        <Link className='min-w-fit' to="/">
                            <img className="min-w-28 w-28" src={logo} alt="nand.lv logo"/>
                        </Link>
                        <SocialMediaIcons/>
                    </div>
                </div>
                <div className='flex'>
                    <div className='flex flex-col gap-4 text-zinc-500'>
                        <h3>Support</h3>
                        <ul className='text-zinc-200 leading-8'>
                            <li>Contact us</li>
                            <li>FAQ</li>
                            <li>Privacy policy</li>
                        </ul>
                    </div>
                </div>
                <div className='flex'>
                    <div className='flex flex-col gap-4 text-zinc-500'>
                        <h3>NAND</h3>
                        <ul className='text-zinc-200 leading-8'>
                            <li>About us</li>
                            <li>Newsroom</li>
                            <li>Careers</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div className='flex lg:w-2/5 flex-col space-y-3 lg:space-y-2 mt-10 lg:mt-0'>
                <div className='flex gap-2 text-nowrap'>
                    <IoIosMail className='h-7 w-7 text-white'/>
                    <p className='text-white'>Stay up to date on latest from NAND</p>
                </div>
                <input type="email" className='rounded-md bg-zinc-500 px-2 py-1 text-white' placeholder='Enter your e-mail address'/>
                <Button type='primary'>Sign up</Button>
            </div>
        </div>
        <div className='bg-zinc-900 h-16 text-zinc-400 text-sm flex justify-center items-center'>
            <p>Copyright &copy; 2024 by NAND | All Rights Reserved.</p>
        </div>
    </footer>
}

export default Footer;