import ProductCard from "./ProductCard.jsx";
import PropTypes from "prop-types";

ProductsGrid.propTypes = {
    'products': PropTypes.array
}

function ProductsGrid({ products }) {
    return <div className='grid grid-cols-2 md:grid-cols-3 xl:grid-cols-4 mt-5'>
        {products.map(product => <ProductCard key={product.id} product={product}/>)}
    </div>
}

export default ProductsGrid;