import PropTypes from "prop-types";

ProductCard.propTypes = {
    'product': PropTypes.object
}

function ProductCard({ product }) {
    return <div className='flex flex-col w-full max-w-112'>
        <h1>{product.title}</h1>
        <img src={product.image_url} alt={product.title}/>
    </div>
}

export default ProductCard;