import {Link} from "react-router-dom";
import PropTypes from "prop-types";

CategoriesList.propTypes = {
    'categories': PropTypes.array
}

function CategoriesList({categories}) {
    return <div className='flex'>
        <div className='flex flex-col w-1/5'>
            {categories.map(category => <Link className='border-b border-b-zinc-100 hover:bg-zinc-100 p-2 h-10'
                                              key={category.id}
                                              to={`/category/${category.slug}`}>{category.category}</Link>
            )}
        </div>
    </div>
}

export default CategoriesList;