import {Link} from "react-router-dom";
import PropTypes from "prop-types";

CategoriesGrid.propTypes = {
    'categories': PropTypes.array
}

function CategoriesGrid({ categories }) {
    return <div className='grid gap-1 border grid-cols-2 h-auto my-5'>
        {categories.map(category => <Link key={category.id} to={`/category/${category.slug}`}><div className='h-14 flex justify-center items-center hover:bg-zinc-100 transition-colors'>{category.category}</div></Link>)}
    </div>
}

export default CategoriesGrid;