<?php

use App\Http\Controllers\CategoryController;
use App\Http\Controllers\ProductController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\UserController;

Route::prefix('/v1')->group(function() {
    Route::prefix('/user')->group(function() {
        Route::controller(UserController::class)->group(function() {
            Route::post('/sign-up', 'signUp');
            Route::post('/sign-in', 'signIn');

            Route::middleware('auth:sanctum')->group(function() {
                Route::post('/sign-out', 'signOut');
                Route::post('/delete', 'destroy');
                Route::patch('/', 'update');
            });
        });
    });

    Route::get('/categories', [CategoryController::class, 'index']);
    Route::get('/categories/{category}', [CategoryController::class, 'indexSubcategories']);
    Route::get('/category/{category}', [CategoryController::class, 'show']);
    Route::get('/products', [ProductController::class, 'index']);
});

