<?php

namespace App\Http\Requests\User;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class UpdateUserRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['filled', 'alpha', 'max:255'],
            'surname' => ['filled', 'alpha_dash', 'max:255'],
            'email' => ['filled', 'email', 'max:255', 'unique:users'],
            'password' => ['filled', 'confirmed', Password::min(8)
                ->max(255)
                ->letters()
                ->mixedCase()
                ->numbers()
                ->symbols()
            ],
            'age' => ['filled', 'integer', 'min:13', 'max:255']
        ];
    }
}
