<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Product;
use App\Traits\HttpResponses;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

class ProductController extends Controller
{
    use HttpResponses;

    public function index(Request $request) {
        if ($request->input('category')) {
            try {
                $category = Category::where('slug', $request->input('category'))->firstOrFail();
                Product::where('category_id', $category->id)->paginate(32);
            } catch (ModelNotFoundException $e) {
                return $this->failure(
                    'Category with that slug was not found.',
                    404
                );
            }
        }

        //return Product::paginate(32);
    }
}
