<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Traits\HttpResponses;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    use HttpResponses;

    public function index() {
        $categories = Category::where('parent_id', null)->get();

        return $this->success(
            'Categories indexed successfully.',
            $categories
        );
    }

    public function indexSubcategories(string $slug): JsonResponse
    {
        try {
            $category = Category::where('slug', $slug)->firstOrFail();
            $categories = Category::whereBelongsTo(Category::findOrFail($category->id))->get();

            return $this->success(
                'Subcategories indexed successfully.',
                $categories
            );
        } catch (ModelNotFoundException $e) {
            return $this->failure(
                'Category with that slug was not found.',
                404
            );
        }
    }

    public function show(string $slug) {
        try {
            $category = Category::where('slug', $slug)->firstOrFail();

            return $this->success(
                'Category found successfully.',
                $category
            );
        } catch (ModelNotFoundException $e) {
            return $this->failure(
                'Category with that slug was not found.',
                404
            );
        }
    }

}
