document.addEventListener("DOMContentLoaded", function () {
    let canvas = document.getElementById("game-canvas");
    let ctx = canvas.getContext("2d");

    function setCookie(cname, cvalue, exdays) {
        let d = new Date();
        d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
        let expires = "expires="+d.toUTCString();
        document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
        }
    
        function getCookie(cname) {
        let name = cname + "=";
        let ca = document.cookie.split(';');
        for(let i = 0; i < ca.length; i++) {
            let c = ca[i];
            while (c.charAt(0) == ' ') {
            c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
            }
        }
        return "";
        }
    
    // Iestata audo failus
    let catchSound = new Audio("Sounds/catch-sound.wav");
    let lifeLossSound = new Audio("Sounds/lose-life.mp3");
    let gameOverSound = new Audio("Sounds/game-over.mp3");
    let gameStarted = false;
    let animationID;
    let isPaused = false;

    // Spēlētāja figūras īpašības
    let playerWidth = 50;
    let playerHeight = 10;
    let player = {
        x: (canvas.width - playerWidth) / 2,
        y: canvas.height - playerHeight,
    };

    // Krītošo figūru īpašības
    let shapeSpeed = 0.2;
    let shapeGenerationInterval = 2000; // 2 sekundes
    let shapes = [];
    let totalShapesSpawned = 0;

    // Ielādē krītošo figūru bildes
    let squareImage = new Image();
    squareImage.src = "Shapes/square.png";

    let triangleImage = new Image();
    triangleImage.src = "Shapes/triangle.png";

    let circleImage = new Image();
    circleImage.src = "Shapes/circle.png";

    let starImage = new Image();
    starImage.src = "Shapes/star.png";

    let powerupImage = new Image();
    powerupImage.src = "Shapes/powerup.png";

    // Krītošo figūru bildes izmēri
    let shapeImageProperties = {
        square: {
            image: squareImage,
            width: 50,
            height: 12,
        },
        triangle: {
            image: triangleImage,
            width: 50,
            height: 12,
        },
        circle: {
            image: circleImage,
            width: 50,
            height: 12,
        },
        star: {
            image: starImage,
            width: 50,
            height: 12,
        },
        "power-up": {
            image: powerupImage,
            width: 50,
            height: 12,
        },
    };
    
    // Dekoratīvās krītošo figūru izmēri
    let decorativeShapes = [
        {
            id: "square-shape",
            image: squareImage,
            width: 15,
            height: 15,
        },
        {
            id: "triangle-shape",
            image: triangleImage,
            width: 15,
            height: 15,
        },
        {
            id: "circle-shape",
            image: circleImage,
            width: 15,
            height: 15,
        },
        {
            id: "star-shape",
            image: starImage,
            width: 15,
            height: 15,
        },
        {
            id: "powerup-shape",
            image: powerupImage,
            width: 15,
            height: 15,
        },
    ];

    let numberOfDecorativeShapes = document.querySelectorAll(".shape").length;
    let mainScreen = document.getElementById("main-screen");

    // Funkcija, lai paradītu jaunu dekoratīvu figūru
    function spawnDecorativeShape() {
        if (numberOfDecorativeShapes >= 25) {
            return;
        }
        let randomNumber = Math.random()
        let shapeProps = decorativeShapes[Math.floor(Math.random() * decorativeShapes.length)];
        let shape = new Image();
        shape.src = shapeProps.image.src;
        shape.style.width = shapeProps.width + randomNumber * 35 + "px";
        shape.style.height = shapeProps.height + randomNumber *35 + "px";
        shape.style.position = "absolute";

        let randomX = Math.random() * (window.innerWidth - shapeProps.width);
        let randomY = (1-randomNumber) * -2;
        shape.style.left = randomX + "px";
        shape.style.top = randomY + "px";

        // Izveido nejaušu animācijas ilgumu (no 3 līdz 8 sekundēm)
        let animationDuration = (Math.random() * 5 + 3) + "s";
        shape.style.animation = "fallingAnimation " + animationDuration + " linear infinite";

        mainScreen.appendChild(shape);
        numberOfDecorativeShapes++;
    }

    // Izsauc funkciju ik pēc 2 sekundēm
    setInterval(spawnDecorativeShape, 2000)

    // Funkcija, kas notīra visas dekoratīvās figūras
    function clearDecorativeShapes() {
        let decorativeShapes = mainScreen.querySelectorAll("img");
        decorativeShapes.forEach((shape) => shape.remove());
        numberOfDecorativeShapes = 0;
    }

    canvas.addEventListener("mousemove", handleMouseMove);
    function handleMouseMove(event) {
        if (!isPaused) {
            let mouseX = event.clientX - canvas.getBoundingClientRect().left;
            let minX = 0;
            let maxX = canvas.width - playerWidth;

            player.x = Math.min(maxX, Math.max(minX, mouseX - playerWidth / 2));
        }
    }

    document.getElementById("instructions-screen").style.display = "none";

    // Viss kods Iestatījumu logam
    // Pievieno klikšķu noteikumu lasītāju Iestatījumu pogai
    document.getElementById("settings-button").addEventListener("click", function handleOpenSettingsMain () {
        document.getElementById("settings-screen").style.display = "block";
    });

    let soundEnabled = true;
    // Pievieno klikšķu noteikumu lasītāju skaņas izvēles rūtiņai
    document.getElementById("sound-toggle").addEventListener("change", function handleSoundToggle() {
    soundEnabled = this.checked;
    });
    
    document.getElementById("language-select").addEventListener("change", function handleLanguageSelect () {
        let selectedLanguage = this.value;
    
        if (selectedLanguage === "latvian") {
            // Aizved lietotāju uz Latviešu valodas HTML failu
            window.location.href = "index.html";
        } else if (selectedLanguage === "russian") {
            // Aizved lietotāju uz Krievu valodas HTML failu
            window.location.href = "indexru.html";
        } else {
            // Aizved lietotāju uz Angļu valodas HTML failu
            if (selectedLanguage === "english") {
                window.location.href = "indexen.html";
            }
        }
    });    

    // Pievieno klikšķu notikumu klausītāju Spēlētāja krāsas pogai
    document.getElementById("open-color-picker").addEventListener("click", function handleOpenColorPicker() {
        document.getElementById("color-picker-container").style.display = "block";
    });

    let playercolor = "rgb(255, 0, 0)"; // Noklusējuma spēlētāja krāsa

    // Funkcija spēlētāja krāsas izvēlei
    function playerColor() {
        let colorPicker = new iro.ColorPicker("#colorpicker", {
            width: 280,
            color: "rgb(255, 0, 0)",
            borderWidth: 1,
            borderColor: "#fff",
        });

        // Apstrādā krāsu izmaiņas krāsu aplī
        colorPicker.on("input:end", function (color) {
            playercolor = color.hexString;
        });
    }

    // Izsauc funkciju
    playerColor();

    // Pievieno klikšķu notikumu klausītāju Aizvērt pogai uz spēlētāja krāsas loga
    document.getElementById("close-color-picker").addEventListener("click", function handleCloseColorPicker() {
        document.getElementById("color-picker-container").style.display = "none";
    });

    // Pievieno klikšķu notikumu klausītāju Aizvērt pogai uz iestatījumu loga
    document.getElementById("close-settings").addEventListener("click", function handleCloseSettingsMain() {
        document.getElementById("settings-screen").style.display = "none";
    });

    // Viss kods Instrukcijas logam
    // Pievieno klikšķu notikumu klausītāju Instrukcijas pogai
    document.getElementById("instructions-button").addEventListener("click", function handleOpenInstructions() {
        document.getElementById("instructions-screen").style.display = "block";
    });

    let generalInstructionsContent = document.getElementById("instructions-content-general");
    let powerupsInstructionsContent = document.getElementById("instructions-content-powerups");
    let pointsInstructionsContent = document.getElementById("instructions-content-points");
    let generalInstructionsButton = document.getElementById("general-instructions-button");
    let powerupsInstructionsButton = document.getElementById("powerups-instructions-button");
    let pointsInstructionsButton = document.getElementById("points-instructions-button");

    function showGeneralInstructions() {
        generalInstructionsContent.classList.remove("hidden");
        powerupsInstructionsContent.classList.add("hidden");
        pointsInstructionsContent.classList.add("hidden");
    }
    
    function showPowerupsInstructions() {
        generalInstructionsContent.classList.add("hidden");
        powerupsInstructionsContent.classList.remove("hidden");
        pointsInstructionsContent.classList.add("hidden");
    }
    
    function showPointsInstructions() {
        generalInstructionsContent.classList.add("hidden");
        powerupsInstructionsContent.classList.add("hidden");
        pointsInstructionsContent.classList.remove("hidden");
    }
    
    // Klikšķa noteikumu lasītāji instrukcijas loga pogām
    generalInstructionsButton.addEventListener("click", showGeneralInstructions);
    powerupsInstructionsButton.addEventListener("click", showPowerupsInstructions);
    pointsInstructionsButton.addEventListener("click", showPointsInstructions);

    // Pievieno klikšķu notikumu klausītāju Aizvērt pogai uz Instrukcijas loga
    document.getElementById("close-instructions").addEventListener("click", function handleCloseInstructions() {
        document.getElementById("instructions-screen").style.display = "none";
    });
    
    // Inicializē stilu lapas ielādes laikā
    let userThemePreference = localStorage.getItem('theme');
    if (userThemePreference) {
        // Ja lietotājam ir stila preference, iestata to
        toggletheme(userThemePreference);
        
        // Nosaka, kuru stila izvēles elementu atjaunināt
        let themeSelectMain = document.getElementById('theme-select-main');
        let themeSelectPause = document.getElementById('theme-select-pause');
        
        if (themeSelectMain && themeSelectPause) {
            themeSelectMain.value = userThemePreference;
            themeSelectPause.value = userThemePreference;
        }
    } else {
        // Pēc noklusējuma izvēlas gaišu stilu, ja lietotāja preference netiek atrasta
        toggletheme('light');
        
        // Nosaka, kuru stila izvēles elementu atjaunināt
        let themeSelectMain = document.getElementById('theme-select-main');
        let themeSelectPause = document.getElementById('theme-select-pause');
        
        if (themeSelectMain && themeSelectPause) {
            themeSelectMain.value = 'light';
            themeSelectPause.value = 'light';
        }
    }

    // Iestatījumu loga stila izvēles elementam pievieno notikumu lasītāju
    let themeSelectMain = document.getElementById('theme-select-main');
    themeSelectMain.addEventListener('change', function handlethemeSelect() {
        let selectedTheme = this.value;
        toggletheme(selectedTheme);

        // Pauzes iestatījumu logā iestata to pašu stilu
        let themeSelectPause = document.getElementById('theme-select-pause');
        if (themeSelectPause) {
            themeSelectPause.value = selectedTheme;
        }

        // Saglabā lietotāja preferenci
        localStorage.setItem('theme', selectedTheme);
    });

    // Iestatījumu loga (uz pauzes loga) stila izvēles elementam pievieno notikumu lasītāju
    let themeSelectPause = document.getElementById('theme-select-pause');
    themeSelectPause.addEventListener('change', function () {
        let selectedTheme = this.value;
        toggletheme(selectedTheme);

        // Galvenajā iestatījumu logā iestata to pašu stilu
        let themeSelectMain = document.getElementById('theme-select-main');
        if (themeSelectMain) {
            themeSelectMain.value = selectedTheme;
        }

        // Saglabā lietotāja preferenci
        localStorage.setItem('theme', selectedTheme);
    });

    // Funkcija, kas nomaina spēles elementus atkarībā no izvēlētā stila
    function toggletheme(theme) {
        let body = document.body;
        body.classList.toggle('light-theme', theme === 'light');
        body.classList.toggle('dark-theme', theme === 'dark');

        // Pārmaina pogas atkarībā no izvēlētā stila
        let playButton = document.getElementById('play-button');
        let colorPickerButton = document.getElementById('open-color-picker');
        let instructionsButton = document.getElementById('instructions-button');
        let settingsButton = document.getElementById('settings-button');
        let leaderboardsButton = document.getElementById('leaderboards-button');
        let ShapeCatcher = document.getElementById('ShapeCatcher');

        if (theme === 'dark') {
            playButton.style.backgroundColor = 'black';
            playButton.style.color = 'white';
            colorPickerButton.style.backgroundColor = 'white';
            colorPickerButton.style.color = 'black';
            instructionsButton.style.backgroundColor = 'black';
            instructionsButton.style.color = 'white';
            settingsButton.style.backgroundColor = 'black';
            settingsButton.style.color = 'white';
            leaderboardsButton.style.backgroundColor = 'black';
            leaderboardsButton.style.color = 'white';
            ShapeCatcher.style.color = 'black';
        } else {
            playButton.style.backgroundColor = 'white';
            playButton.style.color = 'black';
            colorPickerButton.style.backgroundColor = 'black';
            colorPickerButton.style.color = 'white';
            instructionsButton.style.backgroundColor = 'white';
            instructionsButton.style.color = 'black';
            settingsButton.style.backgroundColor = 'white';
            settingsButton.style.color = 'black';
            leaderboardsButton.style.backgroundColor = 'white';
            leaderboardsButton.style.color = 'black';
            ShapeCatcher.style.color = 'white';
        }
        
        // Iestata iestatījumu logu elementus atkarībā no izvēlētā stila
        let settingsScreen = document.getElementById('settings-screen');
        if (settingsScreen) {
            if (theme === 'dark') {
                settingsScreen.style.backgroundColor = 'rgba(0, 0, 0, 0.8)';
                settingsScreen.style.color = 'white';
                settingsScreen.style.borderColor = 'white';
            } else {
                settingsScreen.style.backgroundColor = 'white';
                settingsScreen.style.color = 'black';
                settingsScreen.style.borderColor = 'black';
            }
        }

        // Iestata spēlētāja krāsas izvēles logu atkarībā no izvēlētā stila
        let colorPickerContainer = document.getElementById('color-picker-container');
        if (theme === 'dark') {
            colorPickerContainer.style.backgroundColor = 'rgba(0, 0, 0, 0.8)'; 
            colorPickerContainer.style.color = 'white';
            colorPickerContainer.style.borderColor = 'white';
        } else {
            colorPickerContainer.style.backgroundColor = 'white';
            colorPickerContainer.style.color = 'black';
            colorPickerContainer.style.borderColor = 'black';
        }

        // Iestata insturkcijas loga elementus atkarībā no izvēlētā stila
        let instructionsScreen = document.getElementById('instructions-screen');
        let generalInstructionsButton = document.getElementById("general-instructions-button");
        let powerupsInstructionsButton = document.getElementById("powerups-instructions-button");
        let pointsInstructionsButton = document.getElementById("points-instructions-button");
        if (theme === 'dark') {
            instructionsScreen.style.backgroundColor = 'rgba(0, 0, 0, 0.95)';
            instructionsScreen.style.color = 'white';
            instructionsScreen.style.borderColor = 'white';
            generalInstructionsButton.style.backgroundColor = 'white';
            generalInstructionsButton.style.color = 'black';
            generalInstructionsButton.style.borderColor = 'black';
            pointsInstructionsButton.style.backgroundColor = 'white';
            pointsInstructionsButton.style.color = 'black';
            pointsInstructionsButton.style.borderColor = 'black';
            powerupsInstructionsButton.style.backgroundColor = 'white';
            powerupsInstructionsButton.style.color = 'black';
            powerupsInstructionsButton.style.borderColor = 'black';
        } else {
            instructionsScreen.style.backgroundColor = 'rgba(255, 255, 255, 0.95)';
            instructionsScreen.style.color = 'black';
            instructionsScreen.style.borderColor = 'black';
            generalInstructionsButton.style.backgroundColor = 'black';
            generalInstructionsButton.style.color = 'white';
            generalInstructionsButton.style.borderColor = 'white';
            pointsInstructionsButton.style.backgroundColor = 'black';
            pointsInstructionsButton.style.color = 'white';
            pointsInstructionsButton.style.borderColor = 'white';
            powerupsInstructionsButton.style.backgroundColor = 'black';
            powerupsInstructionsButton.style.color = 'white';
            powerupsInstructionsButton.style.borderColor = 'white';
        }

        // Iestata līderu saraksta elementus atkarībā no izvēlētā stila
        let leaderboardsContainer = document.getElementById('leaderboards-container');
        let leaderboardsStandings = document.getElementById('leaderboards-standings');
        if (theme === 'dark') {
            leaderboardsContainer.style.backgroundColor = 'rgba(0, 0, 0, 0.95)';
            leaderboardsContainer.style.borderColor = 'white';
            leaderboardsContainer.style.color = 'white';
            leaderboardsStandings.style.backgroundColor = 'rgba(0, 0, 0, 0.02)';
            leaderboardsStandings.style.color = 'white';
        } else {
            leaderboardsContainer.style.backgroundColor = 'rgba(255, 255, 255, 0.95)';
            leaderboardsContainer.style.borderColor = 'black'; 
            leaderboardsContainer.style.color = 'black';
            leaderboardsStandings.style.backgroundColor = 'rgba(255, 255, 255, 0.02)'; 
            leaderboardsStandings.style.color = 'black';
        }

        // Iestata spēles laukuma fona krāsu atkarībā no izvēlētā stila
        let canvas = document.getElementById('canvas-container');
        if (canvas) {
            if (theme === 'dark') {
                canvas.style.backgroundColor = 'rgba(0, 0, 0, 0.55)';
            } else {
                canvas.style.backgroundColor = 'rgba(255, 255, 255, 0.55)';
            }
        }

        // Iestata Punktu un Dzīvību displejus atkarībā no izvēlētā stila
        let livesLabel = document.getElementById('lives-label');
        let pointsLabel = document.getElementById('points-label');
        let pointsCount = document.getElementById('points-count');
        if (theme === 'dark') {
            livesLabel.style.color = 'white';
            pointsLabel.style.color = 'white';
            pointsCount.style.color = 'white';
        } else {
            livesLabel.style.color = 'black';
            pointsLabel.style.color = 'black';
            pointsCount.style.color = 'black';
        }

        // Iestata papildiespēju taimerus atkarībā no izvēlētā stila
        let widthTimerElement = document.getElementById("width-timer");
        let doubleStarTimerElement = document.getElementById("double-star-timer");
        let doublePointsTimerElement = document.getElementById("double-points-timer");
        if (theme === 'dark') {
            widthTimerElement.style.color = 'white';
            doubleStarTimerElement.style.color = 'white';
            doublePointsTimerElement.style.color = 'white';
        } else {
            widthTimerElement.style.color = 'black';
            doubleStarTimerElement.style.color = 'black';
            doublePointsTimerElement.style.color = 'black'; 
        }

        // Iestata pauzes loga elementus atkarībā no izvēlētā stila
        let pauseButton = document.getElementById("pause-button");
        let pauseMenu = document.getElementById('pause-menu');
        let resumeButton = document.getElementById("resume-button");
        let settingsButtonPause = document.getElementById("settings-button-pause");
        let mainMenuButtonPause = document.getElementById("main-menu-button-pause");
        if (pauseMenu) {
            if (theme === 'dark') {
                pauseButton.style.backgroundColor = 'white';
                pauseButton.style.color = 'black';
                pauseMenu.style.backgroundColor = 'black';
                pauseMenu.style.color = 'white';
                pauseMenu.style.borderColor = 'white';
                resumeButton.style.backgroundColor = 'white';
                resumeButton.style.color = 'black';
                settingsButtonPause.style.backgroundColor = 'white';
                settingsButtonPause.style.color = 'black';
                mainMenuButtonPause.style.backgroundColor = 'white';
                mainMenuButtonPause.style.color = 'black';
            } else {
                pauseButton.style.backgroundColor = 'black';
                pauseButton.style.color = 'white';
                pauseMenu.style.backgroundColor = 'white';
                pauseMenu.style.color = 'black';
                pauseMenu.style.borderColor = 'black';
                resumeButton.style.backgroundColor = 'black';
                resumeButton.style.color = 'white';
                settingsButtonPause.style.backgroundColor = 'black';
                settingsButtonPause.style.color = 'white';
                mainMenuButtonPause.style.backgroundColor = 'black';
                mainMenuButtonPause.style.color = 'white';
            }
        }

        // Iestata iestatījumu logu (uz pauzes loga) elementus atkarībā no stila
        let settingsScreenPause = document.getElementById('settings-screen-pause');
        if (settingsScreenPause) {
            if (theme === 'dark') {
                settingsScreenPause.style.backgroundColor = 'rgba(0, 0, 0, 0.8)'; // Semi-transparent black
                settingsScreenPause.style.color = 'white';
                settingsScreenPause.style.borderColor = 'white';
            } else {
                settingsScreenPause.style.backgroundColor = 'white';
                settingsScreenPause.style.color = 'black';
                settingsScreenPause.style.borderColor = 'black';
            }
        }

        // Iestata spēles beigas loga elementus atkarībā no izvēlētā stila
        let gameOverScreen = document.getElementById("game-over-screen");
        if (gameOverScreen) {
            if (theme === 'dark') {
                gameOverScreen.style.backgroundColor = 'black';
                gameOverScreen.style.color = 'white';
                gameOverScreen.style.borderColor = 'white';
                let restartButton = document.getElementById("restart-button");
                let mainMenuButton = document.getElementById("main-menu-button");
                if (restartButton && mainMenuButton) {
                    restartButton.style.backgroundColor = 'white';
                    restartButton.style.color = 'black';
                    mainMenuButton.style.backgroundColor = 'white';
                    mainMenuButton.style.color = 'black';
                }
            } else {
                gameOverScreen.style.backgroundColor = 'white';
                gameOverScreen.style.color = 'black';
                gameOverScreen.style.borderColor = 'black';
                let restartButton = document.getElementById("restart-button");
                let mainMenuButton = document.getElementById("main-menu-button");
                if (restartButton && mainMenuButton) {
                    restartButton.style.backgroundColor = 'black';
                    restartButton.style.color = 'white';
                    mainMenuButton.style.backgroundColor = 'black';
                    mainMenuButton.style.color = 'white';
                }
            }
        }

        // Atjaunina stila preferenci lokālajā krātuvē
        localStorage.setItem('theme', theme);
    }

    // Inicializēt stilu lapas ielādes laikā
    document.addEventListener("DOMContentLoaded", function () {
        // Pārbauda preferenci no lokālās krātuves
        let userThemePreference = localStorage.getItem('theme');

        // Ja userThemePreference ir “tumšs”, iesta tumšo stilu, pretējā gadījumā iestatiet gaišu stilu (noklusējuma variants)
        toggletheme(userThemePreference === 'dark' ? 'dark' : 'light');
    });

    // Pievieno klikšķu notikumu klausītāju Sākt spēli pogai
    document.getElementById("play-button").addEventListener("click", startGame);

    // Funkcija, kas uzsāk spēli
    function startGame() {
        if (!gameStarted) {
            // Paslēpj galvenā ekrāna elementus
            document.getElementById("main-screen").style.display = "none";
            document.getElementById("instructions-screen").style.display = "none";
            document.getElementById("settings-screen").style.display = "none";
            
            // Parāda spēles elementus
            document.getElementById("game-container").style.display = "flex";
            restartGame();
            clearDecorativeShapes();
            gameStarted = true;
        }
    }

    let pauseCooldown = false;
    // Funkcija, kas atļauj apturēt un atsākt spēli
    function togglePause() {
        if (!pauseCooldown) {
            isPaused = !isPaused;

            let pauseMenu = document.getElementById('pause-menu');
            let pauseButton = document.getElementById('pause-button');

            if (isPaused) {
                cancelAnimationFrame(animationID);
                pauseButton.textContent = "▷";
                pauseMenu.style.display = 'block';
            } else {
                requestAnimationFrame(gameLoop);
                pauseButton.textContent = "II";
                pauseMenu.style.display = 'none';
            }

            pauseCooldown = true;
            setTimeout(() => {
                pauseCooldown = false;
            }, 1000);
        }
    }
    
    // Pievienojiet notikumu uztvērēju taustiņam "Esc", lai apturētu/atsāktu spēli
    document.addEventListener("keydown", (event) => {
        if (event.key === "Escape") {
            togglePause();
        }
    });

    // Pievieno klikšķu notikumu klausītāju Pauzes pogai
    document.getElementById('pause-button').addEventListener('click', () => {
        if (!gameOver) {
            togglePause();
        }
    });
    
    // Pievieno klikšķu notikumu klausītāju Atsākt pogai
    document.getElementById('resume-button').addEventListener('click', () => {
        togglePause();
    });

    // Pievieno klikšķu notikumu klausītāju Iestatījumu pogai uz pauzes loga
    document.getElementById('settings-button-pause').addEventListener('click', function handleOpenSettingsPause() {
         document.getElementById('settings-screen-pause').style.display = 'block';
    });

    // Pievieno klikšķu notikumu klausītāju skaņas izvēlnes rūtiņai uz pauzes iestatījumu loga
    document.getElementById("sound-toggle-pause").addEventListener("change", function () {
        soundEnabled = this.checked;
    });

    // Pievieno klikšķu notikumu klausītāju aizvērt pogai uz pauzes iestatījumu loga
    document.getElementById('close-settings-pause').addEventListener('click', function handleCloseSettingsPause() {
            document.getElementById('settings-screen-pause').style.display = 'none';
    });

    // Funkcija, kas apstrādā galvenās lapas pogu pauzes ekrānā
    function handleMainMenuButtonPause() {
        // Paslēpj pauzes logu
        let pauseMenu = document.getElementById('pause-menu');
        pauseMenu.style.display = 'none';
    
        // Parāda galveno ekrānu
        document.getElementById("main-screen").style.display = "flex";
        document.getElementById("game-container").style.display = "none";
        clearDecorativeShapes();
        isPaused = false;
        gameStarted = false;
    }
    
    // Pievieno klikšķu notikumu klausītāju Galvenās lapas pogai uz pauzes loga
    document.getElementById('main-menu-button-pause').addEventListener('click', handleMainMenuButtonPause);    

    let lastTimestamp = 0;
    // Galvenā spēles funkcija
    function gameLoop(timestamp) {
        if (gameStarted && !gameOver) {
            if (isGamePaused()) {
                // Iestata dt uz 0
                var dt = 0;
            } else {
                // Aprēķina delta laiku sekundēs
                var dt = (timestamp - lastTimestamp) / 7;
            }
            lastTimestamp = timestamp;

            // Izsauc nepieciešamās funkcijas
            updateShapePositions(dt);
            clearCanvas();
            drawShapes();
            drawPlayer();
            checkCollisions();
            requestAnimationFrame(gameLoop);
        }
    }

    // Funkcija, kas atjaunina figūras pozīcijas
    function updateShapePositions(dt) {
        for (let i = 0; i < shapes.length; i++) {
            // Pārbauda vai spēle ir apturēta
            if (!isPaused) {
                shapes[i].y += shapeSpeed * dt;
            }
        }
    }
  
    // Funkcija, kas notīra spēles laukumu
    function clearCanvas() {
        ctx.clearRect(0, 0, canvas.width, canvas.height);
    }

    // Funkcija, kas uzzīmē figūras
    function drawShapes() {
        for (let i = 0; i < shapes.length; i++) {
            let shape = shapes[i];
            ctx.drawImage(shape.image, shape.x, shape.y, shape.width, shape.height);
        }
    }

    // Funkcija, kas uzzīmē spēlētāja figūru
    function drawPlayer() {
        ctx.fillStyle = playercolor;
        ctx.fillRect(player.x, player.y, playerWidth, playerHeight);
    }

    let lives = 3;
    let maxLives = 5;
    // Funkcija, kas pievieno un dzēš sirds bildes
    function renderHearts(animationType = false) {
        let heartsContainer = document.getElementById('hearts-container');
        heartsContainer.innerHTML = '';
    
        for (let i = 0; i < lives; i++) {
            let heartImage = document.createElement('img');
            heartImage.src = 'Shapes/heart.png';
            heartImage.alt = 'Heart';
            heartImage.classList.add('heart-image');
            heartsContainer.appendChild(heartImage);
        }
    
        switch (animationType) {
            case 'loseLife':
                // Ja tiek zaudēta dzīvība tad pievieno jaunas sirds bildes elementu
                let lostLifeHeartImage = document.createElement('img');
                lostLifeHeartImage.src = 'Shapes/heart.png';
                lostLifeHeartImage.alt = 'Heart';
                lostLifeHeartImage.classList.add('heart-image', 'life-lost');
    
                // Pievieno animētu sirdi sirds konteineram
                heartsContainer.appendChild(lostLifeHeartImage);
    
                // Pēc animācijas pabeigšanas noņemiet animēto sirds attēlu
                setTimeout(() => {
                    lostLifeHeartImage.remove();
                }, 1000);
                break;
    
            case 'gainLife':
                heartsContainer.removeChild(heartsContainer.lastChild)
                // Pievieno jaunas sirds bildes elementu
                let gainLifeHeartImage = document.createElement('img');
                gainLifeHeartImage.src = 'Shapes/heart.png';
                gainLifeHeartImage.alt = 'Heart';
                gainLifeHeartImage.classList.add('heart-image', 'heart-gain');
                heartsContainer.appendChild(gainLifeHeartImage);
                break;
                
            default:
                break;
        }
    }    

    renderHearts();

    let offSet = 140;
    
    // Funkcija, kas izveido krītošās figūras
    function createShape(yVal) {
        if (gameStarted && !isGamePaused()) {
            // Nejauši ģenerē skaitli no 1 līdz 100
            let randomNumber = Math.random() * 100;
            console.log("Random number: ", randomNumber);
            let randomType;
            
            // Ja nejauši ģenerētais skatilis ir mazāks par 40 (30 ja 2x zvaigznes iespējas papildiespēja ir aktīva) tad izvēlas kvadrātu
            if (randomNumber < 40 - (doubleStarChance ? 10 : 0)) {
                randomType = "square";
            // Ja nejauši ģenerētais skatilis ir mazāks par 70 (60 ja 2x zvaigznes iespējas papildiespēja ir aktīva) tad izvēlas apli
            } else if (randomNumber < 70 - (doubleStarChance ? 10 : 0)) {
                randomType = "circle";
            // Ja nejauši ģenerētais skatilis ir mazāks par 75 (75 ja 2x zvaigznes iespējas papildiespēja ir aktīva) tad izvēlas trijstūri
            } else if (randomNumber < 85 - (doubleStarChance ? 10 : 0)) {
                randomType = "triangle";
            // Ja nejauši ģenerētais skatilis ir mazāks par 95 tad izvēlas zvaigzni
            } else if (randomNumber < 95) {
                randomType = "star";
            // Ja nejauši ģenerētais skatilis ir lielāks par 95 tad izvēlas papildiespēju
            } else {
                randomType = "power-up";
            }

            console.log("Selected Shape Type:", randomType);

            let shape = {
                x: Math.random() * (canvas.width - shapeImageProperties[randomType].width),
                y: yVal - offSet,
                image: shapeImageProperties[randomType].image,
                width: shapeImageProperties[randomType].width,
                height: shapeImageProperties[randomType].height,
                type: randomType,
            };

            shapes.push(shape);
            totalShapesSpawned++; // Palielina kopējo izveidoto figūru
        }   
    }

    // Funkcija, kas pārbauda, kad figūra ir noķerta vai nenoķerta
    function checkCollisions() {
        for (let i = 0; i < shapes.length; i++) {
            let shape = shapes[i];

            if (
                player.x < shape.x + shape.width &&
                player.x + playerWidth > shape.x &&
                player.y < shape.y + shape.height &&
                player.y + playerHeight > shape.y
            ) {
                if (shape.type === "power-up") {
                    // Izsauc papildiespējas funkciju, ja noķertā figūra ir papildiespēja
                    applyPowerUp(shape.type);
                } else {
                    // Izsauc punktu pieskaitīšanas funkciju, ja noķertā figūra nav papildiespēja
                    increasePoints(shape.type);
                }

                let yVal = shapes[i].y
                shapes.splice(i, 1);

                // Izveido jaunu figūru, kad viena tiek noķerta
                createShape(yVal);
                totalShapesSpawned++;

                break;
            } else if (shape.y + shape.height >= canvas.height && shape.type !== "power-up") {
                // Izsauc dzīvības atņemšanas funkciju, ja figūra netiek noķerta (nedarbojas ja nenoķertā figūra ir papildiespēja)
                deductLife();
                let yVal = shapes[i].y
                shapes.splice(i, 1);

                // Izveido jaunu figūru, kad figūra netiek noķerta
                createShape(yVal);
                totalShapesSpawned++;
            }
        }
    }

    // Izveido oriģinālās figūras, lai iesāktu spēli
    let shapeInterval = setInterval(() => {
        if (gameStarted && !isGamePaused() && !gameOver) {
            if (shapesSpawned < 5) {
                createShape(128);
            } else {
                clearInterval(shapeInterval);
            }
        }
    }, shapeGenerationInterval);

    let widthTimer = 0;
    let widthTimerID;
    let doubleStarTimer = 0;
    let doubleStarTimerID;
    let doublePointsTimer = 0;
    let doublePointsTimerID;
    let widthActive = false;
    let originalPlayerWidth = 50;
    let doubleStarChance = false;
    let doublePointsActive = false;
    let shieldActive = false;

    // Funkcija, kas piešķir papildiespēju
    function applyPowerUp(powerUpType) {
        if (powerUpType === "power-up") {
            // Ģenerē nejaušu skaitli no 1 līdz 100
            let randomNumber = Math.floor(Math.random() * 100);
            
            // Ja nejauši ģenerētais skaitlis ir mazāks par 20, tad piešķir platuma papildiespēju
            if (randomNumber < 20) {
                playerWidth = 70;
    
                console.log("Width Power-Up Chosen");
                // Parāda papildiespējas bildi
                let powerUpContainer = document.getElementById("width-container");
                let powerUpImage = document.getElementById("width-image");
                powerUpContainer.style.display = "flex";
                powerUpImage.src = "Powerups/width.png";
    
                // Sāk platuma palīglīdzekļa taimeri
                startWidthTimer();
                widthActive = true;
            // Ja nejauši ģenerētais skaitlis ir mazāks par 40, tad piešķir dzīvību
            } else if (randomNumber < 40) {
                // Pārbauda vai dzīvības ir mazākas par maksimāli atļautajām dzīvībām
                if (lives < maxLives) {
                    // Ja dzīvības ir mazākas par maksimāli atļautajām dzīvībām, tad pievieno 1 dzīvību
                    lives++;
                    renderHearts('gainLife');
                    console.log("+1 Life Power-Up Chosen");
                } else {
                    // Ja dzīvības nav mazākas par maksimāli atļautajām dzīvībām, tad izsauc papildiespējas funkciju vēlreiz
                    console.log("+1 Life reroll..");
                    applyPowerUp("power-up");
                    return;
                }
            // Ja nejauši ģenerētais skaitlis ir mazāks par 60, tad piešķir 2x zvaigznes iesējas papildiespēju
            } else if (randomNumber < 60) {
                console.log("Star Chance Power-Up Chosen");
                // Parāda papildiespējas bildi
                let doubleStarContainer = document.getElementById("double-star-container");
                doubleStarContainer.style.display = "flex";
                let doubleStarImage = document.getElementById("double-star-image");
                doubleStarImage.src = "Powerups/2xStars.png";
    
                // Sāk 2x zvaigznes iesējas papildiespējas taimeri
                startStarPowerUpTimer();
                doubleStarChance = true;
            // Ja nejauši ģenerētais skaitlis ir mazāks par 80, tad piešķir 2x punkti papildiespēju
            } else if (randomNumber < 80) {
                console.log("Double Points Power-Up Chosen");
                // Parāda papildiespējas bildi
                let doublePointsContainer = document.getElementById("double-points-container");
                doublePointsContainer.style.display = "flex";
                let doublePointsImage = document.getElementById("double-points-image");
                doublePointsImage.src = "Powerups/2x.png";
    
                // Sāk 2x punkti papildiespējas taimeri
                startDoublePointsTimer();
                doublePointsActive = true;
            // Ja nejauši ģenerētais skaitlis nav mazāks par 80, tad piešķir vairoga papildiespēju
            } else {
                // Pārbauda vai vairogs ir jau aktīvs
                if (!shieldActive) {
                    // Ja vairogs nav aktīvs, tad parāda papildiespējas bildi
                    let shieldContainer = document.getElementById("shield-container");
                    shieldContainer.style.display = "flex";
                    let shieldImage = document.getElementById("shield-image");
                    shieldImage.src = "Powerups/Shield.png";
    
                    // Iestata ka vairogs ir aktīvs
                    shieldActive = true;
                    console.log("Shield Power-Up Chosen");
                } else {
                    // Ja vairogs jau ir aktīvs, tad izsauc papildiespējas funkciju vēlreiz
                    console.log("Shield reroll..")
                    applyPowerUp("power-up");
                    return;
                }
            }
        }
    }
    
    // Funkcija, kas uzsāk platuma papildiespējas taimeri
    function startWidthTimer() {
        let widthTimerElement = document.getElementById("width-timer");
        widthTimer = 10;

        widthTimerElement.textContent = widthTimer;

        if (widthActive) {
            return;
        }

        // Aptur taimeri, ja spēle ir apturēta
        widthTimerID = setInterval(() => {
            if (isPaused) {
                return;
            }

            widthTimer--;
            widthTimerElement.textContent = widthTimer;

            if (widthTimer <= 0) {
                // Aptur taimeri un paslēpj papildiespējas bildi, kad taimera laiks ir mazāks vai vienāds ar 0
                clearInterval(widthTimerID);
                document.getElementById("width-container").style.display = "none";

                // Atjaunina spēlētāja oriģinālo platumu
                playerWidth = originalPlayerWidth;
                widthActive = false;
            }
        }, 1000);
    } 

    // Funkcija, kas uzsāk 2x zvaigznes iesējas papildiespējas taimeri
    function startStarPowerUpTimer() {
        let doubleStarTimerElement = document.getElementById("double-star-timer");
        doubleStarTimer = 10;

        doubleStarTimerElement.textContent = doubleStarTimer;

        if (doubleStarChance) {
            return;
        }

        // Aptur taimeri, ja spēle ir apturēta
        doubleStarTimerID = setInterval(() => {
            if (isPaused) {
                return;
            }

            doubleStarTimer--;
            doubleStarTimerElement.textContent = doubleStarTimer; 

            if (doubleStarTimer <= 0) {
                // Aptur taimeri un paslēpj papildiespējas bildi, kad taimera laiks ir mazāks vai vienāds ar 0
                clearInterval(doubleStarTimerID);
                document.getElementById("double-star-container").style.display = "none";
                doubleStarChance = false;
            }
        }, 1000);
    }

    // Funkcija, kas uzsāk 2x punktu papildiespējas taimeri
    function startDoublePointsTimer() {
        let doublePointsTimerElement = document.getElementById("double-points-timer");
        doublePointsTimer = 10;

        doublePointsTimerElement.textContent = doublePointsTimer;

        if (doublePointsActive) {
            return;
        }

        // Aptur taimeri, ja spēle ir apturēta
        doublePointsTimerID = setInterval(() => {
            if (isPaused) {
                return;
            }

            doublePointsTimer--;
            doublePointsTimerElement.textContent = doublePointsTimer;

            if (doublePointsTimer <= 0) {
                // Aptur taimeri un paslēpj papildiespējas bildi, kad taimera laiks ir mazāks vai vienāds ar 0
                clearInterval(doublePointsTimerID);
                document.getElementById("double-points-container").style.display = "none";
                doublePointsActive= false;
            }
        }, 1000);
    }

    // Funkcija, kas izveidu punktu pieskaitīšanas animāciju
    function playPointsAnimation(pointsGained) {
        let pointsCounter = document.getElementById("points-count");
        let animationsContainer = document.getElementById("points-animations-container");
        points += pointsGained;
        pointsCounter.textContent = points;
    
        // Izveido jaunu animācijas elementu
        let animationContainer = document.createElement("div");
        animationContainer.classList.add("points-animation");
        animationContainer.textContent = `+${pointsGained}`;
        
        // Nomaina teksta krāsu atkarībā no izvēlētā stila
        let theme = localStorage.getItem('theme');
        if (theme === 'dark') {
            animationContainer.style.color = 'white';
        } else {
            animationContainer.style.color = 'black';
        }
    
        animationsContainer.appendChild(animationContainer);
    
        // Noņem animācijas elementu, kad animācija beigusies
        setTimeout(() => {
            animationsContainer.removeChild(animationContainer);
        }, 1000);
    }
    
    // Funkcija, kas pieskaita punktus
    function increasePoints(type) {
        let pointsToAdd = 1;
        
        // Ja noķertā figūra ir aplis, tad pieskaita 3 punktus
        if (type === "circle") {
            pointsToAdd = 3;
        // Ja noķertā figūra ir trijstūris, tad pieskaita 5 punktus
        } else if (type === "triangle") {
            pointsToAdd = 5;
        // Ja noķertā figūra ir zvaigzne, tad pieskaita 10 punktus
        } else if (type === "star") {
            pointsToAdd = 10;
        }
        
        // Sareizina iegūtos punktus ar 2, ja 2x punktu papildiespēja ir aktīva
        if (doublePointsActive) {
            pointsToAdd *= 2;
        }
        
        // Matēmātiska formula, kas izmaina krītošo figūru ātrumu atkarībā no punktu skaita
        shapeSpeed = 0.2 + Math.floor(Math.sqrt(points/10)) / 10;
        
        // Atjaunina punktu displeju
        let pointsCountElement = document.getElementById("points-count");
        if (pointsCountElement) {
            pointsCountElement.textContent = points;
        }

        playPointsAnimation(pointsToAdd);

        // Atskaņo figūras uztveršanas skaņas audio
        if (soundEnabled) {
            try {
                let catchSoundClone = catchSound.cloneNode();
                catchSoundClone.play();
            } catch (error) {
                console.error("Error playing catch sound:", error);
            }
        }
        updateShapeInfo();
    }

    // Funkcija igūras informācijas atjaunināšanai
    function updateShapeInfo() {
        let shapeInfoItems = document.querySelectorAll(".shape-info-item");

        shapeInfoItems.forEach((item) => {
            let shapeImage = item.querySelector("img");
            let shapeType = shapeImage.alt;
            let pointValue = getPointValueForShape(shapeType);

            let pointLabel = item.querySelector("span");
            pointLabel.textContent = `= ${pointValue} points`;
        });
    }

    // Funkcija figūras punkta vērtības iegūšanai
    function getPointValueForShape(shapeType) {
        switch (shapeType) {
            case "circle":
                return 3;
            case "triangle":
                return 5;
            case "star":
                return 10;
            case "square":
            default:
                return 1;
        }
    }

    let gameOver = false;
    // Funkcija, kas atņem dzīvību
    function deductLife() {
        if (shieldActive) {
            // Ja vairoga papildiespēja ir aktīva, deaktivizē to un novērš dzīvības zaudēšanu
            shieldActive = false;
            let shieldContainer = document.getElementById("shield-container");
            shieldContainer.style.display = "none";
    
            return;
        }
        
        // Atņem dzīvību
        lives--;
        renderHearts('loseLife');
        
        // Pārbauda vai skaņa ir ieslēgta
        if (soundEnabled) {
            try {
                // Atskaņo figūras nenoķeršanas skaņu, ja skaņa ir ieslēgta
                let lifeLossSoundClone = lifeLossSound.cloneNode();
                lifeLossSoundClone.play();
            } catch (error) {
                console.error("Error playing life loss sound:", error);
            }
        }
    
        let livesCountElement = document.getElementById("lives-count");
        if (livesCountElement) {
            livesCountElement.textContent = lives;
        }
        
        // Pārbauda vai dzīvības ir mazāk vai vienādas ar 0
        if (lives <= 0) {
            gameOver = true;
            // Pārbauda vai skaņa ir ieslēgta
            if (soundEnabled) {
                try {
                    // Atskaņo spēles beigas skaņu, ja skaņa ir ieslēgta
                    gameOverSound.play();
                } catch (error) {
                    console.error("Error playing game over sound:", error);
                }
            }
            showGameOverScreen();
            return;
        }
    }

    let gameOverScreen = document.getElementById("game-over-screen");
    let highestScore = getCookie("highestScore") || 0;
    let userName = getCookie("username");

    // Funkcija, kas parāda spēles beigas logu
    function showGameOverScreen() {
        let gameOverScreen = document.getElementById("game-over-screen");
        // Parāda spēles beigas logu
        if (gameOverScreen) {
            gameOverScreen.style.display = "block";
        }
        
        let gameOverScoreElement = document.getElementById("game-over-score");
        // Parāda iegūto punktu skaitu
        if (gameOverScoreElement) {
            gameOverScoreElement.textContent = points;
        }
    
        // Pārbauda vai iegūtais punktu skaits ir lielāks par labāko iegūto punktu skaitu
        if (points > highestScore) {
            highestScore = points;
    
            // Atjauniniet sīkdatni, lai saglabātu jauno augstāko rezultātu
            setCookie("highestScore", highestScore, 365);
    
            // Izsauc funkciju, kas atjauninās jauno labāko iegūto punktu skaitu datubāzē
            updateScoreInDatabase(userName, points); 
        }
        // Izsauc funkciju, kas parāda labāko iegūto punktu skaitu
        displayHighestScore();
    }

    // Funkcija, kas parāda labāko iegūto punktu skaitu
    function displayHighestScore() {
        let highestScoreElement = document.getElementById("highest-score");
        if (highestScoreElement) {
            highestScoreElement.textContent = highestScore;
        }
    }

    // Pievieno klikšķu notikumu klausītāju Spēlēt Vēlreiz pogai
    document.getElementById("restart-button").addEventListener("click", function handleRestartGame() {
        gameOverScreen.style.display = "none";
        restartGame();
    }); 
    
    // Pievieno klikšķu notikumu klausītāju Galvenās lapas pogai
    document.getElementById("main-menu-button").addEventListener("click", () => {
        // Paslēpj spēles beigas logu
        document.getElementById("game-over-screen").style.display = "none";
        document.getElementById("game-container").style.display = "none";
        // Parāda galveno ekrānu
        document.getElementById("main-screen").style.display = "flex";
        // Izsauc funkciju, kas notīra dekoratīvās figūras
        clearDecorativeShapes();
        gameStarted = false;
    });

    // Funkcija, kas atjauno rezultātu datubāzē
    function updateScoreInDatabase(score) {
        let updateScoreURL = "update-highest-score.php";
        let user = getCookie("username");
        // Izveido FormData objektu, lai nosūtītu datus uz serveri
        let formData = new FormData();
        formData.append('username', user);
        formData.append('score', score);
    
        // Nosūta POST pieprasījumu, lai atjauninātu lietotāja rezultātu
        fetch(updateScoreURL, {
            method: 'POST',
            body: formData,
        })
        .then(response => response.text())
        .then(data => {
            if (data === "updated") {
                console.log("Score updated successfully.");
            } else {
                console.error("Failed to update the score.");
            }
        })
        .catch(error => {
            console.error("An error occurred while updating the score:", error);
        });
    }
    
    // Funkcija, kas restartē spēli
    function restartGame() {
        points = 0;
        lives = 3;
        shapeSpeed = 0.2;
        shapeGenerationInterval = 2000;
        shapes.length = 0;
        document.getElementById("points-count").textContent = points;
        document.getElementById("pause-button").textContent = "II";
        // Atjauno dzīvību skaitu
        let livesCountElement = document.getElementById("lives-count");
        if (livesCountElement) {
            livesCountElement.textContent = lives;
        }
        // Izsauc sirds bildes ielādēšanas funkciju
        renderHearts();
        playerWidth = originalPlayerWidth;

        // Notīra visus papieldiespējas taimerus, ja tie ir aktīvi
        if (widthTimerID) {
            clearInterval(widthTimerID);
        }
        if (doubleStarTimerID) {
            clearInterval(doubleStarTimerID);
        }
        if (doublePointsTimerID) {
            clearInterval(doublePointsTimerID);
        }
    
        // Atiestata papildiespējas stāvokli
        widthActive = false;
        doubleStarChance = false;
        doublePointsActive = false;
        shieldActive = false;
        // Atiestata spēles beigas stāvokli
        gameOver = false;
        gameOverScreen.style.display = "none";
        // Notīra visus papildiespējas konteinerus 
        document.getElementById("width-container").style.display = "none";
        document.getElementById("double-star-container").style.display = "none";
        document.getElementById("double-points-container").style.display = "none";
        document.getElementById("shield-container").style.display = "none"
        // Atiestata izveidoto figūru skaitu uz 0
        totalShapesSpawned = 0;
    
        // Notīra esošo figūru ģenerēšanas intervālu
        clearInterval(shapeInterval);
        // Atsāk spēles galveno funkciju
        requestAnimationFrame(gameLoop);
    
        // Sāk ģenerēt figūras vēlreiz, izveidojot jaunu intervālu
        shapeInterval = setInterval(() => {
            if (gameStarted && !isGamePaused() && !gameOver) {
                if (totalShapesSpawned < 9) {
                    createShape(128);
                    totalShapesSpawned++;
                } else {
                    clearInterval(shapeInterval);
                }
            }
        }, shapeGenerationInterval);
    }          

    // Funkcija, kas pārbauda vai spēle ir apturēta
    function isGamePaused() {
        return isPaused;
    }

    animationID = requestAnimationFrame(gameLoop);
});