document.addEventListener("DOMContentLoaded", function () {
    const nameForm = document.getElementById("name-form");
    const nameInputContainer = document.getElementById("name-input-container");
    const leaderboardsButton = document.getElementById("leaderboards-button");
    const leaderboardsContainer = document.getElementById("leaderboards-container");
    const leaderboardStandings = document.getElementById("leaderboards-standings");

    function setCookie(cname, cvalue, exdays) {
        const d = new Date();
        d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
        let expires = "expires=" + d.toUTCString();
        document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
    }

    function getCookie(cname) {
        let name = cname + "=";
        let ca = document.cookie.split(';');
        for (let i = 0; i < ca.length; i++) {
            let c = ca[i];
            while (c.charAt(0) === ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) === 0) {
                return c.substring(name.length, c.length);
            }
        }
        return "";
    }

    // Pārbauda vai "username" sīkdatne eksistē
    var userName = getCookie("username");

    if (userName !== "") {
        // Ja sīkfails eksistē, tad iestata ievades lauka vērtību un paslēpj ievades konteineri
        const nameInput = document.getElementById("name-input");
        nameInput.value = userName;
        nameInputContainer.style.display = "none";
    }

    // Funkcija, kas iesniedz lietotājvaārdu datubāzē
    function SubmitName() {
        nameForm.addEventListener("submit", function (e) {
            e.preventDefault();
    
            const nameInput = document.getElementById("name-input");
            // Dabū lietotāja ievadīto vārdu
            userName = nameInput.value;
    
            // Nosūta pieprasījumu uz PHP failu, lai pārbaudītu vai lietotājvārds eksistē
            const xhr = new XMLHttpRequest();
            const url = "shapecatcher.php";
            const params = "username=" + userName;
            xhr.open("POST", url, true);
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    const response = xhr.responseText;
                    // Ja lietotājvārds datu bāzē neeksistē
                    if (response === "neeksiste") {
    
                        // Iestata "username" sīkdatni
                        setCookie("username", userName, 365);
                        alert("Sveiki " + userName + "!");
                        nameInputContainer.style.display = "none";
                    } else {
                        // Lietotājvārds jau pastāv, parāda kļūdas ziņojumu
                        alert("Lietotājvārds jau eksistē, lūdzu ievadiet citu!");
                    }
                }
            };

            xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            xhr.send(params);
        });
    }

    SubmitName();
    leaderboardsButton.addEventListener("click", function handleOpenLeaderboards() {
        // Parāda līderu sarakstu, kad Līderu saraksta poga tiek nospiesta
        leaderboardsContainer.style.display = "flex";
        leaderboardStandings.style.display = "flex";
        leaderboardStandings.style.opacity = "1";
        leaderboardStandings.style.visibility = "visible";
        updateLeaderboard();
    });

    const closeButton = document.getElementById("close-leaderboards");
    closeButton.addEventListener("click", function () {
        // Aizver līderu sarakstu, kad aizvērt poga ir nospiesta
        leaderboardsContainer.style.display = "none";
        leaderboardStandings.style.display = "none";
    });

    // Funkcija, kas ievada 10 augstākos rezultātus līderu sarakstā
    function updateLeaderboard() {
        const leaderboardStandings = document.getElementById("leaderboards-standings");
        const leaderboardURL = "leaderboard.php";
    
        // Iegūstiet līderu datus
        fetch(leaderboardURL)
            .then((response) => response.json())
            .then((data) => {
                if (data.length > 0) {
                    // Sakārto datus sākot ar augstāko
                    data.sort((a, b) => b.score - a.score);
    
                    const selectedLanguage = document.getElementById("language-select").value;
    
                    // Izveido HTML virkni līderu sarakstam ar vietām
                    const leaderboardHTML = data
                        .slice(0, 10)
                        .map((entry, index) => {
                            const rank = index + 1;
                            let rankClass = "";
                            
                            // Pārbauda vai iegūtā vieta ir pirmā
                            if (rank === 1) {
                                rankClass = "first-rank";
                            // Pārbauda vai iegūtā vieta ir otrā
                            } else if (rank === 2) {
                                rankClass = "second-rank";
                            // Pārbauda vai iegūtā vieta ir trešā
                            } else if (rank === 3) {
                                rankClass = "third-rank";
                            }
    
                            // Pārbauda izvēlēto valodu un iestatiet atbilstošo vārdu "punkti"
                            const pointsWord = selectedLanguage === "latvian" ? "punkti" : (selectedLanguage === "russian" ? "счет" : "points");
                            return `<li><span class="rank ${rankClass}">${rank}. </span> <span class="username"> ${entry.username} - </span> <span class="score">${entry.score} ${pointsWord}</span></li>`;
                        })
                        .join("");
    
                    // Atjaunina līderu sarakstu
                    leaderboardStandings.innerHTML = `<ol>${leaderboardHTML}</ol>`;
                } else {
                    leaderboardStandings.innerHTML = "<p>No data available.</p>";
                }
            })
            .catch((error) => {
                console.error("An error occurred while fetching the leaderboard data:", error);
                leaderboardStandings.innerHTML = "<p>Error loading data.</p>";
            });
    }      
});
