<?php
// Pārbauda, vai forma ir iesniegta POST metodi
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Pārbauda, vai visi nepieciešamie dati ir saņemti
    if (isset($_POST['username']) && isset($_POST['password']) && isset($_POST['email'])) {
        // Savienojas ar datubāzi
        $servername = "localhost";
        $username = "root";
        $password = "";
        $dbname = "ml_projekts";

        $conn = new mysqli($servername, $username, $password, $dbname);

        // Pārbauda savienojuma veiksmīgumu
        if ($conn->connect_error) {
            die("Savienojuma neveiksme: " . $conn->connect_error);
        }

        // Saglabā datus no formas un attīra tos no iespējamajiem SQL injekcijas uzbrukumiem
        $username = $conn->real_escape_string($_POST['username']);
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT); // Izveido paroles hešu
        $email = $conn->real_escape_string($_POST['email']);

        // Saglabā datus datubāzē, izmantojot prepared statement, lai novērstu SQL injekcijas
        $stmt = $conn->prepare("INSERT INTO users (username, password, email) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $username, $password, $email);

        if ($stmt->execute()) {
            echo "Reģistrācija ir veiksmīga!";
            // Pāreja uz index.html lapu vai jebkuru citu lapu, uz kuru vēlaties pāriet pēc reģistrācijas
            header("Location: index.html");
            exit();
        } else {
            echo "Kļūda, reģistrācija neizdevās: " . $stmt->error;
        }

        // Aizver prepared statement un savienojumu
        $stmt->close();
        $conn->close();
    } else {
        echo "Nav saņemti visi nepieciešamie dati!";
    }
}
?>
