<?php
// Pārbauda, vai forma ir iesniegta POST metodi
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Pārbauda, vai visi nepieciešamie dati ir saņemti
    if (isset($_POST['payment-method']) && isset($_POST['delivery-method']) && isset($_POST['delivery-address'])) {
        // Savienojas ar datubāzi
        $servername = "localhost";
        $username = "root";
        $password = "";
        $dbname = "ml_projekts";

        $conn = new mysqli($servername, $username, $password, $dbname);

        // Pārbauda savienojuma veiksmīgumu
        if ($conn->connect_error) {
            die("Savienojuma neveiksme: " . $conn->connect_error);
        }

        // Saglabā datus no formas un attīra tos no iespējamajiem SQL injekcijas uzbrukumiem
        $payment_method = $conn->real_escape_string($_POST['payment-method']);
        $delivery_method = $conn->real_escape_string($_POST['delivery-method']);
        $delivery_address = $conn->real_escape_string($_POST['delivery-address']);

        // Saglabā datus datubāzē, izmantojot prepared statement, lai novērstu SQL injekcijas
        $stmt = $conn->prepare("INSERT INTO pasutijumi (payment_method, delivery_method, delivery_address) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $payment_method, $delivery_method, $delivery_address);

        if ($stmt->execute()) {
            // Ja veiksmīgi saglabāts, pāriet uz index.html lapu
            header("Location: index.html");
            exit();
        } else {
            echo "Kļūda, pasūtījums netika saglabāts: " . $stmt->error;
        }

        // Aizver prepared statement un savienojumu
        $stmt->close();
        $conn->close();
    } else {
        echo "Nav saņemti visi nepieciešamie dati!";
    }
}
?>
