// Iegūst produktus no servera un attēlo tos
function fetchAndDisplayProducts() {
  fetch('/api/products')
    .then(response => {
      if (!response.ok) {
        throw new Error('Network response was not ok');
      }
      return response.json();
    })
    .then(products => {
      const productSection = document.getElementById('product-section');
      products.forEach(product => {
        const productCard = document.createElement('div');
        productCard.className = 'product-card';
        productCard.innerHTML = `
          <img src="${product.image}" alt="${product.name}" />
          <h2>${product.name}</h2>
          <p>${product.description}</p>
          <p>Price: $${product.price}</p>
          <button onclick="addToCart('${product.id}')">Add to Cart</button>
        `;
        productSection.appendChild(productCard);
      });
    })
    .catch(error => console.error('Error fetching products:', error));
}

// Pievieno produktu grozam
function addToCart(productId) {
  console.log('Adding product to cart with ID:', productId);
  // Jūs varat pievienot šeit kodu, kas pievieno produktu grozam
}

// Izpilda funkciju, lai iegūtu produktus un attēlotu tos, kad lapa ir pilnībā ielādēta
window.onload = function() {
  fetchAndDisplayProducts();
};