<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>GarbGrove - User Account</title>
  <style>
       body {
      font-family: Arial, sans-serif;
      margin: 0;
      padding: 0;
      background-color: #f4f4f4;
    }

    header {
      background-color: #232f3e;
      color: #fff;
      padding: 20px;
      text-align: center;
    }

    .container {
      max-width: 800px;
      margin: 20px auto;
      background-color: #fff;
      border-radius: 8px;
      padding: 20px;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    h2 {
      color: #232f3e;
    }

    .profile-info {
      margin-bottom: 20px;
    }

    .profile-info label {
      display: block;
      font-weight: bold;
    }

    .profile-info p {
      margin: 5px 0 15px 0;
    }

    .profile-photo {
      text-align: center;
      margin-bottom: 20px;
    }

    .profile-photo img {
      width: 150px;
      height: 150px;
      border-radius: 50%;
      object-fit: cover;
      margin-bottom: 10px;
    }

    .button-container {
      text-align: center;
    }

    button {
      background-color: #ff9900;
      color: #fff;
      padding: 10px 15px;
      border: none;
      border-radius: 4px;
      cursor: pointer;
      margin-right: 5px;
    }

    .logout-button {
      background-color: #555;
    }

    button:hover {
      background-color: #333;
    }
  </style>
</head>
<body>
  <header>
    <h1>Laipni lūdzam, <?php echo $_SESSION['username']; ?></h1>
  </header>

  <div class="container">
    <h2>Jūsu konta informācija</h2>
    <div class="profile-info">
      <div class="profile-photo">
        <?php
        $stmt = $conn->prepare("SELECT profile_photo_url FROM users WHERE id = ?");
        $stmt->bind_param("i", $_SESSION['user_id']);
        $stmt->execute();
        $stmt->bind_result($profile_photo_url);
        $stmt->fetch();
        $stmt->close();

        if ($profile_photo_url) {
            echo "<img src='$profile_photo_url' alt='Profile Photo' id='profilePhoto'>";
        } else {
            echo "<img src='default_profile_photo.jpg' alt='Profile Photo' id='profilePhoto'>"; // Путь к изображению по умолчанию
        }
        ?>
        <form id="uploadForm" enctype="multipart/form-data" method="post" action="upload_photo.php">
          <input type="file" name="profilePhoto" accept="image/*" required>
          <button type="submit" name="submit">Augšupielādēt foto</button>
        </form>
      </div>
      <label>Lietotājvārds:</label>
      <p><?php echo $_SESSION['username']; ?></p>
      <label>E-pasta adrese:</label>
      <p><?php echo $_SESSION['email']; ?></p>
    </div>
    <div class="button-container">
      <button onclick="window.location.href='edit_profile.html'">Rediģēt profilu</button>
      <button class="logout-button" onclick="window.location.href='logout.php'">Iziet</button>
    </div>
  </div>
</body>
</html>
