// Piemēra dati par groza vienumiem
const cartItems = [
    { name: 'Produkts 1', price: 10.00, quantity: 1 },
    { name: 'Produkts 2', price: 15.50, quantity: 2 }
];

// Funkcija, lai atjauninātu kopējo cenu
function updateTotalPrice() {
    const totalPrice = cartItems
		.reduce(
			(sum, item) => sum + item.price * item.quantity,
			0
		)
		.toFixed(2);
    document.getElementById('totalPrice')
		.innerText = `${totalPrice} €`;
}

// Funkcija, lai izveidotu groza vienumus tabulā
function renderCartItems() {
    const cartTableBody = document.querySelector('#cartTable tbody');
    cartTableBody.innerHTML = '';

    cartItems.forEach(
		(item, index) => {
        const row = document.createElement('tr');

        row.innerHTML = `
            <td>${item.name}</td>
            <td>${item.price.toFixed(2)} €</td>
            <td>
                <input type="number" value="${item.quantity}" min="1" data-index="${index}">
            </td>
            <td>${(item.price * item.quantity).toFixed(2)} €</td>
            <td>
                <button class="remove-button" data-index="${index}">Dzēst</button>
            </td>
        `;

        cartTableBody.appendChild(row);
    });

    updateTotalPrice();
}

// Funkcija, lai apstrādātu daudzuma izmaiņas
document.querySelector('#cartTable tbody')
	.addEventListener('input', 
	function(event) {
		if (event.target.type === 'number') {
			const index = event.target.dataset.index;
			const newQuantity = parseInt(event.target.value);
			cartItems[index].quantity = newQuantity;
			renderCartItems();
		}
	}
);

// Funkcija, lai apstrādātu vienuma dzēšanu
document.querySelector('#cartTable tbody')
	.addEventListener(
		'click', 
		function(event) {
			if (event.target.classList.contains('remove-button')) {
				const index = event.target.dataset.index;
				cartItems.splice(index, 1);
				renderCartItems();
			}
		}
	);

// Funkcija, lai apstrādātu apmaksas pogu
document
	.getElementById('checkoutButton')
	.addEventListener(
		'click', 
		function() {
			alert('Paldies par pirkumu!');
			// Šeit var pievienot loģiku apmaksas apstrādei
		}
	);

// Izveido sākotnējo groza vienumu sarakstu
renderCartItems();