if script.RunContext.Value == 2 or script.RunContext.Value == 3 then
	warn("Crescendum Whitelist : Script RunContext Invalid")
	return nil
end

function setfenv()
	return "Invalid."
end
function getfenv()
	return "Invalid."
end
function rawequal()
	return "Invalid."
end
function rawget()
	return "Invalid."
end
function rawlen()
	return "Invalid."
end
function rawset()
	return "Invalid."
end
function setmetatable()
	return "Invalid."
end

if _VERSION ~= "Luau" then
	return nil
end


local Crescendum = game:GetService("ServerScriptService"):WaitForChild("Crescendum_Framework"):WaitForChild("Crescendum")
local CrescentService = game:GetService("ServerScriptService"):WaitForChild("Crescendum_Framework"):WaitForChild("Crescendum"):WaitForChild("Crescent")
local CrescentAPI = require(CrescentService) or nil

local Connections = {}
local ShipSystemVersion = ("2.0")
local ShipControllerVersion = ("2.0a")
local HTTP = game:GetService("HttpService")

local sc_results = {
	["result_1"] = 1,
	["result_2"] = 2,
	["result_3"] = 3,
	["result_4"] = 4,
}

local sc_old = {
	["result_1"] = nil,
	["result_2"] = nil,
	["result_3"] = nil,
	["result_4"] = nil,
}


function StopScriptFunction()
	for index, value in pairs(Connections) do 
		value:Disconnect()
	end
	script:Destroy()
	error("Ship System: Failed Check")
end

if CrescentService and CrescentAPI  then
	CrescentAPI.SetCallback("ValidateShipController", function(result)
		local sc_new = {}
		sc_new.result_4 = HTTP:GenerateGUID()
		sc_new.result_3 = HTTP:GenerateGUID()
		sc_new.result_2 = HTTP:GenerateGUID()
		sc_new.result_1 = result

		sc_results = sc_new
		return {result, script, ShipControllerVersion}
	end)
end

local function CheckSCKeys()
	if
		sc_results.result_4 == sc_old.result_4 and
		sc_results.result_3 == sc_old.result_3 and
		sc_results.result_2 == sc_old.result_2 and
		sc_results.result_1 == sc_old.result_1 and sc_results.result_1 == nil or
		_G.ICRESSS == false or _G.ICRESSS == nil
	then
		StopScriptFunction()
	end
end

repeat task.wait() until (_G.CRES_SC ~= nil and _G.ICRESSS ~= nil)

coroutine.resume(coroutine.create(function()
	while true do
		task.wait(30)
		_G.CRES_SC("ShipController") 
		task.wait(5)
		CheckSCKeys()
		sc_old = sc_results
	end
end))



if not game:GetService("ServerScriptService"):FindFirstChild("Crescendum_Framework"):FindFirstChild("Crescendum") or game:GetService("ServerScriptService"):FindFirstChild("Crescendum_Framework"):FindFirstChild("Crescendum").Disabled == true then
	StopScriptFunction()
end

local ReplicatedStorage = game:GetService("ReplicatedStorage")
ReplicatedStorage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("GerstnerWaves")
ReplicatedStorage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("SystemSettings")
ReplicatedStorage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("Ships")
ReplicatedStorage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("WaterAssets")
ReplicatedStorage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("Chunks")
ReplicatedStorage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("RemoteHiearchy")
local ThirdParty = ReplicatedStorage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("ThirdPartyDependencies")
ReplicatedStorage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("ShipSpawn")

local RunService = game:GetService("RunService")
if game.CreatorId ~= 25583235 then
	if RunService:IsStudio() == true then
		StopScriptFunction()
		error("Ship System: Running in Studio")
	end
end

local tween_service = game:GetService("TweenService")
local players = game:GetService("Players")

local folder = script.Parent
local ShipIdentifier

if folder:WaitForChild("Identifier") then
	if string.len(folder.Identifier.Value) == 36 then
		ShipIdentifier = folder.Identifier.Value
	else
		script:Destroy()
	end
end

local ScriptService = game:GetService("ServerScriptService")

ScriptService:WaitForChild("Crescendum_Ship_System")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Client")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Server")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Client"):WaitForChild("Client")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Server"):WaitForChild("Float")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Server"):WaitForChild("SailSystem")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Server"):WaitForChild("ShipController")

local FrameworkFolder = ScriptService:WaitForChild("Crescendum_Ship_System")
local ReadyValueSSF = FrameworkFolder:WaitForChild("SSF_Ready")
local Framework = FrameworkFolder:WaitForChild("ShipSystemFramework")
local Callback = Framework:WaitForChild("Callback")

local VersionValue = Framework:WaitForChild("Version")

if VersionValue.Value == ShipSystemVersion then
else
	error("Ship System: Incompatible Version")
end

local ENC_Key1 = 7553624
local ENC_Key2 = 5241

local inv256
function EncodeString(str)
	if not inv256 then
		inv256 = {}
		for M = 0, 127 do
			local inv = -1
			repeat inv = inv + 2
			until inv * (2*M + 1) % 256 == 1
			inv256[M] = inv
		end
	end
	local K, F = ENC_Key1, 16384 + ENC_Key2
	return (str:gsub('.',
		function(m)
			local L = K % 274877906944  -- 2^38
			local H = (K - L) / 274877906944
			local M = H % 128
			m = m:byte()
			local c = (m * inv256[M] - (H - M) / 128) % 256
			K = L * F + H + c + m
			return ('%02x'):format(c)
		end
		))
end

function DecodeString(str)
	local K, F = ENC_Key1, 16384 + ENC_Key2
	return (str:gsub('%x%x',
		function(c)
			local L = K % 274877906944  -- 2^38
			local H = (K - L) / 274877906944
			local M = H % 128
			c = tonumber(c, 16)
			local m = (c + (H - M) / 128) * (2*M + 1) % 256
			K = L * F + H + c + m
			return string.char(m)
		end
		))
end

local function Invoke_Callback(ShipModel, IdentifierCode)
	local SentEncodedString = EncodeString(IdentifierCode)

	local Callback_Return = Callback:Invoke(script, ShipModel, SentEncodedString)

	if Callback_Return then
		local UID = Callback_Return.UID
		local EncodedString = Callback_Return.String

		if UID then
			if DecodeString(EncodedString) == IdentifierCode then
				return true
			end
		end
	end
	ShipModel:Destroy()
end

local Ship_Model = script.Parent.Parent
local IdentityFolder = Framework:WaitForChild("Identity")

local function CheckIdentity()
	if IdentityFolder[ShipIdentifier] then
		if DecodeString(IdentityFolder[ShipIdentifier].Value) == ShipIdentifier then
			return true;
		end
	end
	Ship_Model:Destroy()
	return nil;
end

coroutine.resume(coroutine.create(function()
	while true do
		task.wait(10)
		if CheckIdentity() then
		else
			Ship_Model:Destroy()
		end
		if Invoke_Callback(Ship_Model,ShipIdentifier) then
		else
			Ship_Model:Destroy()
		end
	end
end))

local ClientSettings = require(Ship_Model:WaitForChild("Captain"):WaitForChild("ClientSettings"))

local hornplaying = false
local Anchor_Moving = false

local TagService = game:GetService("CollectionService")
local Debris = game:GetService("Debris")

local Settings = Ship_Model:WaitForChild("Settings")
local Values = Ship_Model:WaitForChild("Values")

local CaptainSeat = Ship_Model:WaitForChild("Captain")

local Rotation = Values:WaitForChild("Rotation")
local Pitch = nil
local Roll = nil
local Anchored = Values:WaitForChild("Anchored")
local Sinking = Values:WaitForChild("Sinking")

local HealthValues = Values:WaitForChild("HealthValues")

local Health_Table = {
	["Front"] = HealthValues:WaitForChild("FrontHealth"),
	["Rear"] = HealthValues:WaitForChild("RearHealth"),
	["Right"] = HealthValues:WaitForChild("RightHealth"),
	["Left"] = HealthValues:WaitForChild("LeftHealth"),
}

local CollisionValues = Settings:WaitForChild("Collision")
local RotorValues = Settings:WaitForChild("Rotor")
local SoundValues = Settings:WaitForChild("Sound")
local FunnelSmokeValues = Settings:WaitForChild("FunnelSmoke")
local RudderValues = Settings:WaitForChild("Rudder")

local UseSideThrusters = Settings.UseSideThrusters.Value or true
local IsSailShip = false
local IsAngularControls = false
local IsEngineShip = false

local CollisionMinimumSpeed = CollisionValues:WaitForChild("CollisionMinimumSpeed")
local CollisionDamageRatio = CollisionValues:WaitForChild("CollisionDamageRatio")

local BridgeNet = require(ThirdParty:WaitForChild("BridgeNet"))

local horn_remote = Instance.new("RemoteEvent")
horn_remote.Name = "Horn"
horn_remote.Parent = script.Parent

local anchor_remote = Instance.new("RemoteEvent")
anchor_remote.Name = "Anchor"
anchor_remote.Parent = script.Parent

local Sound_Remote = Instance.new("RemoteEvent")
Sound_Remote.Name = "SoundToggle"
Sound_Remote.Parent = script.Parent

local Ship = script.Parent.Parent

local ShipMainPart = Ship:WaitForChild("Ship")
local seat = Ship:WaitForChild("Captain")
local MainPart = Ship:WaitForChild("Ship")
local Body = Ship:WaitForChild("Body")
local EffectPoints = Ship:WaitForChild("EffectPoints")

if Ship_Model:FindFirstChild("Sails") then
	IsSailShip = true
	local Sail_remote = Instance.new("RemoteEvent")
	Sail_remote.Name = "SailController"
	Sail_remote.Parent = script.Parent
	
	local SailIncrement = Values:WaitForChild("SailPowerIncrement")
	local Sailing = Values:WaitForChild("Sailing")

	local SailController_connection = Sail_remote.OnServerEvent:Connect(function(plr, state)
		if seat.Occupant and players:GetPlayerFromCharacter(seat.Occupant.Parent) == plr then
			if state == "SailsUp" then
				if SailIncrement.Value == "Dead Stop" then
					SailIncrement.Value = "Slow Ahead"
					Sailing.Value = true
				elseif SailIncrement.Value == "Slow Ahead" then
					SailIncrement.Value = "Half Ahead"
				elseif SailIncrement.Value == "Half Ahead" then
					SailIncrement.Value = "Full Ahead"
				end
			elseif state == "SailsDown" then
				if SailIncrement.Value == "Slow Ahead" then
					SailIncrement.Value = "Dead Stop"
					Sailing.Value = false
				elseif SailIncrement.Value == "Half Ahead" then
					SailIncrement.Value = "Slow Ahead"
				elseif SailIncrement.Value == "Full Ahead" then
					SailIncrement.Value = "Half Ahead"
				end
			end
		end
	end)

	table.insert(Connections, SailController_connection)
end

if ShipMainPart:FindFirstChild("Control") then
	IsAngularControls = true
	Pitch = Values:WaitForChild("Pitch")
	Roll = Values:WaitForChild("Roll")
end

local Throttle = nil
local Engine = nil

if Ship_Model:FindFirstChild("FuelTanks") then
	IsEngineShip = true
	
	Throttle = Values:WaitForChild("Throttle")
	Engine = Values:WaitForChild("Engine")
	
	local thrusters_remote = Instance.new("RemoteEvent")
	thrusters_remote.Name = "DockThrusters"
	thrusters_remote.Parent = script.Parent
	
	local thrusters_connection = thrusters_remote.OnServerEvent:Connect(function(plr, state, params1)
		if seat.Occupant and players:GetPlayerFromCharacter(seat.Occupant.Parent) == plr then
			if state == "Side_thrusters" and UseSideThrusters == true then
				Ship.Values.SideThrusterForce.Value = params1

				if params1 > 0 then
					Ship.Ship.LeftFrontAttachment.Effect.Enabled = false
					Ship.Ship.RightFrontAttachment.Effect.Enabled = true
				elseif params1 < 0 then
					Ship.Ship.LeftFrontAttachment.Effect.Enabled = true
					Ship.Ship.RightFrontAttachment.Effect.Enabled = false
				else
					Ship.Ship.LeftFrontAttachment.Effect.Enabled = false
					Ship.Ship.RightFrontAttachment.Effect.Enabled = false
				end
			end 
		end
	end)

	table.insert(Connections, thrusters_connection)
end

local controller_remote = BridgeNet.ReferenceBridge("controller_"..(ShipIdentifier:gsub("-", "")))

--[[
local controller_remote = Instance.new("RemoteEvent")
controller_remote.Name = "Controller"
controller_remote.Parent = script.Parent

]]

local controller_connection = controller_remote:Connect(function(plr, state)
	if seat.Occupant and players:GetPlayerFromCharacter(seat.Occupant.Parent) == plr then
		if state[1] == "throttle_update" and IsEngineShip == true then
			if typeof(state[2]) == "number" then
				if state[2] <= 1 and state[2] >= -0.5 and Values:WaitForChild("CurrentFuel").Value > 0 and Sinking.Value == false then
					Throttle.Value = state[2]
				else
					Throttle.Value = 0
				end
			end
		elseif state[1] == "throttle_return" then
			return Values.Throttle.Value
		elseif state[1] == "rotation_update" then
			if typeof(state[2]) == "number" then
				if state[2] <= 1 and state[2] >= -1 and Sinking.Value == false then
					Rotation.Value = state[2]
				else
					Rotation.Value = 0
				end
			end
		elseif state[1] == "pitch_update" and IsAngularControls == true then
			if typeof(state[2]) == "number" then
				if state[2] <= 1 and state[2] >= -1 and Sinking.Value == false then
					Pitch.Value = state[2]
				else
					Pitch.Value = 0
				end
			end
		elseif state[1] == "roll_update" and IsAngularControls == true then
			if typeof(state[2]) == "number" then
				if state[2] <= 1 and state[2] >= -1 and Sinking.Value == false then
					Roll.Value = state[2]
				else
					Roll.Value = 0
				end
			end
		elseif state[1] == "Set_Engine" and IsEngineShip == true then
			if typeof(state[2]) == "boolean" then
				Engine.Value = state[2]
			end
		end
	end
end)

table.insert(Connections, controller_connection)

local com_remote = BridgeNet.ReferenceBridge("comcontrol_"..(ShipIdentifier:gsub("-", "")))

local com_connection = com_remote:Connect(function(plr, state)
	if seat.Occupant and players:GetPlayerFromCharacter(seat.Occupant.Parent) == plr then
		if state == "AIS_Off" then
			if ShipMainPart:FindFirstChild("RadarTag") then
				if ShipMainPart:FindFirstChild("RadarTag"):FindFirstChild("AIS") then
					ShipMainPart:FindFirstChild("RadarTag"):FindFirstChild("AIS").Value = false
				end
			end
		elseif state == "AIS_On" then
			if ShipMainPart:FindFirstChild("RadarTag") then
				if ShipMainPart:FindFirstChild("RadarTag"):FindFirstChild("AIS") then
					ShipMainPart:FindFirstChild("RadarTag"):FindFirstChild("AIS").Value = true
				end
			end
		end
	end
end)

table.insert(Connections, com_connection)

local ballast_remote = BridgeNet.ReferenceBridge("ballastcontrol_"..(ShipIdentifier:gsub("-", "")))

local ballast_connection = ballast_remote:Connect(function(plr, Table)
	
	if not plr:IsA("Player") then
		warn("Ship System - #Invalid Remote Player State")
		return nil;
	end
	
	if type(Table) == "table" then
		if #Table > 3 then
			plr:Kick("Ship System - #Invalid Remote Data Set")
			warn("Ship System - #Invalid Remote Data Set")
			return nil;
		end
	end

	if seat.Occupant and players:GetPlayerFromCharacter(seat.Occupant.Parent) == plr then
		
		if Table[1] and Table[2] then
			
			local FloatPoint = Table[2]
			local FloatPointCapacity = FloatPoint.TargetCapacity
			
			local FloatPointType = FloatPoint.Type.Value
			
			local MaxLimit = ClientSettings.BallastLimits[FloatPointType][2]
			local MinLimit = ClientSettings.BallastLimits[FloatPointType][1]
			
			local Increment = ClientSettings.BallastIncrement
			
			if Table[1] == "insert" then
				if Table[2] and Table[3] then
					FloatPointCapacity.Value = Table[3]/100
					if FloatPointCapacity.Value > MaxLimit then
						FloatPointCapacity.Value = MaxLimit
					elseif FloatPointCapacity.Value < MinLimit then
						FloatPointCapacity.Value = MinLimit
					end
				end
			elseif Table[1] == "add" then
				if Table[2] then
					FloatPointCapacity.Value = FloatPointCapacity.Value + Increment
					if FloatPointCapacity.Value > MaxLimit then
						FloatPointCapacity.Value = MaxLimit
					elseif FloatPointCapacity.Value < MinLimit then
						FloatPointCapacity.Value = MinLimit
					end
				end
			elseif Table[1] == "sub" then
				if Table[2] then
					FloatPointCapacity.Value = FloatPointCapacity.Value - Increment
					if FloatPointCapacity.Value > MaxLimit then
						FloatPointCapacity.Value = MaxLimit
					elseif FloatPointCapacity.Value < MinLimit then
						FloatPointCapacity.Value = MinLimit
					end
				end
			end			
		end

	end
end)

table.insert(Connections, ballast_connection)

local SystemSettings = require(game:GetService("ReplicatedStorage"):WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("SystemSettings"))

CaptainSeat.Changed:Connect(function(prop)
	if prop == "Occupant" and SystemSettings.ShipPhysicsHandledByClient == true then
		local humanoid = CaptainSeat.Occupant
		
		if humanoid and IsSailShip == false then
			local player = game:GetService("Players"):GetPlayerFromCharacter(humanoid.Parent)
			if player then
				CaptainSeat:SetNetworkOwner(player)
				Ship_Model.PrimaryPart:SetNetworkOwner(player)
			end
		elseif IsSailShip == true and Ship_Model:FindFirstChild("Sails"):WaitForChild('IsSailsMoving').Value == true then
			CaptainSeat:SetNetworkOwner(Ship_Model:FindFirstChild("Values"):WaitForChild('Owner').Value)
			Ship_Model.PrimaryPart:SetNetworkOwner(Ship_Model:FindFirstChild("Values"):WaitForChild('Owner').Value)
		elseif IsSailShip == true and Ship_Model:FindFirstChild("Sails"):WaitForChild('IsSailsMoving').Value == false then
			CaptainSeat:SetNetworkOwnershipAuto()
			Ship_Model.PrimaryPart:SetNetworkOwnershipAuto()
		else
			CaptainSeat:SetNetworkOwnershipAuto()
			Ship_Model.PrimaryPart:SetNetworkOwnershipAuto()
		end
	elseif prop == "Occupant" then

		local humanoid = CaptainSeat.Occupant
		
		if humanoid == nil and IsSailShip == true and Ship_Model:FindFirstChild("Sails"):WaitForChild('IsSailsMoving').Value == true then
			CaptainSeat:SetNetworkOwner(Ship_Model:FindFirstChild("Values"):WaitForChild('Owner').Value)
			Ship_Model.PrimaryPart:SetNetworkOwner(Ship_Model:FindFirstChild("Values"):WaitForChild('Owner').Value)
		elseif IsSailShip == true and Ship_Model:FindFirstChild("Sails"):WaitForChild('IsSailsMoving').Value == false then
			CaptainSeat:SetNetworkOwner(Ship_Model:FindFirstChild("Values"):WaitForChild('Owner').Value)
			Ship_Model.PrimaryPart:SetNetworkOwner(Ship_Model:FindFirstChild("Values"):WaitForChild('Owner').Value)
		end
	end
end)


local horn_connection = horn_remote.OnServerEvent:Connect(function(plr, state, params1)
	if seat.Occupant and players:GetPlayerFromCharacter(seat.Occupant.Parent) == plr then
		if state == "horn" then
			if hornplaying == false then
				hornplaying = true
				Ship.Ship.Horn_Sound:Play()
				task.wait(Ship.Ship.Horn_Sound.TimeLength+1)
				hornplaying = false
			end
		end 
	end
end)

table.insert(Connections, horn_connection)

local Sound_connection = Sound_Remote.OnServerEvent:Connect(function(plr, state)
	if seat.Occupant and players:GetPlayerFromCharacter(seat.Occupant.Parent) == plr then
		if state == "StartUp" then
			MainPart:WaitForChild("StartUpSound"):Play()
		elseif state == "ShutDown" then
			MainPart:WaitForChild("ShutDownSound"):Play()
		end 
	end
end)

table.insert(Connections, horn_connection)


local Animated_Parts = Ship:WaitForChild("AnimatedParts",2)
local anchor_folder = Animated_Parts:WaitForChild("Anchor",2) or nil

local anchor = nil
local anchorChain = nil
local anchorChain2 = nil

local Min_Length = 1.5
local Max_Length = 20
local Deploy_Time = 6

if anchor_folder then
	anchor = anchor_folder:WaitForChild("Anchor",2) or nil 
	anchorChain = anchor_folder:WaitForChild("AnchorChain",2) or nil
	anchorChain2 = anchor_folder:WaitForChild("AnchorChain2",2) or nil

	Min_Length = anchor_folder:WaitForChild("AnchorMinLength",2).Value or 1.5
	Max_Length = anchor_folder:WaitForChild("AnchorMaxLength",2).Value or 20
	Deploy_Time = anchor_folder:WaitForChild("AnchorDeployTime",2).Value or 6
end


local anchor_tween = TweenInfo.new(Deploy_Time, Enum.EasingStyle.Linear)

local Anchor_connection = anchor_remote.OnServerEvent:Connect(function(plr)
	if Anchored.Value == true and Anchor_Moving == false then
		if anchor_folder and anchorChain and Min_Length and Max_Length then
			tween_service:Create(anchorChain, anchor_tween, {Length = Min_Length}):Play()
			
			if anchor_folder and anchorChain2 and Max_Length then
				tween_service:Create(anchorChain2, anchor_tween, {Length = Min_Length}):Play()
			end
		end
		Anchored.Value = false

		coroutine.resume(coroutine.create(function()
			Anchor_Moving = true
			task.wait(Deploy_Time)
			Anchor_Moving = false
		end))
	elseif Anchored.Value == false and Anchor_Moving == false then
		if anchor_folder and anchorChain and Max_Length then
			tween_service:Create(anchorChain, anchor_tween, {Length = Max_Length}):Play()
			
			if anchor_folder and anchorChain2 and Max_Length then
				tween_service:Create(anchorChain2, anchor_tween, {Length = Max_Length}):Play()
			end
		end
		Anchored.Value = true

		coroutine.resume(coroutine.create(function()
			Anchor_Moving = true
			task.wait(Deploy_Time)
			Anchor_Moving = false
		end))
	end
end)

table.insert(Connections, Anchor_connection)

if IsEngineShip == true then
	local fuel_tanks = Ship:WaitForChild("FuelTanks")

	local maxfueltable = {}
	local tanktable = {}
	local max_fuel = 0
	local current_fuel = 0

	local function addObj(array, obj)
		table.insert(array,1,obj)
	end

	for i, child in ipairs(fuel_tanks:GetChildren()) do
		if child.Name == "Tank" and child:FindFirstChild("Fuel") then
			max_fuel = max_fuel + child:FindFirstChild("Fuel").MaxValue
			current_fuel = current_fuel + child:FindFirstChild("Fuel").Value
			
			addObj(maxfueltable, child:FindFirstChild("Fuel").MaxValue)
			addObj(tanktable, child)
		end
	end

	Values:WaitForChild("CurrentFuel").Value = current_fuel
	Values:WaitForChild("MaxFuel").Value = max_fuel

	local fuelusage = Settings:WaitForChild("MaxFuelConsumption").Value
	local fuelupdatetime = Settings:WaitForChild("FuelUpdateTime").Value

	Values:WaitForChild("CurrentFuel"):GetPropertyChangedSignal('Value'):Connect(function()
		if Values:WaitForChild("CurrentFuel").Value <= 0 then
			Throttle.Value = 0
		end
	end)

	coroutine.resume(coroutine.create(function()
		while Values.UseFuel.Value == true do
			task.wait(fuelupdatetime)
			local fueltankamount = #tanktable
			local fueluse = fuelusage * math.abs(Throttle.Value)

			Values.FuelConsumption.Value = math.abs(fueluse)

			local currentfuel = 0
			local newleftfuel = 0
			--print(fueltankamount)
			--	print(throttle)
			--	print(fueluse)


			local calibratedfueluse = fueluse / fueltankamount
			--print(calibratedfueluse)

			for i = 1, #maxfueltable do
				currentfuel = currentfuel + tonumber(maxfueltable[i])
			end
			--print(currentfuel)

			for i = 1, #tanktable do
				if tanktable[i].Fuel.Value == 0 or tanktable[i].UseFuelTank.Value == false then
					calibratedfueluse = calibratedfueluse + fueluse * fueltankamount
				else
					if tanktable[i].UseFuelTank.Value == true then
						tanktable[i].Fuel.Value = tanktable[i].Fuel.Value - calibratedfueluse
					end
				end
			end

			for i = 1, #tanktable do
				newleftfuel = newleftfuel + tanktable[i].Fuel.Value
				--print(tanktable[i].Fuel.Value)
			end
			local leftfuel = newleftfuel

			--print("leftfuel = "..leftfuel.." calibrated fuel use = "..calibratedfueluse)
			--	print(tanktable)
			--	print(maxfueltable)

			if leftfuel == 0 then
				-- stop engine
			end
			
			Values:WaitForChild("CurrentFuel").Value = leftfuel
			Values:WaitForChild("MaxFuel").Value = currentfuel
		end
	end))
end
--//=================================================================================================================//--

local WaterAssets = ReplicatedStorage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("WaterAssets")
local CollisionSplash = WaterAssets:WaitForChild("CollisionSplash")

local CollisionSounds = SystemSettings.ShipCollisionSounds or {
	["Metal"] = {
		"rbxassetid://9125402735",
		"rbxassetid://9113551779",
		"rbxassetid://9116892199",
		"rbxassetid://9116892391",
		"rbxassetid://9116891838",
		"rbxassetid://9116892160",
		"rbxassetid://9116891864",
		"rbxassetid://9116887596",
		"rbxassetid://9120381075",
	},
}


function CreateSoundPoint(Position)
	local SoundPart = Instance.new("Part")
	SoundPart.Anchored = true
	SoundPart.CanCollide = false
	SoundPart.Transparency = 1
	SoundPart.CanTouch = false
	SoundPart.CanQuery = false
	SoundPart.Size = Vector3.new(1,1,1)
	
	local Sound = Instance.new("Sound")
	Sound.SoundId = CollisionSounds.Metal[math.random(1,#CollisionSounds.Metal)] or "rbxassetid://9116892391"
	Sound.Volume = 1
	Sound.RollOffMaxDistance = 400
	Sound.RollOffMinDistance = 50
	
	local Particles = CollisionSplash:Clone()
	Particles.Parent = SoundPart
	
	SoundPart.Position = Position
	
	Sound.Parent = SoundPart
	SoundPart.Parent = workspace:WaitForChild("Boat_Workspace"):WaitForChild("Sounds")
	
	Particles:Emit(100)
	Sound:Play()
	Debris:AddItem(SoundPart,Sound.TimeLength)
end

local function normalToSurface(cf, normal)
	normal = cf:vectorToObjectSpace(normal)
	local x, y, z = normal.x, normal.y, normal.z
	if x ~= 0 and (y == 0 and z == 0) then
		return x > 0 and 'Front' or 'Rear'
	elseif y ~= 0 and (x == 0 and z == 0) then
		return y < 0 and 'Right' or 'Left'
	elseif z ~= 0 and (x == 0 and y == 0) then
		return z > 0 and 'Rear' or 'Front'
	end
	return 'Front'
end

local CollisionFolder = script.Parent:WaitForChild("Collisions")
local CustomCollision = false
local CollisionDebounce = false

if CollisionFolder:FindFirstChild("ShipCollision") then
	Collision_Part = CollisionFolder:WaitForChild("ShipCollision")
	
	local collision_connection = Collision_Part.Touched:Connect(function(Hit_Object)
		local HitSpeed = math.floor((MainPart.Velocity - Hit_Object.Velocity).Magnitude)

		if HitSpeed >= CollisionMinimumSpeed.Value and not game:GetService("Players"):GetPlayerFromCharacter(Hit_Object.Parent) and not (Hit_Object.CanCollide == false) and CollisionDebounce == false then
			CollisionDebounce = true
			local _, collision, normal = game:GetService("Workspace"):FindPartOnRayWithWhitelist(Ray.new(Collision_Part.Position, (Hit_Object.Position - Collision_Part.Position).unit * (Hit_Object.Position - Collision_Part.Position).magnitude), {Hit_Object})
			
			CreateSoundPoint(collision)
			
			local surface = normalToSurface(Hit_Object.CFrame, normal)

			local ShipCollisionDamageRatio = 1

			if TagService:HasTag(Hit_Object, "ShipMainPartTag") or TagService:HasTag(Hit_Object, "ShipBodyTag") or TagService:HasTag(Hit_Object, "ShipCollisionTag") or TagService:HasTag(Hit_Object, "ShipDestructible") then
				ShipCollisionDamageRatio = SystemSettings.ShipToShip_CollisionRatio
			end
			
			if Hit_Object:FindFirstChild("Destructible") or TagService:HasTag(Hit_Object, "ShipDestructible") or TagService:HasTag(Hit_Object, "WeaponBin") then
				
			else
				local Damage = (HitSpeed / CollisionDamageRatio.Value) * ShipCollisionDamageRatio

				Health_Table[surface].Value = Health_Table[surface].Value - Damage
			end
			--print("Ship Collision Damage: "..(HitSpeed / CollisionDamageRatio.Value))
		end

		task.wait(SystemSettings.ShipCollisionDebounceTime)
		CollisionDebounce = false
	end)

	table.insert(Connections, collision_connection)
else
	CustomCollision = true
end

if CustomCollision == true then
	local CustomDebounce = {
		["Front"] = false,
		["Left"] = false,
		["Right"] = false,
		["Rear"] = false,
	}
	
	for _, child in ipairs(CollisionFolder:GetChildren()) do
		if child:IsA("Part") and child.Name == "CustomCollision" and child:FindFirstChild("Type") then
			CustomCollision = true

			child.Transparency = 1
			child.CanCollide = false
			child.Color = Color3.fromRGB(0,255,0)
			child.CastShadow = false
			child.Massless = true
			
			local CollisionType = child.Type.Value
			
			local collision_connection = child.Touched:Connect(function(Hit_Object)
				local HitSpeed = math.floor((MainPart.Velocity - Hit_Object.Velocity).Magnitude)

				if HitSpeed >= CollisionMinimumSpeed.Value and not game:GetService("Players"):GetPlayerFromCharacter(Hit_Object.Parent) and not (Hit_Object.CanCollide == false) and CustomDebounce[CollisionType] == false then
					CustomDebounce[CollisionType] = true
					local _, collision, normal = game:GetService("Workspace"):FindPartOnRayWithWhitelist(Ray.new(child.Position, (Hit_Object.Position - child.Position).unit * (Hit_Object.Position - child.Position).magnitude), {Hit_Object})
					
					CreateSoundPoint(collision)
					
					local ShipCollisionDamageRatio = 1

					if TagService:HasTag(Hit_Object, "ShipMainPartTag") or TagService:HasTag(Hit_Object, "ShipBodyTag") or TagService:HasTag(Hit_Object, "ShipCollisionTag") or TagService:HasTag(Hit_Object, "ShipDestructible") then
						ShipCollisionDamageRatio = SystemSettings.ShipToShip_CollisionRatio
					end
					
					if Hit_Object:FindFirstChild("Destructible") or TagService:HasTag(Hit_Object, "ShipDestructible") or TagService:HasTag(Hit_Object, "WeaponBin") then
						
					else
						local Damage = (HitSpeed / CollisionDamageRatio.Value) * ShipCollisionDamageRatio

						Health_Table[CollisionType].Value = Health_Table[CollisionType].Value - Damage
					end
					
				end

				task.wait(SystemSettings.ShipCollisionDebounceTime)
				CustomDebounce[CollisionType] = false
			end)

			table.insert(Connections, collision_connection)
			
		else
			child:Destroy()
		end
	end
end

local ShipEngineMaxVolume = SoundValues:WaitForChild("ShipEngineMaxVolume",2).Value or 1.5
local BowWashMaxVolume = SoundValues:WaitForChild("BowWashMaxVolume",2).Value or 1
local SternWashMaxVolume = SoundValues:WaitForChild("SternWashMaxVolume",2).Value or 1

local ShipEngineMinPlaybackSpeed = SoundValues:WaitForChild("ShipEngineMinPlaybackSpeed",2).Value or 0.5 
local ShipEngineAdditionalPlaybackSpeed = SoundValues:WaitForChild("ShipEngineAdditionalPlaybackSpeed",2).Value or 1

local ShipEngineSound = MainPart:WaitForChild("EngineSound",2) or nil
local RotorFolder = Animated_Parts:WaitForChild("Rotor",2)
local RotorMotor

if RotorFolder then
	RotorMotor = RotorFolder:WaitForChild("Motor",2):WaitForChild("Propeller",2) or nil 
end

local RudderFolder = Animated_Parts:WaitForChild("Rudder",2) or nil
local RudderMotor

if RudderFolder then
	RudderMotor = RudderFolder:WaitForChild("Motor",2):WaitForChild("Rudder",2) or nil
end

local RotorPropellerMaxSpeed = RotorValues:WaitForChild("RotorPropellerMaxSpeed",2).Value or 20
local RudderMaxAngle = RudderValues:WaitForChild("RudderMaxAngle",2).Value or 60

local TrailWash = EffectPoints:WaitForChild("TrailWash",2) or nil

local BowWash = EffectPoints:WaitForChild("BowWash",2):WaitForChild("BowWash",2) or nil
local SternWash = EffectPoints:WaitForChild("RearWash",2):WaitForChild("SternWash",2) or nil

local Funnel = Body:WaitForChild("Engine_Funnel",2) or nil

local SmokeMinRate = FunnelSmokeValues:WaitForChild("SmokeMinRate",2).Value or 50
local SmokeAdditionalRate = FunnelSmokeValues:WaitForChild("SmokeAdditionalRate",2).Value or 100

if IsEngineShip == true then
	local throttle_connection = Throttle:GetPropertyChangedSignal('Value'):Connect(function()
		if ShipEngineSound and SoundValues and ShipEngineMinPlaybackSpeed and ShipEngineMaxVolume and ShipEngineAdditionalPlaybackSpeed then
			ShipEngineSound.PlaybackSpeed = ShipEngineMinPlaybackSpeed + ShipEngineAdditionalPlaybackSpeed * math.abs(Throttle.Value)
			ShipEngineSound.Volume = ShipEngineMaxVolume * math.abs(Throttle.Value)
		end
		
		if RotorMotor and RotorPropellerMaxSpeed then
			for _, child in ipairs(Animated_Parts:WaitForChild("Rotor",2):GetChildren()) do
				local hinge = child:FindFirstChild("Propeller") or nil

				if hinge and hinge:IsA("HingeConstraint") then
					hinge.AngularVelocity = RotorPropellerMaxSpeed * Throttle.Value
				end
			end
		end

		if BowWash and BowWashMaxVolume then
			local SailSpeed = 0
			
			if IsSailShip == true then
				SailSpeed = Values:WaitForChild("SailPower").Value
			end
			
			local VolumeIncrement = (math.abs(Throttle.Value) + math.abs(SailSpeed))
			
			if VolumeIncrement > 1 then
				VolumeIncrement = 1
			end
			
			BowWash.Volume = BowWashMaxVolume * VolumeIncrement
		end
		
		if TrailWash then
			TrailWash.Lifetime = 20 * math.abs(Throttle.Value)
		end
		
		if SternWash and SternWashMaxVolume then
			local SailSpeed = 0

			if IsSailShip == true then
				SailSpeed = Values:WaitForChild("SailPower").Value
			end
			
			local VolumeIncrement = (math.abs(Throttle.Value) + math.abs(SailSpeed))

			if VolumeIncrement > 1 then
				VolumeIncrement = 1
			end
			
			SternWash.Volume = SternWashMaxVolume * VolumeIncrement
		end

		if Funnel and SmokeMinRate and SmokeAdditionalRate then

			for _, child in ipairs(Funnel:GetChildren()) do
				local particle = child:FindFirstChild("Smoke") or nil

				local min_rate = Engine.Value == true and SmokeMinRate or 0

				if particle then
					particle.Rate = min_rate + SmokeAdditionalRate * math.abs(Throttle.Value)
				end
			end
		end
	end)
	table.insert(Connections, throttle_connection)
end

if IsSailShip == true then
	local sail_power_connection = Values:WaitForChild("SailPower"):GetPropertyChangedSignal('Value'):Connect(function()
		local SailSpeed = 0
		local CurrentThrottle = IsEngineShip == true and Values:WaitForChild("Throttle").Value or 0

		if IsSailShip == true then
			SailSpeed = Values:WaitForChild("SailPower").Value
		end
		
		local VolumeIncrement = (math.abs(CurrentThrottle) + math.abs(SailSpeed))

		if VolumeIncrement > 1 then
			VolumeIncrement = 1
		end
		
		if BowWash and BowWashMaxVolume then

			BowWash.Volume = BowWashMaxVolume * VolumeIncrement
		end
		
		if TrailWash then
			TrailWash.Lifetime = 20 * (math.abs(CurrentThrottle) + math.abs(SailSpeed))
		end
		
		if SternWash and SternWashMaxVolume then

			SternWash.Volume = SternWashMaxVolume * VolumeIncrement
		end
	end)
	table.insert(Connections, sail_power_connection)
end

local rotation_connection = Rotation:GetPropertyChangedSignal('Value'):Connect(function()
	if RudderFolder and RudderMotor and RudderMaxAngle then
		for _, child in ipairs(RudderFolder:GetChildren()) do
			if child.Name == "Motor" then
				local hinge = child:FindFirstChild("Rudder") or nil
				
				if hinge and hinge:IsA("HingeConstraint") then
					hinge.TargetAngle = RudderMaxAngle * Rotation.Value
				end
			end
		end
	end
end)

local Sinking_connection = Sinking:GetPropertyChangedSignal('Value'):Connect(function()
	if Sinking.Value == true then
		if IsEngineShip == true then
			Throttle.Value = 0
		end
		Rotation.Value = 0
	end
end)


table.insert(Connections, rotation_connection)

if IsEngineShip == true then
	local Engine_connection = Engine:GetPropertyChangedSignal('Value'):Connect(function()
		if Funnel and SmokeMinRate and SmokeAdditionalRate then

			for _, child in ipairs(Funnel:GetChildren()) do
				local particle = child:FindFirstChild("Smoke") or nil

				local min_rate = Engine.Value == true and SmokeMinRate or 0

				if particle then
					particle.Rate = min_rate + SmokeAdditionalRate * math.abs(Throttle.Value)
				end
			end
		end
	end)

	table.insert(Connections, Engine_connection)
end
