if script.RunContext.Value == 2 or script.RunContext.Value == 3 then
	warn("Crescendum Whitelist : Script RunContext Invalid")
	return nil
end

function setfenv()
	return "Invalid."
end
function getfenv()
	return "Invalid."
end
function rawequal()
	return "Invalid."
end
function rawget()
	return "Invalid."
end
function rawlen()
	return "Invalid."
end
function rawset()
	return "Invalid."
end
function setmetatable()
	return "Invalid."
end

if _VERSION ~= "Luau" then
	return nil
end


local Crescendum = game:GetService("ServerScriptService"):WaitForChild("Crescendum_Framework"):WaitForChild("Crescendum")
local CrescentService = game:GetService("ServerScriptService"):WaitForChild("Crescendum_Framework"):WaitForChild("Crescendum"):WaitForChild("Crescent")
local CrescentAPI = require(CrescentService) or nil

local Connections = {}
local ShipSystemVersion = ("2.0")
local ShipSailVersion = ("2.0c")
local HTTP = game:GetService("HttpService")

local function StopScriptFunction(kickreason)
	for index, value in pairs(Connections) do 
		value:Disconnect()
	end
	script:Destroy()
	error("Ship System: Failed Check")
end

local sc_results = {
	["result_1"] = 1,
	["result_2"] = 2,
	["result_3"] = 3,
	["result_4"] = 4,
}

local sc_old = {
	["result_1"] = 1,
	["result_2"] = 2,
	["result_3"] = 3,
	["result_4"] = 4,
}

if CrescentService and CrescentAPI  then
	CrescentAPI.SetCallback("ValidateShipSail", function(result)
		local sc_new = {
			result_4 = HTTP:GenerateGUID(),
			result_3 = HTTP:GenerateGUID(),
			result_2 = HTTP:GenerateGUID(),
			result_1 = result,
		}

		sc_results = sc_new
		return {result, script, ShipSailVersion}
	end)
end

local function CheckSCKeys()
	if
		sc_results.result_4 == sc_old.result_4 and
		sc_results.result_3 == sc_old.result_3 and
		sc_results.result_2 == sc_old.result_2 and
		sc_results.result_1 == sc_old.result_1 and sc_results.result_1 == nil or
		_G.ICRESSS == false or _G.ICRESSS == nil
	then
		StopScriptFunction()
	end
end

repeat task.wait() until (_G.CRES_SC ~= nil and _G.ICRESSS ~= nil)

coroutine.resume(coroutine.create(function()
	while true do
		task.wait(30)
		_G.CRES_SC("ShipSail") 
		task.wait(5)
		CheckSCKeys()
		sc_old = sc_results
	end
end))

local ScriptService = game:GetService("ServerScriptService")

if not game:GetService("ServerScriptService"):FindFirstChild("Crescendum_Framework"):FindFirstChild("Crescendum") or game:GetService("ServerScriptService"):FindFirstChild("Crescendum_Framework"):FindFirstChild("Crescendum").Disabled == true then
	StopScriptFunction()
end

ScriptService:WaitForChild("Crescendum_Ship_System")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Client")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Server")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Client"):WaitForChild("Client")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Server"):WaitForChild("Float")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Server"):WaitForChild("SailSystem")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Server"):WaitForChild("ShipController")

local Replicated_Storage = game:GetService("ReplicatedStorage")
Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("GerstnerWaves")
Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("SystemSettings")
Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("Ships")
Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("WaterAssets")
Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("Chunks")
Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("RemoteHiearchy")
Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("ShipSpawn")

local rs = game:GetService("RunService")

if game.CreatorId ~= 25583235 then
	if rs:IsStudio() == true then
		error("Ship System: Running in Studio")
	end
end

local folder = script.Parent
local ShipIdentifier

if folder:WaitForChild("Identifier") then
	if string.len(folder.Identifier.Value) == 36 then
		ShipIdentifier = folder.Identifier.Value
	else
		script:Destroy()
	end
end

local FrameworkFolder = ScriptService:WaitForChild("Crescendum_Ship_System")
local ReadyValueSSF = FrameworkFolder:WaitForChild("SSF_Ready")
local Framework = FrameworkFolder:WaitForChild("ShipSystemFramework")
local Callback = Framework:WaitForChild("Callback")

local VersionValue = Framework:WaitForChild("Version")

if VersionValue.Value == ShipSystemVersion then
else
	error("Ship System: Incompatible Version")
end

local ENC_Key1 = 7553624
local ENC_Key2 = 5241

local inv256
function EncodeString(str)
	if not inv256 then
		inv256 = {}
		for M = 0, 127 do
			local inv = -1
			repeat inv = inv + 2
			until inv * (2*M + 1) % 256 == 1
			inv256[M] = inv
		end
	end
	local K, F = ENC_Key1, 16384 + ENC_Key2
	return (str:gsub('.',
		function(m)
			local L = K % 274877906944  -- 2^38
			local H = (K - L) / 274877906944
			local M = H % 128
			m = m:byte()
			local c = (m * inv256[M] - (H - M) / 128) % 256
			K = L * F + H + c + m
			return ('%02x'):format(c)
		end
		))
end

function DecodeString(str)
	local K, F = ENC_Key1, 16384 + ENC_Key2
	return (str:gsub('%x%x',
		function(c)
			local L = K % 274877906944  -- 2^38
			local H = (K - L) / 274877906944
			local M = H % 128
			c = tonumber(c, 16)
			local m = (c + (H - M) / 128) * (2*M + 1) % 256
			K = L * F + H + c + m
			return string.char(m)
		end
		))
end

local function Invoke_Callback(ShipModel, IdentifierCode)
	local SentEncodedString = EncodeString(IdentifierCode)

	local Callback_Return = Callback:Invoke(script, ShipModel, SentEncodedString)

	if Callback_Return then
		local UID = Callback_Return.UID
		local EncodedString = Callback_Return.String

		if UID then
			if DecodeString(EncodedString) == IdentifierCode then
				return true
			end
		end
	end
	ShipModel:Destroy()
end

local Ship_Model = script.Parent.Parent
local IdentityFolder = Framework:WaitForChild("Identity")

local function CheckIdentity()
	if IdentityFolder[ShipIdentifier] then
		if DecodeString(IdentityFolder[ShipIdentifier].Value) == ShipIdentifier then
			return true;
		end
	end
	Ship_Model:Destroy()
	return nil;
end

coroutine.resume(coroutine.create(function()
	while true do
		task.wait(10)
		if CheckIdentity() then
		else
			Ship_Model:Destroy()
		end
		if Invoke_Callback(Ship_Model,ShipIdentifier) then
		else
			Ship_Model:Destroy()
		end
	end
end))

local folder = script.Parent

if folder:WaitForChild("Identifier") then
	if string.len(folder.Identifier.Value) == 36 then
	else
		script:Destroy()
	end
end

local rs = game:GetService("RunService")
local ts = game:GetService("TweenService")
local ANG = CFrame.Angles


local FoundWeatherSystem = false

if game:GetService("ServerScriptService"):FindFirstChild("Crescendum_Weather_System") then
	FoundWeatherSystem = true
end

local Wind_Direction = game:GetService("ServerScriptService"):WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Statistics"):WaitForChild("WindDirection")

if FoundWeatherSystem == true then
	Wind_Direction = game:GetService("ServerScriptService"):WaitForChild("Crescendum_Weather_System"):WaitForChild("WeatherStats"):WaitForChild("WindAngle")
end

local ShipModel = script.Parent.Parent
local ShipPart = ShipModel:WaitForChild("Ship")
local CaptainSeat = ShipModel:WaitForChild("Captain")
local SailModel = ShipModel:WaitForChild("Sails")
local Systematics = ShipModel:WaitForChild("Systematics")

local Welds = ShipModel:WaitForChild("Welds")
local AWelds = Welds:WaitForChild("AnimatedWelds")

local shipSettings = ShipModel:WaitForChild("Settings")
local shipValues = ShipModel:WaitForChild("Values")

local sailSettings = shipSettings:WaitForChild("Sails")

local SailDirectionTween = sailSettings:WaitForChild("SailDirectionTween",2).Value or 0.5

local SailMovingValue = Instance.new("BoolValue")
SailMovingValue.Name = 'IsSailsMoving'
SailMovingValue.Value = false
SailMovingValue.Parent = SailModel

local OwnerValue = shipValues:WaitForChild("Owner")

repeat
	task.wait()

until OwnerValue.Value ~= nil

function Angle(vectorA, vectorB)
	return math.acos(vectorA.Unit:Dot(vectorB.Unit))
end

function SetPhysicsOwner(State)

	if CaptainSeat.Occupant == nil then
		if State == true then
			if ShipModel.PrimaryPart.Anchored ~= true then
				CaptainSeat:SetNetworkOwner(OwnerValue.Value)
				ShipModel.PrimaryPart:SetNetworkOwner(OwnerValue.Value)
			end
		else
			CaptainSeat:SetNetworkOwnershipAuto()
			ShipModel.PrimaryPart:SetNetworkOwnershipAuto()
		end
	end
end

--[[
ShipModel.PrimaryPart:GetPropertyChangedSignal('Anchored'):Connect(function()
	if ShipModel.PrimaryPart.Anchored == true then
		SetPhysicsOwner(false)
	elseif ShipModel.PrimaryPart.Anchored == false then
		SetPhysicsOwner(true)
	end
end)
]]
--SetPhysicsOwner(true)

function SetMovingValue(Time)
	coroutine.resume(coroutine.create(function()
		SailMovingValue.Value = true
		SetPhysicsOwner(true)
		task.wait(Time)
		SailMovingValue.Value = false
		SetPhysicsOwner(false)
	end))
end

local function getRotationBetween(u, v, axis)
	local axis = axis or Vector3.new(0,1,0)
	local dot, uxv = u:Dot(v), u:Cross(v)
	if (dot < -0.99999) then return CFrame.fromAxisAngle(axis, math.pi) end
	return CFrame.new(0, 0, 0, uxv.x, uxv.y, uxv.z, 1 + dot)
end

local function toDegrees(...)
	local degs = {...}
	for i ,rad in pairs(degs) do
		degs[i] = math.deg(rad)
	end
	return table.unpack(degs)
end

local SailSettings = require(SailModel:WaitForChild("SailSettings")) or {

	SailSpeedModifiers = {
		["Dead Stop"] = 0,
		["Slow Ahead"] = 0.2,
		["Half Ahead"] = 0.5,
		["Full Ahead"] = 1,
	},
	
	SailTotalDeployTime = 6,
}

local Sail_Sizes = {}
local SailsParts = {}

for _, Sail_Part in ipairs(SailModel:GetDescendants()) do
	if string.find(Sail_Part.Name, "SailCloth") and Sail_Part:IsA("BasePart") then
		SailsParts[Sail_Part] = Sail_Part
		Sail_Sizes[Sail_Part] = {
			["Scale"] = Sail_Part.Size,
			["Position"] = Sail_Part.Position,
			["WeldC0"] = Sail_Part.Motor6DWeld.C0,
		}
	end
end

print(Sail_Sizes)

--============================================================================================================

local SailDirection_TweenInfo = TweenInfo.new(SailDirectionTween,Enum.EasingStyle.Linear,Enum.EasingDirection.InOut)

--============================================================================================================

local SailPowerIncrement = shipValues:WaitForChild("SailPowerIncrement")
local Sailing = shipValues:WaitForChild("Sailing")

function UpdateSails()
	if SailPowerIncrement.Value == "Dead Stop" then
		for Sail_Part,_ in next, SailsParts do
			if string.find(Sail_Part.Name, "SailCloth") and Sail_Part:IsA("BasePart") then
				for key, val in next, Sail_Sizes do
					if Sail_Part == key then
						local SailNumber = tonumber(string.split(Sail_Part.Name, "SailCloth_")[2])
						
						local SailSize_TweenInfo = TweenInfo.new(Sail_Part.Parent.DeployTime.Value,Enum.EasingStyle.Linear,Enum.EasingDirection.InOut)
						local SailCframe_TweenInfo = TweenInfo.new(Sail_Part.Parent.DeployTime.Value*1.35,Enum.EasingStyle.Linear,Enum.EasingDirection.InOut)


						ts:Create(Sail_Part.Parent.PowerRatio, SailSize_TweenInfo, {
							Value = 0,
						}):Play()
						
						if Sail_Part.Parent.Deployed.Value == true then
							Sail_Part.Parent.Deployed.Value = false
							if Sail_Part.Parent:FindFirstChild("SailFurled_"..SailNumber) then
								local Furled = Sail_Part.Parent:FindFirstChild("SailFurled_"..SailNumber)

								if Furled:FindFirstChild("Weld") then
									local Weld = Furled:FindFirstChild("Weld")

									if Sail_Part:FindFirstChild("Motor6DWeld") then
										local SailPartWeld = Sail_Part:FindFirstChild("Motor6DWeld")

										ts:Create(SailPartWeld, SailCframe_TweenInfo, {
											C0 = Weld.C0 + Sail_Part.SailOffset.Value,
										}):Play()

										ts:Create(Sail_Part, SailSize_TweenInfo, {
											Size = Furled.Size,
										}):Play()
									end
								end
							end
						end
					end
				end
			end
		end
		--SetMovingValue(SailSettings.SailTotalDeployTime)
	elseif SailPowerIncrement.Value ~= "Dead Stop" then	
		for Sail_Part,_ in next, SailsParts do
			if string.find(Sail_Part.Name, "SailCloth") and Sail_Part:IsA("BasePart") then
				for key, val in next, Sail_Sizes do
					if Sail_Part == key then
						local SailNumber = tonumber(string.split(Sail_Part.Name, "SailCloth_")[2])
						local SailPowerSet = tonumber(SailSettings.SailSpeedModifiers[SailPowerIncrement.Value])
						
						local SailSize_TweenInfo = TweenInfo.new(Sail_Part.Parent.DeployTime.Value,Enum.EasingStyle.Linear,Enum.EasingDirection.InOut)
						local SailCframe_TweenInfo = TweenInfo.new(Sail_Part.Parent.DeployTime.Value,Enum.EasingStyle.Linear,Enum.EasingDirection.InOut)
						
						print(SailPowerSet)
						
						ts:Create(Sail_Part.Parent.PowerRatio, SailSize_TweenInfo, {
							Value = Sail_Part.Parent.PowerRatio.MaxPowerRatio.Value * SailPowerSet,
						}):Play()
						
						if Sail_Part.Parent.Deployed.Value == false then
							Sail_Part.Parent.Deployed.Value = true
							if Sail_Part.Parent:FindFirstChild("SailFurled_"..SailNumber) then
								local Furled = Sail_Part.Parent:FindFirstChild("SailFurled_"..SailNumber)

								if Furled:FindFirstChild("Weld") then
									local Weld = Furled:FindFirstChild("Weld")

									if Sail_Part:FindFirstChild("Motor6DWeld") then
										local SailPartWeld = Sail_Part:FindFirstChild("Motor6DWeld")

										ts:Create(SailPartWeld, SailCframe_TweenInfo, {
											C0 = val.WeldC0,
										}):Play()

										ts:Create(Sail_Part, SailSize_TweenInfo, {
											Size = Vector3.new(val.Scale.X,val.Scale.Y,val.Scale.Z),
										}):Play()
									end
								end
							end
						end
					end
				end
			end
		end
		--SetMovingValue(SailSettings.SailTotalDeployTime)
	end
end

SailPowerIncrement:GetPropertyChangedSignal('Value'):Connect(function()
	UpdateSails()
end)

UpdateSails()

rs.Heartbeat:Connect(function()
	local totalSailPower = 0
	local x = 0
	
	local POWER_SQUARE = 1
	local POWER_FAA = 1
	local POWER_STAYSAILS = 1
	local POWER_LATEEN = 1
	
	local LeanAngle = 0
	
	local SailAngle = {}
	
	local aww
	local afw
	local Heading
	local StayAngle
	local LatAngle
	local TriAngle
	local SquareAngle
	
	local WW = ShipPart.Position+Vector3.new(20,0,0)
	local V3 = ShipPart.CFrame:pointToObjectSpace(WW)
	local xX = V3.x*-1
	local yY = V3.z
	local SC1 = math.deg(math.atan(math.abs(xX)/math.abs(yY)))
	
	x = x+math.random(-1,5)/8
	if x > 2*math.pi then x = 0
	elseif x < 0 then x = 2*math.pi end
	
	if xX < 0 and yY < 0 then
		SC1 = 360-SC1
	elseif xX < 0 and yY > 0 then
		SC1 = 180+SC1
	elseif xX > 0 and yY > 0 then
		SC1 = 180 - SC1
	elseif xX == 0 and yY > 0 then
		SC1 = 180
	elseif xX < 0 and yY == 0 then
		SC1 = 270
	end
	
	Heading = SC1
	
	--[[
	local WindVector = Wind_Direction.Value
	local Angle = math.deg(math.atan2(WindVector.X,WindVector.Z))

	local v1 = Vector3.new(WindVector.X,0,0)
	local v2 = Vector3.new(0,0,WindVector.Z)
	
	local result = getRotationBetween(v1,v2)
	local windDirection = toDegrees(result:ToOrientation())
	]]
	--	local Angle = math.deg(math.atan2(WindVector.Z, WindVector.X))
	--print(Angle)
	
	local windDirection = (-Heading+(Wind_Direction.Value))
	
	--[[
	if ShipPart.Position.X == 0 and ShipPart.Position.Z < 0 then
		windDirection = 0
	elseif ShipPart.Position.X > 0 and ShipPart.Position.Z == 0 then
		windDirection = 90
	elseif ShipPart.Position.X > 0 then
		windDirection = 90-windDirection
	elseif ShipPart.Position.X == 0 and ShipPart.Position.Z > 0 then
		windDirection = 180
	elseif ShipPart.Position.X < 0 and ShipPart.Position.Z == 0 then
		windDirection = 270
	elseif ShipPart.Position.X < 0 then
		windDirection = 270-windDirection
	end
	windDirection = windDirection-180
	]]
	
	--Ship_Model.Body.WindDirection.CFrame = CFrame.new(Ship_Model.Body.WindDirection.Position) * CFrame.Angles(0,windDirection,0)
	
	afw = windDirection-Heading --workspace.Wind.Value-Heading
	if afw > 180 then afw = -360+afw end
	if afw < -180 then afw = 360+afw end
	aww =  windDirection-180-Heading --workspace.Wind.Value-180-Heading
	if aww < -180 then aww = 360+aww end
	if aww > 180 then aww = -360+aww end

	if afw > 30 then
		SailAngle.Stay = 30
	elseif afw < -30 then
		SailAngle.Stay = -30
	else
		SailAngle.Stay = afw
	end

	if afw > 0 then
		LeanAngle = 90-math.abs(90-afw)
	else
		LeanAngle = -90-math.abs(-90-afw)
	end
	
	if aww > 60 then
		SailAngle.Lat = 60
		SailAngle.Square = 20
	elseif aww > 20 then
		SailAngle.Lat = aww
		SailAngle.Square = 20
	elseif aww < -60 then
		SailAngle.Lat = -60
		SailAngle.Square = -20
	elseif aww < -20 then
		SailAngle.Lat = aww
		SailAngle.Square = -20
	else
		SailAngle.Lat = aww
		SailAngle.Square = aww
	end
	--print(afw, "  -  ", aww)
	local SailPower = {}

	SailPower.Square = ((160-math.abs(aww-SailAngle.Square))/160)^2*POWER_SQUARE
	SailPower.Lat = (math.abs(120-math.abs(aww-SailAngle.Lat))/120)^0.7*POWER_LATEEN
	SailPower.FAA = (1-math.abs(150-math.abs(afw))/150)^0.7*POWER_FAA
	
	local ssp = 90-math.abs(aww-SailAngle.Stay)

	if ssp > 0 then
		SailPower.Stay = (90-math.abs(ssp))/90*POWER_STAYSAILS
	else
		SailPower.Stay = ((90-math.abs(ssp))/90)^2*POWER_STAYSAILS
	end
	
	
	if Sailing.Value then
		POWER_FAA = 1
		POWER_LATEEN = 1
		POWER_SQUARE = 1
		POWER_STAYSAILS = 1
	else
		SailAngle.Lat = 0
		LeanAngle = 0
		SailAngle.Stay = 0
		SailAngle.Square = 0
		TriAngle = 0
		
		POWER_FAA = 0
		POWER_LATEEN = 0
		POWER_SQUARE = 0
		POWER_STAYSAILS = 0
	end
	
	--print(Heading)
	--print(windDirection)
	
	for _, SailSection in ipairs(SailModel:GetChildren()) do
		if string.find(SailSection.Name, "Sail_") then
			local SailType = SailSection.SailType.Value or "Square"
			
			local WeldObject = SailSection.Sail_Point.TurnAngle

			local angle = CFrame.Angles(0,math.rad(SailAngle[SailType]),0) --ANG(0, math.deg(math.atan2(Wind_Direction.Value.X,Wind_Direction.Value.Y)), 0)
			ts:Create(WeldObject, SailDirection_TweenInfo, {C1 = angle}):Play()
		elseif string.find(SailSection.Name, "Flag") then
			local WeldObject = SailSection.Sail_Point.TurnAngle
			local Flagangle = CFrame.Angles(0,(math.rad(windDirection))+math.cos(x)/4,0)

			local angle = Flagangle
			WeldObject.C1 = angle
		end
	end
	
	--for _, Sail in ipairs(AWelds:GetChildren()) do
	--	if string.find(Sail.Name, "SailCloth") then
	--		local angle = CFrame.Angles(0,math.rad(SailAngle.Square),0) --ANG(0, math.deg(math.atan2(Wind_Direction.Value.X,Wind_Direction.Value.Y)), 0)
	--		ts:Create(Sail, SailDirection_TweenInfo, {C0 = angle}):Play()
	--	end
	--end
	
	for _, SailSection in ipairs(SailModel:GetChildren()) do
		if string.find(SailSection.Name, "Sail_") then
			local SailType = SailSection.SailType.Value or "Square"
			local SailSize_TweenInfo = TweenInfo.new(SailSection.DeployTime.Value,Enum.EasingStyle.Linear,Enum.EasingDirection.InOut)

			if SailSection.Deployed.Value then
				ts:Create(SailSection.Power, SailSize_TweenInfo, {
					Value = (SailPower[SailType] * tonumber(SailSection.PowerRatio.Value)) >= tonumber(SailSection.Power.MinPower.Value) and SailPower[SailType] * tonumber(SailSection.PowerRatio.Value) or tonumber(SailSection.Power.MinPower.Value),
				}):Play()

				totalSailPower = totalSailPower + tonumber(SailSection.Power.Value)
			else
				ts:Create(SailSection.Power, SailSize_TweenInfo, {
					Value = SailPower[SailType] * SailSection.PowerRatio.Value,
				}):Play()

				totalSailPower = totalSailPower + tonumber(SailSection.Power.Value)
			end
		end
	end
	
	if totalSailPower ~= totalSailPower then
		totalSailPower = 0
	end
	
	shipValues:WaitForChild("SailPower").Value = tonumber(totalSailPower) or 0
	
	--print("sail power :" .. totalSailPower)
end)
