if script.RunContext.Value == 2 or script.RunContext.Value == 3 then
	warn("Crescendum Whitelist : Script RunContext Invalid")
	return nil
end

function setfenv()
	return "Invalid."
end
function getfenv()
	return "Invalid."
end
function rawequal()
	return "Invalid."
end
function rawget()
	return "Invalid."
end
function rawlen()
	return "Invalid."
end
function rawset()
	return "Invalid."
end
function setmetatable()
	return "Invalid."
end

if _VERSION ~= "Luau" then
	return nil
end

local Crescendum = game:GetService("ServerScriptService"):WaitForChild("Crescendum_Framework"):WaitForChild("Crescendum")
local CrescentService = game:GetService("ServerScriptService"):WaitForChild("Crescendum_Framework"):WaitForChild("Crescendum"):WaitForChild("Crescent")
local CrescentAPI = require(CrescentService) or nil

local Connections = {}
local ShipSystemVersion = ("2.0")
local ShipFloaterVersion = ("2.0b")
local HTTP = game:GetService("HttpService")

local function StopScriptFunction(kickreason)
	for index, value in pairs(Connections) do 
		value:Disconnect()
	end
	script:Destroy()
	error("Ship System: Failed Check")
end

local sc_results = {
	["result_1"] = 1,
	["result_2"] = 2,
	["result_3"] = 3,
	["result_4"] = 4,
}

local sc_old = {
	["result_1"] = 1,
	["result_2"] = 2,
	["result_3"] = 3,
	["result_4"] = 4,
}

if CrescentService and CrescentAPI  then
	CrescentAPI.SetCallback("ValidateShipFloater", function(result)
		local sc_new = {
			result_4 = HTTP:GenerateGUID(),
			result_3 = HTTP:GenerateGUID(),
			result_2 = HTTP:GenerateGUID(),
			result_1 = result,
		}

		sc_results = sc_new
		return {result, script, ShipFloaterVersion}
	end)
end

local function CheckSCKeys()
	if
		sc_results.result_4 == sc_old.result_4 and
		sc_results.result_3 == sc_old.result_3 and
		sc_results.result_2 == sc_old.result_2 and
		sc_results.result_1 == sc_old.result_1 and sc_results.result_1 == nil or
		_G.ICRESSS == false or _G.ICRESSS == nil
	then
		StopScriptFunction()
	end
end

repeat task.wait() until (_G.CRES_SC ~= nil and _G.ICRESSS ~= nil)

coroutine.resume(coroutine.create(function()
	while true do
		task.wait(30)
		_G.CRES_SC("ShipFloater") 
		task.wait(5)
		CheckSCKeys()
		sc_old = sc_results
	end
end))

local ScriptService = game:GetService("ServerScriptService")

if not game:GetService("ServerScriptService"):FindFirstChild("Crescendum_Framework"):FindFirstChild("Crescendum") or game:GetService("ServerScriptService"):FindFirstChild("Crescendum_Framework"):FindFirstChild("Crescendum").Disabled == true then
	StopScriptFunction()
end

ScriptService:WaitForChild("Crescendum_Ship_System")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Client")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Server")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Client"):WaitForChild("Client")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Server"):WaitForChild("Float")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Server"):WaitForChild("SailSystem")
ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):WaitForChild("Server"):WaitForChild("ShipController")

local Replicated_Storage = game:GetService("ReplicatedStorage")
Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("GerstnerWaves")
Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("SystemSettings")
Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("Ships")
Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("WaterAssets")
Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("Chunks")
Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("RemoteHiearchy")
Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("ShipSpawn")

local rs = game:GetService("RunService")

if game.CreatorId ~= 25583235 then
	if rs:IsStudio() == true then
		error("Ship System: Running in Studio")
	end
end

local folder = script.Parent
local ShipIdentifier

if folder:WaitForChild("Identifier") then
	if string.len(folder.Identifier.Value) == 36 then
		ShipIdentifier = folder.Identifier.Value
	else
		script:Destroy()
	end
end

local FrameworkFolder = ScriptService:WaitForChild("Crescendum_Ship_System")
local ReadyValueSSF = FrameworkFolder:WaitForChild("SSF_Ready")
local Framework = FrameworkFolder:WaitForChild("ShipSystemFramework")
local Callback = Framework:WaitForChild("Callback")

local VersionValue = Framework:WaitForChild("Version")

if VersionValue.Value == ShipSystemVersion then
else
	error("Ship System: Incompatible Version")
end

local ENC_Key1 = 7553624
local ENC_Key2 = 5241

local inv256
function EncodeString(str)
	if not inv256 then
		inv256 = {}
		for M = 0, 127 do
			local inv = -1
			repeat inv = inv + 2
			until inv * (2*M + 1) % 256 == 1
			inv256[M] = inv
		end
	end
	local K, F = ENC_Key1, 16384 + ENC_Key2
	return (str:gsub('.',
		function(m)
			local L = K % 274877906944  -- 2^38
			local H = (K - L) / 274877906944
			local M = H % 128
			m = m:byte()
			local c = (m * inv256[M] - (H - M) / 128) % 256
			K = L * F + H + c + m
			return ('%02x'):format(c)
		end
		))
end

function DecodeString(str)
	local K, F = ENC_Key1, 16384 + ENC_Key2
	return (str:gsub('%x%x',
		function(c)
			local L = K % 274877906944  -- 2^38
			local H = (K - L) / 274877906944
			local M = H % 128
			c = tonumber(c, 16)
			local m = (c + (H - M) / 128) * (2*M + 1) % 256
			K = L * F + H + c + m
			return string.char(m)
		end
		))
end

local function Invoke_Callback(ShipModel, IdentifierCode)
	local SentEncodedString = EncodeString(IdentifierCode)

	local Callback_Return = Callback:Invoke(script, ShipModel, SentEncodedString)

	if Callback_Return then
		local UID = Callback_Return.UID
		local EncodedString = Callback_Return.String

		if UID then
			if DecodeString(EncodedString) == IdentifierCode then
				return true
			end
		end
	end
	ShipModel:Destroy()
end

local Ship_Model = script.Parent.Parent
local IdentityFolder = Framework:WaitForChild("Identity")

local function CheckIdentity()
	if IdentityFolder[ShipIdentifier] then
		if DecodeString(IdentityFolder[ShipIdentifier].Value) == ShipIdentifier then
			return true;
		end
	end
	Ship_Model:Destroy()
	return nil;
end

coroutine.resume(coroutine.create(function()
	while true do
		task.wait(10)
		if CheckIdentity() then
		else
			Ship_Model:Destroy()
		end
		if Invoke_Callback(Ship_Model,ShipIdentifier) then
		else
			Ship_Model:Destroy()
		end
	end
end))

local Debris = game:GetService("Debris")
local Waves = require(Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("GerstnerWaves"))
local RoPID = require(Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("ThirdPartyDependencies"):WaitForChild("RoPID"))
local SystemSettings = require(Replicated_Storage:WaitForChild("Ship_System_Replicated_Storage"):WaitForChild("SystemSettings"))
local ClientSettings = require(Ship_Model:WaitForChild("Captain"):WaitForChild("ClientSettings"))

local NeedAccelerationToChangeShipYaw = ClientSettings.NeedAccelerationToChangeShipYaw and ClientSettings.NeedAccelerationToChangeShipYaw or false

local UseWeatherPlugin = SystemSettings.WeatherSystemCompatibility
local Weather_Values = nil
local WeatherPhysicsPlugin = {
	["WindDrift"] = Vector3.new(0,0,0)
}

if UseWeatherPlugin and Replicated_Storage:FindFirstChild("Weather_Replicated_Storage") then
	Weather_Values = Replicated_Storage:FindFirstChild("Weather_Replicated_Storage"):WaitForChild("ReplicatedValues")
end

local folder = script.Parent

if folder:WaitForChild("Identifier") then
	if string.len(folder.Identifier.Value) == 36 then
	else
		script:Destroy()
	end
end

local effects = script.Parent.Parent:WaitForChild("EffectPoints")
local ship = script.Parent.Parent

local shipSettings = script.Parent.Parent:WaitForChild("Settings")

local particleSettings = shipSettings:WaitForChild("Particles")

local shipValues = script.Parent.Parent:WaitForChild("Values")


local SinkingValue = shipValues:WaitForChild("Sinking")
local HealthValues = shipValues:WaitForChild("HealthValues")

local Health_Table = {
	["Front"] = HealthValues:WaitForChild("FrontHealth"),
	["Rear"] = HealthValues:WaitForChild("RearHealth"),
	["Right"] = HealthValues:WaitForChild("RightHealth"),
	["Left"] = HealthValues:WaitForChild("LeftHealth"),
}

local Float_Types = {"Front","Rear","Right","Left"}
local Float_Side_Types = {"Right","Left"}

local FloatDamageConnection = {
	["Front"] = {"Right","Left","Left+Right"},
	["Left"] = {"Front","Rear","Right"},
	["Right"] = {"Front","Rear","Left"},
	["Rear"] = {"Right","Left","Left+Right"},
}

local IsASailShip = false
local IsAngularControls = false
local IsAEngineShip = false

local totalMass = shipSettings.totalMass.Value or 400000
local depthBeforeSubmerged = shipSettings.depthBeforeSubmerged.Value or 25
local displacementAmount = shipSettings.displacementAmount.Value or 0.1
local waterDrag = shipSettings.waterDrag.Value or 200
local waterAngularDrag = shipSettings.waterAngularDrag.Value or 1.25
local WaveHeightDisplacement = shipSettings.WaveHeightDisplacement.Value or 6
local SinkingHealthDrop = shipSettings.SinkingHealthDrop.Value or 0.025
local ShipWakeHeightDisplacement = shipSettings.ShipWakeHeightDisplacement.Value or -6
local AnchoringForceReduction = shipSettings.AnchoringForceReduction.Value or 2
local TurnMaxTorque = shipSettings.TurnMaxTorque.Value or 85000000
local FloatPosition = shipSettings.FloatPosition.Value or 20
local EngineForceDivider = shipSettings.EngineForceDivider.Value or 200000
local SideThrusterRatio = shipSettings.SideThrusterRatio.Value or 1.25
local VelocityRatio = shipSettings.VelocityRatio.Value or 100
local SpeedRatio = shipSettings.SpeedRatio.Value or 1
local RotationMultiplier = shipSettings.RotationMultiplier.Value or 2.4
local Acceleration = shipSettings.Acceleration.Value or 0.1
local Deacceleration = shipSettings.Deacceleration.Value or 0.1
local MaxSpeed = shipSettings.MaxSpeed.Value or 15
local RollRatio = shipSettings.RollRatio.Value or 10
local VerticalRollRatio = shipSettings.VerticalRollRatio.Value or 4

local ParticleVelocityRate = particleSettings.ParticleVelocityRate.Value or 200
local BowFoamParticleRate = particleSettings.BowFoamParticleRate.Value or 200
local PortFoamParticleRate = particleSettings.PortFoamParticleRate.Value or 200
local StarboardFoamParticleRate = particleSettings.StarboardFoamParticleRate.Value or 200
local SternFoamParticleRate = particleSettings.SternParticleRate.Value or 200

local debugging = SystemSettings.ShipDebugging or false

local V3 = Vector3.new
local Clamp = math.clamp

local SailForceRatio = 1

if ship:FindFirstChild("Sails") then
	IsASailShip = true
	SailForceRatio = shipSettings:WaitForChild("Sails").SailForceRatio.Value
end

if ship:FindFirstChild("FuelTanks") then
	IsAEngineShip = true
end

local PitchMaxAngle = 45

if ship:WaitForChild("Ship"):FindFirstChild("Control") then
	IsAngularControls = true
	PitchMaxAngle = shipSettings:WaitForChild("Maneuverability").PitchMaxAngle.Value
end

local ShipMainPart = ship:WaitForChild("Ship")

local waveHeightMultiplier = shipSettings.waveHeightMultiplier.Value or 6

local Throttle = IsAEngineShip == true and shipValues.Throttle or nil
local Rotation = shipValues.Rotation
local PitchValue = nil
local RollValue = nil

if IsAngularControls == true then
	PitchValue = shipValues:WaitForChild("Pitch")
	RollValue = shipValues:WaitForChild("Roll")
end

local SideThrust = IsAEngineShip == true and shipValues.SideThrusterForce or nil
local Anchored = shipValues.Anchored

local FirstSinkFloater = nil
local SinkSecondaryFloater = nil
local Sinking = false

local ShipWashTable = {}
ShipWashTable.Front = effects:WaitForChild("BowWash")
ShipWashTable.Left = effects:WaitForChild("HullWash")
ShipWashTable.Right = effects:WaitForChild("HullWash")
ShipWashTable.Rear = effects:WaitForChild("RearWash")

local rollController = RoPID.new(1, 0, .75)

function VFX(floattype, state, waveheight, SailPower)
	local ParticleType = floattype	
	local WashType = ShipWashTable[ParticleType]
	local ParticleState = state

	for _, Attachment in pairs(WashType:GetChildren()) do
		if Attachment:IsA("Attachment") and Attachment:FindFirstChild("Effect") then
			local WaveHeight = Waves.GerstnerWaves(Attachment.Position).Y
			local ParticleRate = 0

			if ParticleType == "Front" then
				ParticleRate = BowFoamParticleRate * (ShipMainPart.Velocity.Magnitude/ParticleVelocityRate + 0.1 + SailPower)
			elseif ParticleType == "Left" then
				ParticleRate = PortFoamParticleRate * (ShipMainPart.Velocity.Magnitude/ParticleVelocityRate + 0.1 + SailPower)
			elseif ParticleType == "Right" then
				ParticleRate = StarboardFoamParticleRate * (ShipMainPart.Velocity.Magnitude/ParticleVelocityRate + 0.1 + SailPower)
			elseif ParticleType == "Rear" then
				ParticleRate = SternFoamParticleRate * (ShipMainPart.Velocity.Magnitude/ParticleVelocityRate + 0.1 + SailPower)
			end

			Attachment.Position = V3(Attachment.Position.X,WaveHeight+ShipWakeHeightDisplacement,Attachment.Position.Z)
			Attachment.Effect.Rate = ParticleRate

			if ParticleState == "Under" then
				Attachment.Effect.Enabled = true
			elseif ParticleState == "Above" then
				Attachment.Effect.Enabled = false
			end
		end
	end
end

local CurrentSpeed = 0


local roundDecimals = function(num, places)

	places = math.pow(10, places or 0)
	num = num * places

	if num >= 0 then 
		num = math.floor(num + 0.5) 
	else 
		num = math.ceil(num - 0.5) 
	end

	return num / places

end

function CalculateSpeed(AnchorForce, Sail_Speed, CurrentThrottle, DeltaStep)
	local DesiredSpeed = ((((MaxSpeed * CurrentThrottle) + (Sail_Speed*SailForceRatio)) / AnchorForce))

	if CurrentSpeed <= DesiredSpeed then
		CurrentSpeed += Acceleration/2
	elseif CurrentSpeed >= DesiredSpeed then
		CurrentSpeed -= Deacceleration/2
	end
	--CurrentSpeed = (CurrentSpeed <= DesiredSpeed and CurrentSpeed + Acceleration/2 or CurrentSpeed - Deacceleration/2) --A simple ternary operation that calculates the currentspeed
	CurrentSpeed = (CurrentSpeed >= MaxSpeed and MaxSpeed or CurrentSpeed) --This fixes the currentspeed

	--print(DesiredSpeed)
	--print(CurrentSpeed)
end

local ShipFloaters = script.Parent.Parent:WaitForChild("Floater"):GetChildren()
local ShipFloatersSize = #ShipFloaters

local ShipPrimaryPart = ship.PrimaryPart
local BaseAttachment = ShipPrimaryPart:WaitForChild("BaseAttachment")

local TotalDistanceTraveled = 0

local LastLocation = ship.PrimaryPart.Position

local IsThereDataHandling = false

if ScriptService:WaitForChild("Crescendum_Ship_System"):WaitForChild("ShipSystemFramework"):FindFirstChild("DataHandler") then
	IsThereDataHandling = true
end

local PlayerData = nil
local PlayerDataValues = {}

if IsThereDataHandling == true then
	PlayerData = Framework:WaitForChild("PlayerData"):WaitForChild(shipValues:WaitForChild("Owner").Value.UserId.."_Data")
	
	PlayerDataValues.PlayerDistanceValue = PlayerData:WaitForChild("DistanceTraveled")
	PlayerDataValues.PlayerMoney = PlayerData:WaitForChild("Money")
end

ShipPhysicsConnection = rs.Heartbeat:Connect(function(deltaTime)
	if Ship_Model:FindFirstChild("Ship") == nil then
		ShipPhysicsConnection:Disconnect()
	else
		if UseWeatherPlugin and Weather_Values then
			if not Anchored.Value then WeatherPhysicsPlugin.WindDrift = V3((Weather_Values.WindSpeed.Value * Weather_Values.WindDirection.Value.X)/SystemSettings.WeatherSystemPhysicsSettings.WindDriftIntensityRatio,0 ,(Weather_Values.WindSpeed.Value * Weather_Values.WindDirection.Value.Z)/SystemSettings.WeatherSystemPhysicsSettings.WindDriftIntensityRatio) else WeatherPhysicsPlugin.WindDrift = V3(0,0,0) end
		end

		local DeltaStep = deltaTime * 60
		local DeltaPhysicsStep = 1
		if SystemSettings.ShipPhysicsHandledByClient == true then
			DeltaPhysicsStep = DeltaStep/1.25
		end

		local anchor_force = 1
		local IsShipCapsized = false

		if DeltaPhysicsStep >= 1.9 then
			return
		end

		if Anchored.Value then anchor_force = AnchoringForceReduction end

		BaseAttachment.WorldCFrame = ship.PrimaryPart.CFrame

		local CurrentThrottle = IsAEngineShip == true and shipValues.Throttle.Value or 0
		local Sail_Speed = 0

		if IsASailShip == true then
			Sail_Speed = shipValues:WaitForChild("SailPower").Value
		end

		CalculateSpeed(anchor_force, Sail_Speed, CurrentThrottle, DeltaStep)

		local ThrustDirection = 1

		if CurrentSpeed < 0 then
			ThrustDirection = -1
		end

		local BackwardRollRatio = 1
		local ForwardRollRatio = 1

		local Gravity = workspace.Gravity

		local RollRatio = (CurrentSpeed / MaxSpeed)/RollRatio
		local LeftRollRatio = 1 - (1 * Rotation.Value) * RollRatio
		local RightRollRatio = 1 - (1 * -Rotation.Value) * RollRatio

		local VerticalRollRatio = (CurrentSpeed / MaxSpeed)/VerticalRollRatio
		if IsASailShip == false and IsAEngineShip == true then
			local BackwardRollRatio = 1 - (1 * CurrentThrottle) * VerticalRollRatio
			local ForwardRollRatio = 1 - (1 * -CurrentThrottle) * VerticalRollRatio
		elseif IsASailShip == true and IsAEngineShip == true then
			local BackwardRollRatio = 1 - (1 * CurrentThrottle + Sail_Speed) * VerticalRollRatio
			local ForwardRollRatio = 1 - (1 * -CurrentThrottle + -Sail_Speed) * VerticalRollRatio
		elseif IsASailShip == true and IsAEngineShip == false then
			local BackwardRollRatio = 1 - (1 *  Sail_Speed) * VerticalRollRatio
			local ForwardRollRatio = 1 - (1 * -Sail_Speed) * VerticalRollRatio
		end

		local CurrentPosition = ship.PrimaryPart.Position
		local VelocityMagnitude = ShipPrimaryPart.Velocity.Magnitude

		--[[
		if ShipPrimaryPart.Orientation.Z >= 85 or ShipPrimaryPart.Orientation.Z <= -85 then
			IsShipCapsized = true
			Sail_Speed = 0
			CurrentThrottle = 0
		end
		]]

		for i = 1, ShipFloatersSize do
			local floater = ShipFloaters[i]
			local health_ratio = 0.99
			
			local FloaterMagnitude = floater.AssemblyLinearVelocity

			local ShipBodyVelocity = ShipPrimaryPart:WaitForChild("BodyVelocity")
			local ShipSideThrust = ShipPrimaryPart:WaitForChild("SideThrust")
			local FloatType = floater:WaitForChild("Type").Value

			local FloatCurrentCapacity = floater:WaitForChild("CurrentCapacity")
			local FloatTargetCapacity = floater:WaitForChild("TargetCapacity")
			
			local FloatState = "Under"

			if FloatCurrentCapacity.Value ~= FloatTargetCapacity.Value then
				local DesiredCapacity = FloatTargetCapacity.Value
				local CurrentCapacity= FloatCurrentCapacity.Value

				if CurrentCapacity <= DesiredCapacity then
					CurrentCapacity += 0.001/2
				elseif CurrentCapacity >= DesiredCapacity then
					CurrentCapacity -= 0.001/2
				end
				--CurrentSpeed = (CurrentSpeed <= DesiredSpeed and CurrentSpeed + Acceleration/2 or CurrentSpeed - Deacceleration/2) --A simple ternary operation that calculates the currentspeed
				CurrentCapacity = (CurrentCapacity >= 1 and 1 or CurrentCapacity) --This fixes the currentspe


				if CurrentCapacity < 0 then
					CurrentCapacity = 0
				end

				FloatCurrentCapacity.Value = CurrentCapacity
			end

			local ActualRotation = 0

			if NeedAccelerationToChangeShipYaw == true then

				if IsASailShip == false and IsAEngineShip == true then
					ActualRotation = Rotation.Value * CurrentThrottle
				elseif IsASailShip == true and IsAEngineShip == true then

					local ThrottleSailpower = Sail_Speed + CurrentThrottle

					if ThrottleSailpower > 1 then
						ThrottleSailpower = 1
					elseif ThrottleSailpower < -1 then
						ThrottleSailpower = -1
					end

					ActualRotation = Rotation.Value * ThrottleSailpower
				elseif IsASailShip == true and IsAEngineShip == false then
					ActualRotation = Rotation.Value * Sail_Speed
				end
			else
				ActualRotation = Rotation.Value
			end

			if IsAngularControls == true then
				local pitch = PitchMaxAngle * (-PitchValue.Value)
				local rollAngle = RollValue.Value
				local roll = rollController:Calculate(0, rollAngle, deltaTime)

				ShipPrimaryPart.Control.AngularVelocity = Vector3.new(pitch, 0, roll)
			end

			local FloatWorldPositionX = floater:WaitForChild("Attachment0").WorldPosition.X
			local FloatWorldPositionY = floater:WaitForChild("Attachment0").WorldPosition.Y
			local FloatWorldPositionZ = floater:WaitForChild("Attachment0").WorldPosition.Z
			local FloatBodyPosition = floater:WaitForChild("BodyPosition")

			floater:WaitForChild("Attachment0").WorldOrientation = V3()

			if Sinking then
				health_ratio = (Health_Table[FloatType].Value / Health_Table[FloatType].MaxValue)
			end

			local waveHeight = (Waves.GerstnerWaves(floater.Position).Y+WaveHeightDisplacement)

			local displacementMultiplier = Clamp((waveHeight - FloatWorldPositionY) / depthBeforeSubmerged,0,1) * displacementAmount

			if FloatWorldPositionY <= waveHeight then
				FloatState = "Under"
				local GravMass = (Gravity * totalMass)
				local GravMassDisplacement = GravMass * displacementMultiplier
				local WaveHeight_WaveHeightMultiplier = waveHeight*waveHeightMultiplier

				local FloatCapacityRatio = (1.1 - FloatCurrentCapacity.Value)

				--floater.VectorForce.Force = V3(0,Gravity,0) --/#floaters
				FloatBodyPosition.Position = V3(FloatWorldPositionX+waveHeight * FloatCapacityRatio,(waveHeight+FloatWorldPositionY) * FloatCapacityRatio,FloatWorldPositionZ+waveHeight * FloatCapacityRatio)

				FloatBodyPosition.MaxForce = (((V3(0,(GravMassDisplacement),0) * health_ratio) * FloatCapacityRatio) / (1 + math.clamp(FloaterMagnitude.Y,0,math.huge)/1.5)) * DeltaPhysicsStep

				if FloatType == "Left" then
					floater.VectorForce.Force = (((V3(WaveHeight_WaveHeightMultiplier,GravMassDisplacement,WaveHeight_WaveHeightMultiplier) * health_ratio) * LeftRollRatio)* FloatCapacityRatio) * DeltaPhysicsStep
				elseif FloatType == "Right" then
					floater.VectorForce.Force = (((V3(WaveHeight_WaveHeightMultiplier,GravMassDisplacement,WaveHeight_WaveHeightMultiplier) * health_ratio) * RightRollRatio) * FloatCapacityRatio) * DeltaPhysicsStep
				elseif FloatType == "Front" then
					floater.VectorForce.Force = (((V3(WaveHeight_WaveHeightMultiplier,GravMassDisplacement,WaveHeight_WaveHeightMultiplier) * health_ratio) * ForwardRollRatio) * FloatCapacityRatio) * DeltaPhysicsStep
				elseif FloatType == "Rear" then
					floater.VectorForce.Force = (((V3(WaveHeight_WaveHeightMultiplier,GravMassDisplacement,WaveHeight_WaveHeightMultiplier) * health_ratio) * BackwardRollRatio) * FloatCapacityRatio) * DeltaPhysicsStep
				else
					floater.VectorForce.Force = ((V3(WaveHeight_WaveHeightMultiplier,GravMassDisplacement,WaveHeight_WaveHeightMultiplier) * health_ratio) * FloatCapacityRatio) * DeltaPhysicsStep
				end

				--ShipPrimaryPart:WaitForChild("FloatForce").Force = (-ShipPrimaryPart.Velocity * displacementMultiplier * waterDrag * deltaTime)
				ShipBodyVelocity.MaxForce = V3((GravMassDisplacement),(GravMassDisplacement),(GravMassDisplacement))

				--ShipPrimaryPart.ThrottleForce.Force = V3(((Gravity * totalMass.Value) * displacementMultiplier)*(Throttle.Value/100),0,0) --(-ShipPrimaryPart.Velocity * displacementMultiplier * waterDrag.Value * deltaTime)
				ShipBodyVelocity.Velocity = ShipPrimaryPart.CFrame.LookVector * ((CurrentSpeed * (((GravMass/waterDrag * SpeedRatio + VelocityMagnitude/VelocityRatio) * ((Sail_Speed+(CurrentSpeed/MaxSpeed))/EngineForceDivider)))) * ThrustDirection) + (WeatherPhysicsPlugin.WindDrift/anchor_force)

				if IsAEngineShip == true and SideThrust then
					ShipSideThrust.LineVelocity = SideThrust.Value * SideThrusterRatio
				end
				--print(ShipBodyVelocity.Velocity)
				ShipPrimaryPart:WaitForChild("Torque").Torque = V3(0,((ActualRotation * TurnMaxTorque)*RotationMultiplier)/anchor_force,0) --(displacementMultiplier * -ShipPrimaryPart.RotVelocity * displacementMultiplier * waterAngularDrag.Value* deltaTime)
				ShipPrimaryPart.RotVelocity /= waterAngularDrag

				VFX(FloatType, FloatState, waveHeight, Sail_Speed)

				--emitparticle()
			else
				FloatState = "Above"
				local GravMass = (Gravity * totalMass)
				local GravMassDisplacement = GravMass * displacementMultiplier

				if Sinking == false then
					--ShipBodyVelocity.Velocity = Vector3.new(0,0,0)
					--ShipBodyVelocity.Velocity = ShipBodyVelocity.Velocity * (GravMass/waterDrag*SpeedRatio+VelocityMagnitude/VelocityRatio) + (WeatherPhysicsPlugin.WindDrift/anchor_force)
				end

				floater.VectorForce.Force = V3(0,Gravity,0) --/#floaters
				ShipSideThrust.LineVelocity = 0
				FloatBodyPosition.MaxForce = V3(0,GravMassDisplacement,0)  * health_ratio
				FloatBodyPosition.Position = V3(FloatWorldPositionX,waveHeight,FloatWorldPositionZ)
				ShipPrimaryPart:WaitForChild("Torque").Torque = V3(0,0,0) --(displacementMultiplier * -ShipPrimaryPart.RotVelocity * displacementMultiplier * waterAngularDrag.Value* deltaTime)
				--floater.VectorForce.Force = V3(0,(Gravity * totalMass.Value) * displacementMultiplier,0)

				VFX(FloatType, FloatState, waveHeight, Sail_Speed)
			end

			if Sinking == true then
				--[[
				if FirstSinkFloater == "Front" or FirstSinkFloater == "Rear" then
					if FloatType == "Left" and SinkSecondaryFloater == "Left" then
						Health_Table[FloatType].Value = Health_Table[FloatType].Value - SinkingHealthDrop
					elseif FloatType == "Right" and SinkSecondaryFloater == "Right" then
						Health_Table[FloatType].Value = Health_Table[FloatType].Value - SinkingHealthDrop
					end
				elseif FirstSinkFloater == "Left" then
					if FloatType == "Right" then
						Health_Table[FloatType].Value = Health_Table[FloatType].Value - SinkingHealthDrop
					end
				elseif FirstSinkFloater == "Right" then
					if FloatType == "Left" then
						Health_Table[FloatType].Value = Health_Table[FloatType].Value - SinkingHealthDrop
					end
				end
				]]
				if SinkSecondaryFloater == FloatType then
					Health_Table[SinkSecondaryFloater].Value = Health_Table[SinkSecondaryFloater].Value - SinkingHealthDrop
				elseif SinkSecondaryFloater == "Left+Right" then
					if FloatType == "Left" or FloatType == "Right" then
						Health_Table[FloatType].Value = Health_Table[FloatType].Value - SinkingHealthDrop
					end
				end
			end

			if Health_Table[FloatType].Value <= Health_Table[FloatType].MinValue then
				Sinking = true

				if FirstSinkFloater == nil then
					FirstSinkFloater = FloatType
				end
				
				if SinkSecondaryFloater == nil then
					SinkSecondaryFloater = FloatDamageConnection[FloatType][Random.new():NextInteger(1,#FloatDamageConnection[FloatType])]
				else
					if SinkSecondaryFloater == FloatType then
						SinkSecondaryFloater = FloatDamageConnection[SinkSecondaryFloater][Random.new():NextInteger(1,#FloatDamageConnection[SinkSecondaryFloater])]
					elseif SinkSecondaryFloater == "Left+Right" and FloatType == "Right" or FloatType == "Left" then
						SinkSecondaryFloater = FloatDamageConnection[SinkSecondaryFloater][Random.new():NextInteger(1,#FloatDamageConnection[SinkSecondaryFloater])]
					end
				end
			end


			if Health_Table.Front.Value <= Health_Table.Front.MinValue and Health_Table.Right.Value <= Health_Table.Right.MinValue and Health_Table.Left.Value <= Health_Table.Left.MinValue and Health_Table.Rear.Value <= Health_Table.Rear.MinValue then
				Debris:AddItem(ship,5)
			end

			if debugging == true then

				floater.flt_debug.Stats.bpmf.Text = "BodyPosition : MaxForce : "..roundDecimals(FloatBodyPosition.MaxForce.X,2)..","..roundDecimals(FloatBodyPosition.MaxForce.Y,2)..","..roundDecimals(FloatBodyPosition.MaxForce.Z,2)
				floater.flt_debug.Stats.bpp.Text = "BodyPosition : Position : "..roundDecimals(FloatBodyPosition.Position.X,2)..","..roundDecimals(FloatBodyPosition.Position.Y,2)..","..roundDecimals(FloatBodyPosition.Position.Z,2)
				floater.flt_debug.Stats.vff.Text = "VectorForce : Force : "..roundDecimals(floater.VectorForce.Force.X,2)..","..roundDecimals(floater.VectorForce.Force.Y,2)..","..roundDecimals(floater.VectorForce.Force.Z,2)
				floater.flt_debug.Stats.c.Text = "Float : Capacity : "..tostring(FloatCurrentCapacity.Value)
				floater.flt_debug.Stats.tc.Text = "Float : TargetCapacity : "..tostring(FloatTargetCapacity.Value)
				floater.flt_debug.Stats.s.Text = "Float : State : "..tostring(FloatState)

				ShipPrimaryPart.main_debug.Stats.bvmf.Text = "BodyVelocity : MaxForce : "..roundDecimals(ShipBodyVelocity.MaxForce.X,2)..","..roundDecimals(ShipBodyVelocity.MaxForce.Y,2)..","..roundDecimals(ShipBodyVelocity.MaxForce.Z,2)
				ShipPrimaryPart.main_debug.Stats.bvv.Text = "BodyVelocity : Velocity : "..roundDecimals(ShipBodyVelocity.Velocity.X,2)..","..roundDecimals(ShipBodyVelocity.Velocity.Y,2)..","..roundDecimals(ShipBodyVelocity.Velocity.Z,2)
				ShipPrimaryPart.main_debug.Stats.m.Text = "Mass  : "..tostring(roundDecimals(ShipPrimaryPart.Mass,2))
				ShipPrimaryPart.main_debug.Stats.t.Text = "Torque  : "..tostring(ShipPrimaryPart:WaitForChild("Torque").Torque)
			end
		end
		local DistanceTraveled = (LastLocation-CurrentPosition).Magnitude
		LastLocation = CurrentPosition
		
		TotalDistanceTraveled = TotalDistanceTraveled + DistanceTraveled
		
		if IsThereDataHandling == true then
			PlayerDataValues.PlayerDistanceValue.Value = PlayerDataValues.PlayerDistanceValue.Value + DistanceTraveled
			PlayerDataValues.PlayerMoney.Value = PlayerDataValues.PlayerMoney.Value + (math.round(DistanceTraveled*2))
		end
		
		SinkingValue.Value = Sinking
	end
end)

table.insert(Connections, ShipPhysicsConnection)