let fs = require("fs");
let util = require("util");

const fengari = require("fengari");
const fengari_web = require("fengari-web");
let parser = require("luaparse");
let LuaVM = require("lua.vm.js");

const CodePrefix = "CRESCENDUM";

//console.log(fengari.luaconf.LUA_COMPAT_FLOATSTRING);

fengari.luaconf.LUA_COMPAT_FLOATSTRING = true;

exports.EncryptSourceCode = function (code, api_key, code_name) {
  let ToEncrypt = `
  local function crypt(plaintext,key,mode)
  local new_string = ""
  local pass = 0 
  for c_key = 1, #key do 
      pass = pass + string.byte(string.sub(key,c_key,c_key))
  end 
  if pass > 255 then
      pass =  math.floor(pass / (pass/255 +1))
  end
  if mode == 0 then 
      for encrypt = 1,#plaintext do 
          local add_byte = string.byte(string.sub(plaintext,encrypt,encrypt)) 
          if add_byte + pass > 255 then 
              add_byte = add_byte + pass - 255
          else
              add_byte = add_byte + pass
          end

          local add_string = string.char(add_byte) 
          new_string = new_string..add_string
      end 
  elseif mode == 1 then 
      for decrypt = 1,#plaintext do 
          local add_byte = string.byte(string.sub(plaintext,decrypt,decrypt)) 
          if add_byte - pass  < 0 then 
              add_byte = 255 + add_byte-pass 
          else
              add_byte = add_byte - pass
          end

          local add_string = string.char(add_byte) 
          new_string = new_string..add_string
      end 
  end 
  plaintext = nil 
  return new_string
end

local Code = crypt([====[${code}]====], "${api_key}",0)

return Code
`;

  let FengariCode = fengari_web.load(ToEncrypt)();

  if (code_name) {
    let log_file = fs.createWriteStream(__dirname + `/dump/${code_name}.log`, { flags: "w" });
    let enc_file = fs.createWriteStream(__dirname + `/dump/enc_${code_name}.log`, { flags: "w" });

    log_file.write(util.format(code));
    enc_file.write(util.format(FengariCode));
  }

  if (FengariCode) {
    return CodePrefix + "_" + FengariCode;
  } else {
    return undefined;
  }
};
