require("dotenv").config();

let fs = require("fs");
let util = require("util");
let typeCheck = require("type-check").typeCheck;

function GetCurrentDate() {
  const now = new Date();

  const year = now.getFullYear();
  const month = ("0" + (now.getMonth() + 1)).slice(-2);
  const day = ("0" + now.getDate()).slice(-2);

  const formatted = `${day}-${month}-${year}`;

  return formatted
}

let log_file = fs.createWriteStream(__dirname + `/logs/${GetCurrentDate()}-debug.log`, { flags: "w" });
let log_stdout = process.stdout;
let log_stderr = process.stderr;

console.log = function (d) {
  log_file.write(util.format(d) + "\n");
  log_stdout.write(util.format(d) + "\n");
  log_stderr.write(util.format(d) + "\n");
};

let access = fs.createWriteStream(__dirname + `/logs/${GetCurrentDate()}-stdout.log`, { flags: "w" });
process.stdout.write = process.stderr.write = access.write.bind(access);

process.on("uncaughtException", function (err) {
  console.error(err && err.stack ? err.stack : err);
});

const { Cookie } = require("./config.json");
const { config } = require("process");
const path = require("path");
const express = require("express");
const crypto = require("crypto");
const axios = require("axios");
const http = require("http");
const cors = require("cors");
const luamin = require("lua-format");
const fengari = require("fengari");
fengari.luaconf.LUA_COMPAT_FLOATSTRING = true;


const LuaCipher = require("./lua_vm/cipher.js");
const file_dependencies = require("./library/dependencies.js");
const version_data = require("./library/versions.js");
const discord_flags = require("./discord_api/flags.js");

const admin = require("firebase-admin");
const serviceAccount = require("./firebase-config.json");

admin.initializeApp({
  credential: admin.credential.cert(serviceAccount),
  databaseURL: "https://weather-system-strawberry-default-rtdb.firebaseio.com",
});

const db = admin.firestore();
const rdb = admin.database();
const ref = rdb.ref("WhitelistAccounts");

const CachedAddresses = new Map(); // <jobId, IServerData>
const AddressTimer = new Map(); // <jobId, IServerData>
const ServerCode = new Map(); // <jobId, IServerData>
const FailedRequests = new Map();

let TimeAlive = 0;
let AuthRequestsReceived = 0;
let SourceRequestsReceived = 0;

let ResponsePrefix = `[ERROR] Crescendum Framework :`

const port = 3000;
const app = express();
app.use(cors());

app.disable("x-powered-by");
app.use(express.text({limit: '50mb'}))
app.use(express.json({limit: '50mb'}));
app.use(express.urlencoded({extended: true, limit: '50mb'}));

app.set("trust proxy", true);

app.use((req, res, next) => {
  res.append("Access-Control-Allow-Methods", "GET,POST");
  next();
});

app.use(function(req, res, next) {
  let send = res.send;
  res.send = function(body){

    if (typeof body === 'string') {

      if (body.length < 100) {

        if (body.toString().search("Crescendum Framework :") > -1) {

          let place_id = req.header("roblox-id");
  
  
          let date_ob = new Date();
  
          FailedRequests.set(FailedRequests.size + 1, [place_id,res.statusCode,body,date_ob.toLocaleString()]);
        }
      }
    }

    res.send = send;
    res.send(body);
  };
  next();
});

function formatCookie(cookie) {
  return `.ROBLOSECURITY=${cookie}; path=/; domain=.roblox.com;`;
}

function snowflakeToDate(id) {
  let temp = parseInt(id).toString(2);
  let length = 64 - temp.length;

  if (length > 0) for (let i = 0; i < length; i++) temp = "0" + temp;

  temp = temp.substring(0, 42);
  date = new Date(parseInt(temp, 2) + 1420070400000);

  return date;
}

async function getServerInfo(placeId, jobid) {
  return new Promise(async function (resolve, reject) {
    const timer = setTimeout(() => {
      resolve(null);
    }, 20000);

    const res = await axios
      .post(
        "https://gamejoin.roblox.com/v1/join-game-instance",
        {
          placeId: placeId,
          isTeleport: false,
          gameId: jobid,
          gameJoinAttemptId: jobid,
        },
        {
          headers: {
            Referer: `https://www.roblox.com/games/${placeId}/`,
            Origin: "https://roblox.com",
            Cookie: formatCookie(Cookie),
            "User-Agent": "Roblox/WinInet",
          },
        }
      )
      .catch((err) => {});

    data = res.data;

    if (data) {
      if (data.jobId == null || data.joinScript == null) {
        resolve();
      } else {
        resolve({
          ip: data.joinScript.MachineAddress,
          port: data.joinScript.ServerPort,
          jobid: data.jobId,
          creatortypeenum: data.joinScript.CreatorTypeEnum,
        });
      }
    } else {
      resolve();
    }
  });
}

async function make_query(type, creator_id) {
  return new Promise(function (resolve, reject) {
    const timer = setTimeout(() => {
      resolve(null);
    }, 2000);

    let query = undefined

    if (type && creator_id) {
      if (type == "num") {
        query = parseFloat(creator_id)
      } else if (type == "string") {
        query = String(creator_id)
      }
    }

    console.log("trying " + type + " query")
      ref
      .orderByChild("PlayerID")
      .equalTo(query)
      .on("child_added", function (num_snapshot) {
          console.log("Got query results (" + type + ")");
          resolve(num_snapshot)
      });
  });
}

async function checkAcc(creator_id) {

  console.log("1 - id: " + creator_id + " | type: " + typeof(creator_id))

  let received_query_num = await make_query("num", creator_id).then((promise_response) => {
    if (promise_response) {
      return promise_response
    } else {
      return null
    };
  });
        
  console.log("2 - num query response: " + received_query_num)

  if (!received_query_num) {
    let received_query_string = await make_query("string", creator_id).then((promise_response) => {
      if (promise_response) {
        return promise_response
      } else {
        return null
      };
    });

    console.log("3 - string query response: " + received_query_num)

    if (received_query_string) {
      return received_query_string
    } else {
      return null
    }
  } else {
    return received_query_num
  }

}

app.post(
  ["/auth","/api/auth"],
  cors({
    methods: ["POST"],
  }),
  async (req, res) => {

    try {
      let placeId = req.header("roblox-id");
      let jobid = req.header("roblox-job");
      let creatorid = req.header("roblox-creatorid");
      let creatortype = req.header("roblox-creatortype");
      let acc_id = req.header("acc-id");
      let api_key = req.header("api-key");
      let version = req.header("framework-version");
      let originAddress = req.ip;
  
      if (
        !placeId ||
        !creatorid ||
        !creatortype ||
        !jobid ||
        !acc_id ||
        !api_key ||
        !originAddress ||
        !version
      )
        return res
          .status(400)
          .send(`${ResponsePrefix} Invalid Header.`);
  
      if (
        typeCheck("String", jobid) == true &&
        typeCheck("String", creatorid) == true &&
        typeCheck("String", creatortype) == true &&
        typeCheck("String", acc_id) == true &&
        typeCheck("String", api_key) == true &&
        typeCheck("String", version) == true &&
        typeCheck("String", placeId) == true
      ) {
        console.log("correct data type");
      } else {
        console.log("wrong data type");
        return res
          .status(400)
          .send(`${ResponsePrefix} Invalid Data Type.`);
      }
  
      placeId = parseInt(placeId);
      creatorid = parseInt(creatorid);
      acc_id = parseInt(acc_id);
  
      if (isNaN(placeId) == true || isNaN(acc_id) == true || isNaN(creatorid) == true) {
        return res
          .status(400)
          .send(`${ResponsePrefix}  Invalid ID's.`);
      }
  
      if (version_data.versions[version] != true) {
        console.log("wrong version");
        return res
          .status(400)
          .send(`${ResponsePrefix} Invalid Framework Version`);
      }

      AuthRequestsReceived = AuthRequestsReceived + 1
  
      const roblox_game_data = await getServerInfo(placeId, jobid);
  
      let req_acc_data = undefined;
      const acc_data = await checkAcc(parseFloat(acc_id));
  
      if (acc_data) {
        req_acc_data = acc_data.val();
  
        if (req_acc_data.Blacklisted == "true") {
          console.log("Authenticating user is blacklisted.");
          return res
            .status(401)
            .send(
              `${ResponsePrefix} Your Crescendum Account is Blacklisted.`
            );
        }
  
        if (req_acc_data.AccountStatus != "Functional") {
          console.log("Authenticating user account is disabled.");
          return res
            .status(401)
            .send(
              `${ResponsePrefix} Your Crescendum Account has been disabled.`
            );
        }
  
        if (!req_acc_data.API_Key) {
          console.log("Authenticating user has no api key");
          return res
            .status(401)
            .send(
              `${ResponsePrefix} Your Crescendum Account is missing an API Key.`
            );
        } else {
          if (api_key != req_acc_data.API_Key) {
            return res
            .status(401)
            .send(`${ResponsePrefix} Invalid API Key (Auth)`);
          }
        }
      } else {
        console.log("Couldn't find crescendum account");
        return res
          .status(401)
          .send(
            `${ResponsePrefix} Couldn't find Crescendum Account`
          );
      }
  
      if (roblox_game_data) {
        if (`Enum.CreatorType.${roblox_game_data.creatortypeenum}` != creatortype) {
          console.log("invalid creator");
          return res
            .status(401)
            .send(`${ResponsePrefix} Invalid Creator Type.`);
        }
        if (roblox_game_data.jobid != jobid) {
          console.log("invalid job");
          return res
            .status(401)
            .send(`${ResponsePrefix} Invalid Server Id.`);
        }
      } else {
        console.log(`Couldn't find server instance`);
        return res
          .status(401)
          .send(
            `${ResponsePrefix} Roblox Server Instance Couldn't be found. (Game must be public)`
          );
      }
  
      console.log(roblox_game_data.ip);
  
      console.log(originAddress);
  
      const Reg = /^[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/;
      let PartialAddress = Reg.exec(originAddress)[0];
  
      console.log(PartialAddress);
  
      if (
        CachedAddresses.get(jobid) &&
        req_acc_data
      ) {
        console.log("sent existing secret 1");
  
        const EncryptedSource = LuaCipher.EncryptSourceCode(
          CachedAddresses.get(jobid),
          req_acc_data.API_Key
        );
  
        if (EncryptedSource) {
          let IndexedSource = EncryptedSource;
          return res.send(IndexedSource);
        } else {
          return res
            .status(401)
            .send(`${ResponsePrefix} VM COMPILATION FAILED!`);
        }
  
        //return res.json(EncryptedSource);
      } else {
         if (req_acc_data) {
          console.log("sent new secret");

          let roblox_data = undefined

          if (roblox_game_data) {
            roblox_data = roblox_game_data
          } else {
            roblox_data = await getServerInfo(placeId, jobid);
          }
  
          if (roblox_data) {
            console.log(roblox_data);
            console.log(roblox_data.ip);
            console.log(PartialAddress);
  
            //if (data.ip == originAddress) {
            if (PartialAddress) {
              console.log("ip match");
              const secret = crypto.randomBytes(64).toString("hex");
  
              console.log("created new key : " + secret)
  
  
              /* const cachedata = {
                placeid: placeId,
                secret: secret,
              };
              */
  
              const EncryptedSource = LuaCipher.EncryptSourceCode(
                secret,
                req_acc_data.API_Key
              );
  
              console.log(req_acc_data.API_Key)
  
              if (EncryptedSource) {
                let IndexedSource = EncryptedSource;
  
                CachedAddresses.set(jobid, secret);
                AddressTimer.set(jobid, 0);
                ServerCode.set(jobid, {
                  Place: {
                    PlaceId: placeId,
                    JobId: jobid,
                    CreatorType: roblox_data.creatortypeenum,
                    API_Key: api_key,
                    Version: version,
                  },
                  Tech: {
                    Weather: false,
                    Ship: false,
                  },
                  Dependencies_Weather: {
                    weathergenerator: false,
                    weathercommandhandler: false,
                    timecycle: false,
                    statsystem: false,
                    dynamicweather: false,
                  },
                  Dependencies_Ship: {
                    shipframework: false,
                  },
                });
  
                return res.send(IndexedSource);
              } else {
                return res
                  .status(401)
                  .send(`${ResponsePrefix} VM COMPILATION FAILED!`);
              }
            } else {
              console.log("ip mismatch");
              return res
                .status(401)
                .send(`${ResponsePrefix} Invalid ip.`);
            }
          } else {
            return res
            .status(401)
            .send(
              `${ResponsePrefix} Missing roblox game server data.`
            );
          }
        } else {
          return res
          .status(401)
          .send(
            `${ResponsePrefix} Couldn't find a Crescendum Account`
          );
        }
      }
    } catch (err) {
      console.log(err);
      return res
      .status(400)
      .send(`${ResponsePrefix} Auth request failed.`);
    }

  }
);

console.log(3);

app.get(
  ["/cres_framework","/api/framework"],
  cors({
    methods: ["GET"],
  }),
  async (req, res) => {

    try {
    let placeId = req.header("roblox-id");
    let jobid = req.header("roblox-job");
    let creatorid = req.header("roblox-creatorid");
    let acc_id = req.header("acc-id");
    let creatortype = req.header("roblox-creatortype");
    let product = req.header("product");
    let dependency = req.header("dependency");
    let auth_secret = req.header("auth-secret");
    let api_key = req.header("api-key");
    let version = req.header("framework-version");
    let originAddress = req.ip;

    if (
      !auth_secret ||
      !dependency ||
      !product ||
      !creatortype ||
      !creatorid ||
      !placeId ||
      !jobid ||
      !acc_id ||
      !originAddress ||
      !api_key ||
      !version
    )
      return res
        .status(400)
        .send(`${ResponsePrefix} Invalid Header.`);

    if (
      typeCheck("String", jobid) == true &&
      typeCheck("String", creatorid) == true &&
      typeCheck("String", creatortype) == true &&
      typeCheck("String", acc_id) == true &&
      typeCheck("String", api_key) == true &&
      typeCheck("String", version) == true &&
      typeCheck("String", product) == true &&
      typeCheck("String", dependency) == true &&
      typeCheck("String", auth_secret) == true &&
      typeCheck("String", placeId) == true
    ) {
      console.log("correct data type on request");
    } else {
      console.log("wrong data type");
      return res
        .status(400)
        .send(`${ResponsePrefix} Invalid Data Type.`);
    }

    placeId = parseInt(placeId);
    creatorid = parseInt(creatorid);
    acc_id = parseInt(acc_id);

    if (isNaN(placeId) == true || isNaN(acc_id) == true || isNaN(creatorid) == true) {
      return res
        .status(400)
        .send(`${ResponsePrefix} Invalid ID's.`);
    }

    if (version_data.versions[version] != true) {
      console.log("wrong version");
      return res
        .status(400)
        .send(`${ResponsePrefix} Invalid Framework Version`);
    }

    SourceRequestsReceived = SourceRequestsReceived + 1

    const Reg = /^[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/;
    let PartialAddress = Reg.exec(originAddress)[0];

    console.log(PartialAddress);

    let CachedServerCode = ServerCode.get(jobid)
    let CachedPlacedData = CachedServerCode["Place"]

    if (CachedServerCode && CachedPlacedData) {

      if (CachedPlacedData["JobId"] == jobid && 
       "Enum.CreatorType."+CachedPlacedData["CreatorType"] == creatortype &&
       CachedPlacedData["API_Key"] == api_key && 
       CachedPlacedData["Version"] == version && 
       CachedPlacedData["PlaceId"] == placeId) {
        
      } else {
        console.log("invalid cached data in " + jobid);
        return res
          .status(400)
          .send(`${ResponsePrefix} Invalid Cached Data`);
      }
    } else {
      console.log("no cached data in " + jobid);
      return res
        .status(400)
        .send(`${ResponsePrefix} No Cached Data.`);
    }

    if (CachedAddresses.get(jobid)) {
      const SecretKey = CachedAddresses.get(jobid);

      console.log(auth_secret);
      console.log(SecretKey);

      if (auth_secret == SecretKey) {
        const acc_data = await checkAcc(parseFloat(acc_id));

        if (acc_data) {
          const data = acc_data.val();

          let isidOkay = false;
          let isTypeOkay = false;
          let isBlacklisted = false;
          let isApiKeyOk = false;
          let isProductOk = false;
          let isAccountStatusOk = false;

          if (data.Blacklisted == "true") {
            isBlacklisted = true;
          }

          console.log(data.API_Key);
          console.log(api_key);

          console.log(data.AccountStatus);

          if (data.API_Key) {
            if (data.API_Key == api_key) {
              isApiKeyOk = true;
            } else {
              return res
                .status(401)
                .send(`${ResponsePrefix} Invalid API Key`);
            }

            if (data.AccountStatus == "Functional") {
              isAccountStatusOk = true;
            } else {
              return res
                .status(401)
                .send(
                  `${ResponsePrefix} Account Status: Invalid.`
                );
            }
          } else {
            return res
              .status(401)
              .send(`${ResponsePrefix} No API Key Found`);
          }

          Object.entries(data.Whitelists).forEach(([key, value]) => {
            console.log(key);
            console.log(product);

            const stringkey = key.toString();
            const stringproduct = product.toString();

            if (stringproduct == "weather") {
              if (stringkey.search("Ship_System") == -1) {
                isProductOk = true;
                console.log("whitelist - weather system");
              }
            } else if (stringproduct == "ship") {
              if (stringkey.search("Ship_System") > -1) {
                isProductOk = true;
                console.log("whitelist - ship system");
              }
            } else if (stringproduct == "framework") {
              isProductOk = true;
            }

            Object.entries(value).forEach(([key, value]) => {
              if (key == "ID") {
                if (value.toString() == creatorid.toString()) {
                  isidOkay = true;
                }
              } else if (key == "WhitelistType") {
                if (
                  "Enum.CreatorType." + value.toString() ==
                  creatortype.toString()
                ) {
                  isTypeOkay = true;
                }
              }
            });
          });

          if (
            isidOkay == true &&
            isTypeOkay == true &&
            isBlacklisted == false &&
            isApiKeyOk == true &&
            isProductOk == true &&
            isAccountStatusOk == true
          ) {
            if (product) {
              if (dependency) {
                console.log("sent file " + dependency);

                if (ServerCode.get(jobid)) {
                  if (product == "weather") {
                    ServerCode.get(jobid)["Tech"]["Weather"] = true
                    ServerCode.get(jobid)["Dependencies_Weather"][dependency] = true
                  } else if (product == "ship") {
                    ServerCode.get(jobid)["Tech"]["Ship"] = true
                    ServerCode.get(jobid)["Dependencies_Ship"][dependency] = true
                  }
                } else {
                  console.log("no cached data in " + jobid);
                  return res
                    .status(400)
                    .send(`${ResponsePrefix} No Cached Data.`);
                }

                const ReadBuffer = fs
                  .readFileSync(
                    `${__dirname}/systemcode/${file_dependencies.dependencies[product][dependency]}`
                  )
                  .toString();

                const Settings = {
                  RenameVariables: true,
                  RenameGlobals: false,
                  SolveMath: false,
                };

                if (ReadBuffer) {
                  return res.send(ReadBuffer);
                } else {
                  return res
                    .status(401)
                    .send(
                      `${ResponsePrefix} VM COMPILATION FAILED!`
                    );
                }
              } else {
                console.log("invalid dependency data");
                return res
                  .status(400)
                  .send(
                    `${ResponsePrefix} Invalid Dependency Data`
                  );
              }
            } else {
              console.log("invalid product data");
              return res
                .status(400)
                .send(`${ResponsePrefix} Invalid Product Data`);
            }
          } else {
            console.log("no matching whitelist data");
            return res
              .status(400)
              .send(`${ResponsePrefix} Invalid Whitelist Data`);
          }
        } else {
          console.log("no whitelist");
          return res
            .status(400)
            .send(`${ResponsePrefix} No Whitelist Record Found.`);
        }
      } else {
        console.log("wrong auth key");
        return res
          .status(401)
          .send(`${ResponsePrefix} Auth Key Mismatch`);
      }
    } else {
      console.log("wrong ip");
      return res.status(401).send(`${ResponsePrefix} Invalid IP`);
    }
    } catch (err) {
      return res
      .status(400)
      .send(`${ResponsePrefix} Failed Framework Request`);
    }
  }
);

app.get(
  "/user/:id/",
  cors({
    methods: ["GET"],
  }),
  async (req, res) => {
    let id = req.params.id;

    try {
      const axios_res = await axios
        .get(`https://canary.discord.com/api/v10/users/${id}`, {
          headers: {
            "Content-Type": "application/json",
            Authorization: `Bot ${"OTA1OTMwMzM1NDQ2MDA3ODM5.Ggefzw.oSoQWG8tEyubm9Ve0mPYdiq8wrbPoQKb3x8XVk"}`,
          },
        })
        .catch((err) => {});

      let data = axios_res.data;

      let publicFlags = [];

      discord_flags.USER_FLAGS.forEach((flag) => {
        if (data.public_flags & flag.bitwise) publicFlags.push(flag.flag);
      });

      let avatarLink = null;
      if (data.avatar)
        avatarLink = `https://cdn.discordapp.com/avatars/${data.id}/${data.avatar}`;

      let bannerLink = null;
      if (data.banner)
        bannerLink = `https://cdn.discordapp.com/banners/${data.id}/${data.banner}`;

      let output = {
        id: data.id,
        created_at: snowflakeToDate(data.id),
        username:
          parseInt(data.discriminator) > 0
            ? `${data.username}#${data.discriminator}`
            : data.username,
        global_name: data.global_name,
        badges: publicFlags,
        avatar: {
          id: data.avatar,
          link: avatarLink,
          is_animated:
            data.avatar != null && data.avatar.startsWith("a_") ? true : false,
        },
        banner: {
          id: data.banner,
          link: bannerLink,
          is_animated:
            data.banner != null && data.banner.startsWith("a_") ? true : false,
          color: data.banner_color,
        },
      };

      return res.send(output);
    } catch (err) {
      console.log(err);
    }
  }
);

app.get(
  ["/state","/api/state"],
  cors({
    methods: ["GET"],
  }),
  (req, res) => {

    try {

      const ConnectionDictionary = {};
      const ServerDictionary = {};
      const ReqDictionary = {};

      for (let [Req_Key, Req_value] of FailedRequests) {
        if (Req_Key && Req_value) {
          ReqDictionary[Req_Key] = Req_value;
        }
      }
  
      for (let [Address_key, Address_value] of AddressTimer) {
        if (Address_key && Address_value) {
          ConnectionDictionary[Address_key] = Address_value;
        }
      }
  
      for (let [Server_key, Server_value] of ServerCode) {
        if (Server_key && Server_value) {
          ServerDictionary[Server_key] = Server_value;
        }
      }
  
      const DataArray = {
        CurrentConnections: AddressTimer.size,
        Connections: ConnectionDictionary,
        ServerData: ServerDictionary,
        FailedReq: ReqDictionary,
        ServerTimeAlive: TimeAlive,
        AuthRequests: AuthRequestsReceived,
        SourceRequests: SourceRequestsReceived,
      };
  
      //console.log(DataArray);
  
      res.json(DataArray);
    } catch (err) {
      console.log(err);
    }
  }
);

app.post(
  ["/renew","/api/renew"],
  cors({
    methods: ["POST"],
  }),
  (req, res) => {

    try {
      let originAddress = req.ip;
      let version = req.header("framework-version");
      let jobid = req.header("roblox-job");
  
      if (
        !originAddress ||
        !version ||
        !jobid
      ) {
        return res
          .status(400)
          .send(`${ResponsePrefix} Invalid Header.`);
      }
  
      if (version_data.versions[version] != true) {
        console.log("wrong version");
        return res
          .status(400)
          .send(`${ResponsePrefix} Invalid Framework Version`);
      }
  
      const Reg = /^[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/;
      let PartialAddress = Reg.exec(originAddress)[0];
  
      if (AddressTimer.has(jobid)) {
        AddressTimer.set(jobid, 0);
        return res.send("renewed");
      } else {
        return res
          .status(400)
          .send(`${ResponsePrefix} Invalid Address.`);
      }
    } catch (err) {
      return res
      .status(400)
      .send(`${ResponsePrefix} Failed Renew Request`);
    }

  }
);

app.post(
  ["/debug","/api/debug"],
  cors({
    methods: ["POST"],
  }),
  (req, res) => {
    let originAddress = req.ip;
    let file = req.body

    console.log("received file" + file)

    if (
      !originAddress ||
      !file
    ) {
      return res
        .status(400)
        .send(`${ResponsePrefix} Invalid Header.`);
    }

    if (file) {

      console.log('got debug file?')
      let log_file = fs.createWriteStream(__dirname + `/lua_vm/dump/game_enc.log`, { flags: "w" });
  
      log_file.write(util.format(file));
    }

  }
);

app.get(["/i","/"], (req, res) => {
  res.sendFile(`${__dirname}/src/dunno.html`);
});

app.get(["/status","/test/status"], (req, res) => {
  res.sendFile(`${__dirname}/src/status.html`);
});

app.use("/static", express.static(path.join(__dirname, "public")));

app.listen(port, () => {
  console.log(`Application listening on port ${port}!`);
});

const AuthCheckLoop = setInterval(function () {
  for (let [key, value] of AddressTimer) {
    if (key) {
      value = value + 1;

      if (value > 300) {
        console.log("deleting key: " + key);
        AddressTimer.delete(key);
        CachedAddresses.delete(key);
        ServerCode.delete(key);
      } else {
        AddressTimer.set(key, value);
      }
    }
  }
  TimeAlive = TimeAlive + 1;
}, 1000);

module.exports = app;
