<?php
// Sākt sesiju
session_start();

// Pārbaudiet, vai pieprasījuma metode ir POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get data from form fields
    $postId = $_POST['postid'];
    $header = $_POST['header'];
    $text = $_POST['text'];
    $imageId = $_POST['imageid'];
    $kateg = $_POST['kateg']; // Assuming 'kateg' corresponds to the category ID

    // Iegūstiet autoru un autora ID no sesijas
    $autor = $_SESSION['autor'];
    $autorid = $_SESSION['autorid'];

    // Datu bāzes savienojuma parametri
    $servername = "109.106.254.1";
    $username = "u353443769_beis";
    $password = 'Te$t@dm1n';
    $dbname = "u353443769_beis";

    // Izveidojiet savienojumu
    $conn = new mysqli($servername, $username, $password, $dbname);

    // Pārbaudiet savienojumu
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Pārbaudiet, vai ziņojuma ID jau pastāv datu bāzē
    $sql_check = "SELECT * FROM pav_gra_postsi WHERE id = ?";
    $stmt_check = $conn->prepare($sql_check);
    $stmt_check->bind_param("i", $postId);
    $stmt_check->execute();
    $result_check = $stmt_check->get_result();

    if ($result_check->num_rows > 0) {
        // Ja pasta ID pastāv, veiciet atjaunināšanas darbību postsi tabulai
        $sql = "UPDATE pav_gra_postsi SET header = ?, text = ?, imageid = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssii", $header, $text, $imageId, $postId);
    } else {
        // Ja ziņas ID neeksistē, veiciet postsi tabulas ievietošanas darbību
        $sql = "INSERT INTO pav_gra_postsi (id, header, text, imageid) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("isss", $postId, $header, $text, $imageId);
    }

    // Izpildiet sagatavoto paziņojumu postsi tabulai
    if ($stmt->execute()) {
        // Check if category exists in kategj table
        $sql_check_category = "SELECT * FROM pav_gra_kategj WHERE post_id = ?";
        $stmt_check_category = $conn->prepare($sql_check_category);
        $stmt_check_category->bind_param("i", $postId);
        $stmt_check_category->execute();
        $result_check_category = $stmt_check_category->get_result();

        if ($result_check_category->num_rows > 0) {
            // Ja kategorija pastāv, veiciet atjaunināšanas darbību tabulai kategj
            $sql_category = "UPDATE pav_gra_kategj SET kateg = ? WHERE post_id = ?";
            $stmt_category = $conn->prepare($sql_category);
            $stmt_category->bind_param("ii", $kateg, $postId);
        } else {
            // Ja kategorijas nav, veiciet ievietošanas darbību tabulai kategj
            $sql_category = "INSERT INTO pav_gra_kategj (post_id, kateg) VALUES (?, ?)";
            $stmt_category = $conn->prepare($sql_category);
            $stmt_category->bind_param("ii", $postId, $kateg);
        }

        // Izpildiet sagatavoto paziņojumu kategj tabulai
        if ($stmt_category->execute()) {
            // Panākums
            echo json_encode(array("success" => true));
            header("Location: ../mani.html"); // Redirect to user page after saving
        } else {
            // Error
            echo json_encode(array("success" => false));
        }
    } else {
        // Error
        echo json_encode(array("success" => false));
    }

    // Aizvērt paziņojumus un datu bāzes savienojumu
    $stmt_check->close();
    $stmt->close();
    $stmt_check_category->close();
    $stmt_category->close();
    $conn->close();
} else {
    // Atgriezt kļūdas ziņojumu, ja pieprasījuma metode nav POST
    echo json_encode(array("error" => "Invalid request method"));
}
?>
