<?php

$servername = "109.106.254.1";
$username = "u353443769_beis";
$password = 'Te$t@dm1n';
$dbname = "u353443769_beis";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Function to rate a post
function ratePost($conn, $postId, $value) {
    $query = "UPDATE pav_gra_postsi SET rating = rating + ? WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ii", $value, $postId);
    if ($stmt->execute()) {
        $updatedRatingQuery = "SELECT rating FROM pav_gra_postsi WHERE id = ?";
        $stmt = $conn->prepare($updatedRatingQuery);
        $stmt->bind_param("i", $postId);
        $stmt->execute();
        $result = $stmt->get_result();
        return $result->fetch_assoc()['rating'];
    } else {
        return null;
    }
}

$postId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$action = isset($_GET['action']) ? $_GET['action'] : null;
$value = isset($_GET['value']) ? (int)$_GET['value'] : 0;

// Fetch post data
$query = "SELECT * FROM pav_gra_postsi WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $postId);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $post = $result->fetch_assoc();

    $imageFileName = '';
    switch ($post['imageid']) {
        case 1:
            $imageFileName = 'images/01_Steak.png';
            break;
        case 2:
            $imageFileName = 'images/02_Soup.png';
            break;
        case 3:
            $imageFileName = 'images/03_Salad.png';
            break;
        case 4:
            $imageFileName = 'images/04_Cake.png';
            break;
        case 5:
            $imageFileName = 'images/05_Pancake.png';
            break;
        case 6:
            $imageFileName = 'images/06_Shashlik.png';
            break;
        case 7:
            $imageFileName = 'images/07_Pizza.png';
            break;
        case 8:
            $imageFileName = 'images/08_Coffee.png';
            break;
        case 9:
            $imageFileName = 'images/09_Cookie.png';
            break;
        case 10:
            $imageFileName = 'images/10_Spaghetti.png';
            break;		
        case 11:
            $imageFileName = 'images/11_Chicken.png';
            break;	
        case 12:
            $imageFileName = 'images/12_Lasagna.png';
            break;				
        default:
            $imageFileName = 'images/default.png';
            break;
    }

    $postData = [
        'header' => htmlspecialchars($post['header']),
        'text' => htmlspecialchars($post['text']),
        'image' => $imageFileName,
        'autor' => htmlspecialchars($post['autor']),
        'rating' => $post['rating'],
        'image2' => $post['imageid']
    ];

    if ($action === 'like' || $action === 'dislike') {
        $updatedRating = ratePost($conn, $postId, ($action === 'like') ? $value : -$value);
        if ($updatedRating !== null) {
            $postData['rating'] = $updatedRating;
        }
    }

    // Fetch category data
    $query = "SELECT * FROM pav_gra_kategj WHERE post_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $postId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $post = $result->fetch_assoc();
        $Kategname = '';
        switch ($post['kateg']) {
            case 1:
                $Kategname = 'Nav';
                break;
            case 2:
                $Kategname = 'Cepumi';
                break;
            case 3:
                $Kategname = 'Gaļa';
                break;
			case 4:
                $Kategname = 'Salati';
                break;
			case 5:
                $Kategname = 'Dzerieni';
                break;
			case 6:
                $Kategname = 'Saldējumi';
                break;
            default:
                $Kategname = 'default';
                break;
        }
        $postData['kateg'] = $Kategname;
    }

    header('Content-Type: application/json');
    echo json_encode($postData);

} else {
    echo json_encode(['error' => 'Failed to fetch post data']);
}

$conn->close();
?>
