<?php
// Sāk sesiju
session_start();

// Pārbauda, vai pieprasījuma metode ir GET
if ($_SERVER["REQUEST_METHOD"] == "GET") {
    // Izgūst ieraksta ID no URL parametra
    $postId = $_GET['id'];

    // Pārbauda, vai sesijā ir iestatīts autorid
    if (!isset($_SESSION['autorid'])) {
        // Lietotājs nav pierakstījies
        // Sagatavo kļūdas atbildi
        $errorResponse = array(
            'success' => false,
            'message' => 'Lietotājs nav pierakstījies.'
        );

        // Atgriež JSON kļūdas atbildi
        echo json_encode($errorResponse);
        exit; // Pārtrauc skripta izpildi
    }

    // Pieņemsim, ka ir datubāzes savienojums
    $servername = "109.106.254.1";
    $username = "u353443769_beis";
    $password = 'Te$t@dm1n';
    $dbname = "u353443769_beis";

    // Izveido savienojumu
    $conn = new mysqli($servername, $username, $password, $dbname);

    // Pārbauda savienojumu
    if ($conn->connect_error) {
        // Datubāzes savienojums neizdevās
        // Sagatavo kļūdas atbildi
        $errorResponse = array(
            'success' => false,
            'message' => 'Datubāzes savienojums neizdevās.'
        );

        // Atgriež JSON kļūdas atbildi
        echo json_encode($errorResponse);
        exit; // Pārtrauc skripta izpildi
    }

    // Izgūst ieraksta datus, pamatojoties uz ieraksta ID
    $sql = "SELECT header, text, imageid, autorid FROM pav_gra_postsi WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $postId);
    $stmt->execute();
    $result = $stmt->get_result();

    // Pārbauda, vai ieraksta dati tika veiksmīgi iegūti
    if ($result->num_rows > 0) {
        // Iegūst ieraksta datus
        $row = $result->fetch_assoc();

        // Pārbauda, vai pierakstītais lietotājs ir ieraksta īpašnieks
        if ($row['autorid'] != $_SESSION['autorid']) {
            // Lietotājs nav ieraksta īpašnieks
            // Sagatavo kļūdas atbildi
            $errorResponse = array(
                'success' => false,
                'message' => 'Neautorizēta piekļuve.'
            );

            // Atgriež JSON kļūdas atbildi
            echo json_encode($errorResponse);
        } else {
            // Lietotājs ir ieraksta īpašnieks
            // Sagatavo atbildes datus
            $responseData = array(
                'success' => true,
                'header' => $row['header'],
                'text' => $row['text'],
                'imageid' => $row['imageid']
            );

            // Atgriež JSON atbildi
            echo json_encode($responseData);
        }
    } else {
        // Nav atrasts neviens ieraksts ar norādīto ID
        // Sagatavo kļūdas atbildi
        $errorResponse = array(
            'success' => false,
            'message' => 'Ieraksts nav atrasts.'
        );

        // Atgriež JSON kļūdas atbildi
        echo json_encode($errorResponse);
    }

    // Aizver datubāzes savienojumu
    $conn->close();
} else {
    // Atbild ar kļūdu, ja pieprasījuma metode nav GET
    $errorResponse = array(
        'success' => false,
        'message' => 'Nederīga pieprasījuma metode.'
    );

    // Atgriež JSON kļūdas atbildi
    echo json_encode($errorResponse);
}
?>
