<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lietotāja autentifikācija</title>
    <style>
        body {
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
            margin: 0;
        }

        form {
            text-align: center;
            max-width: 400px;
            width: 100%;
        }

        label {
            display: block;
            margin-bottom: 5px;
            text-align: left;
        }

        input {
            width: 100%;
            padding: 8px;
            margin-bottom: 10px;
            box-sizing: border-box;
            text-align: center;
        }

        .button-container {
            display: flex;
            justify-content: center;
            margin-top: 10px;
        }

        button {
            background-color: #4caf50;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            margin-left: 10px;
        }

        button:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>

<form action="<?php echo e(route('login.submit')); ?>" method="POST">
    <?php echo csrf_field(); ?>

    <label for="email">
        <input type="email" id="email" name="email" placeholder="E-pasts" value="<?php echo e(old('email')); ?>" required>
    </label>

    <br>

    <label for="password">
        <input type="password" id="password" name="password" placeholder="Parole" required>
    </label>

    <br>

    <div class="button-container">
        <button type="submit">Autorizēties</button>
        <button onclick="goBack()">Atpakaļ</button>
    </div>

    <?php if($errors->any()): ?>
        <div>
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

</form>

<script>
    function goBack() {
        window.history.back();
    }
</script>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\eikt410\resources\views/autentificet.blade.php ENDPATH**/ ?>