<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ieraksta izveide</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            width: 80%;
            max-width: 600px;
        }

        .top-buttons {
            display: flex;
            flex-direction: row;
            gap: 15px;
            margin-bottom: 20px;
        }

        .top-buttons button {
            font-size: 20px;
            padding: 15px 20px;
            height: auto;
        }

        .entry-title,
        .main-entry {
            margin-bottom: 20px;
            width: 100%;
        }

        .entry-title input,
        .main-entry div {
            width: 100%;
            max-width: 400px; /* Максимальная ширина поля */
            padding: 8px;
            margin-bottom: 10px;
            box-sizing: border-box;
            text-align: center;
            border: 1px solid #ccc;
        }
        
        .main-entry div {
            min-height: 200px;
            overflow-y: auto;
            border: 1px solid #000;
            padding: 5px;
        }

        #imgInput {
            display: none; /* Скрыть стандартное поле выбора файла */
        }

        #imgLabel {
            cursor: pointer; /* Установить курсор указывающей руки */
            font-size: 20px;
            padding: 15px 20px;
            background-color: #ccc; /* Серый фон */
            border: none; /* Удалить границу */
        }

        .add-image-button {
            order: -1; /* Поместить кнопку слева */
            background-color: transparent;
            border: none;
            cursor: pointer;
            font-size: 20px;
            padding: 15px 20px;
        }
        
        .add-image-button:hover {
            background-color: #ddd;
        }

        #font-size-controls {
            display: flex;
            align-items: center;
            justify-content: space-between;
            width: 100%;
            max-width: 400px;
            margin-bottom: 10px;
        }

        #font-size-display {
            font-size: 20px;
            width: 50px;
            text-align: center;
        }

        .font-size-control-button {
            cursor: pointer;
            padding: 5px 10px;
            border: none;
            background-color: #ddd;
            font-size: 20px;
        }
    </style>
</head>
<body>

<div class="container">

    <!-- Кнопки редактирования текста сверху -->
    <div class="top-buttons">
        <input type="file" id="imgInput" accept="image/*" onchange="addImage(event)" style="display: none;">
        <label for="imgInput" id="imgLabel" class="top-buttons button add-image-button" title="Pievienot">➕</label>
        <button title="Atsaukt rakstīšanu" onclick="undo()">↩️</button>
        <button title="Atkārtot rakstīšanu" onclick="redo()">↪️</button>
        <div id="font-size-controls">
            <div id="font-size-display">20</div>
            <button class="font-size-control-button" onclick="increaseFontSize()">▲</button>
            <button class="font-size-control-button" onclick="decreaseFontSize()">▼</button>
        </div>
        <button title="Regulēt fonta krāsu" onclick="changeFontColor()">A</button>
        <button title="Treknrakstā" onclick="makeTextBold()">B</button>
        <button title="Slīpraksta" onclick="makeTextItalic()">I</button>
        <button title="Pasvītrot" onclick="underlineText()">U</button>
        <button title="Saglabāt" onclick="saveChanges()">💾</button>
        <button title="Nodzēst ierakstu" onclick="deleteEntry()">🗑️</button>
    </div>

    <!-- Окно с заголовком -->
    <div class="entry-title">
        <input type="text" placeholder="Ievadiet virsrakstu">
    </div>

    <div class="main-entry">
        <div id="mainDiv" contenteditable="true" placeholder="Sāciet rakstīt savu ierakstu šeit..."></div>
    </div>

</div>

<script>
var isBold = false;
var isItalic = false;
var isUnderline = false;

var textHistory = [];
var historyIndex = -1;

function addContent() {
    var div = document.getElementById('mainDiv');
    div.innerHTML += "Teksts pievienots. ";
    updateHistory(); 
}

function undo() {
    if (historyIndex > 0) {
        historyIndex--;
        var div = document.getElementById('mainDiv');
        div.innerHTML = textHistory[historyIndex];
    }
}

function redo() {
    if (historyIndex < textHistory.length - 1) {
        historyIndex++;
        var div = document.getElementById('mainDiv');
        div.innerHTML = textHistory[historyIndex];
    }
}

function updateHistory() {
    var div = document.getElementById('mainDiv');
    historyIndex++;
    textHistory[historyIndex] = div.innerHTML;
    textHistory.splice(historyIndex + 1);
}

function changeFontSize() {
    var div = document.getElementById('mainDiv');
    var size = document.getElementById('font-size-slider').value;
    var fontSizeDisplay = document.getElementById('font-size-display');
    fontSizeDisplay.textContent = size;
    div.style.fontSize = size + 'px';
    updateHistory();
}

function increaseFontSize() {
    var slider = document.getElementById('font-size-slider');
    var size = parseInt(slider.value) + 1;
    if (size <= parseInt(slider.max)) {
        slider.value = size;
        changeFontSize();
    }
}

function decreaseFontSize() {
    var slider = document.getElementById('font-size-slider');
    var size = parseInt(slider.value) - 1;
    if (size >= parseInt(slider.min)) {
        slider.value = size;
        changeFontSize();
    }
}

function changeFontColor() {
    var color = prompt("Lūdzu, izvēlieties fonta krāsu:", "#000000");

    if (color !== null) {
        var div = document.getElementById('mainDiv');
        div.style.color = color;
        updateHistory();
    }
}

function makeTextBold() {
    document.execCommand('bold', false, null);
    updateHistory();
}

function makeTextItalic() {
    document.execCommand('italic', false, null);
    updateHistory();
}

function underlineText() {
    document.execCommand('underline', false, null);
    updateHistory();
}

function saveChanges() {
    var div = document.getElementById('mainDiv');
    localStorage.setItem('diaryEntry', div.innerHTML);
}

function deleteEntry() {
    var div = document.getElementById('mainDiv');
    div.innerHTML = '';
    updateHistory();
}

function addImage(event) {
    var file = event.target.files[0];
    if (file) {
        var reader = new FileReader();
        reader.onload = function(e) {
            var div = document.getElementById('mainDiv');
            var img = document.createElement('img');
            img.src = e.target.result;
            div.appendChild(img);
        };
        reader.readAsDataURL(file);
    }
}

var div = document.getElementById('mainDiv');
div.addEventListener('input', updateHistory);

</script>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\eikt410\resources\views/entry.blade.php ENDPATH**/ ?>