<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\RegisterController;
use App\Http\Controllers\AuthenticationController;

Route::get('/registration', [RegisterController::class, 'showRegistrationForm'])->name('registration');
Route::post('/registration', [RegisterController::class, 'processRegistration'])->name('registration.submit');
Route::get('/authentication', [AuthenticationController::class, 'showLoginForm'])->name('authentication');
Route::post('/authentication', [AuthenticationController::class, 'authenticate'])->name('login.submit');
Route::get('/lietotaja_interfeiss', [AuthenticationController::class, 'showUserInterface'])->name('lietotaja_interfeiss');
Route::get('/logout', [AuthenticationController::class, 'logout'])->name('logout');

Route::get('/lietotaja_interfeiss_buttons', function () {
    return view('lietotaja_interfeiss');
})->name('lietotaja_interfeiss_buttons');

Route::get('/entry_creation_page', function () {
    return view('entry');
})->name('entry_creation_page');

Route::get('/', function () {
    return view('welcome');
});
