<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lietotāja reģistrācija</title>
    <style>
        body {
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
            margin: 0;
            font-family: Arial, sans-serif; 
        }

        form {
            text-align: center;
            max-width: 400px;
            width: 100%;
        }

        label {
            display: block;
            margin-bottom: 5px;
            text-align: left;
        }

        input {
            width: 100%;
            padding: 8px;
            margin-bottom: 10px;
            box-sizing: border-box;
            text-align: center;
        }

        button {
            background-color: #4caf50;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        button:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>

<form id="registrationForm" method="post" action="{{ route('registration.submit') }}">
    @csrf

    <label for="lietotajvards">
        <input type="text" id="lietotajvards" name="lietotajvards" placeholder="Lietotājvārds" value="{{ old('lietotajvards') }}" required>
    </label>

    <br>

    <label for="epasts">
        <input type="email" id="epasts" name="epasts" placeholder="E-pasts" value="{{ old('epasts') }}" required>
    </label>

    <br>

    <label for="parole">
        <input type="password" id="parole" name="parole" placeholder="Parole" required>
    </label>

    <br>

    <button type="submit">Izveidot kontu</button>

    <button type="button" onclick="goBack()">Atpakaļ</button>

    @if ($errors->any())
        <div>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
</form>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    function goBack() {
        window.history.back();
    }
</script>

</body>
</html>
