<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lietotāja interfeiss</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }

        .top-right {
            position: absolute;
            top: 10px;
            right: 10px;
        }

        .find-entry {
            position: absolute;
            top: 50px;
            left: 50%;
            transform: translateX(-50%);
        }

        .entries {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-top: 20px;
        }

        .entry-row {
            display: flex;
            margin-bottom: 10px;
        }

        .button {
            padding: 10px;
            margin: 5px;
            border: none;
            cursor: pointer;
        }
    </style>
</head>
<body>

<div class="top-right">
    <button onclick="finishWork()">Beigt darbu</button>
</div>

<button class="find-entry" title="Atrast ierakstu" onclick="findEntry()">🔍 Atrast ierakstu</button>

<div class="entries">
    <div class="entry-row">
        <!-- Изменение в onclick -->
        <button onclick="createNewEntry()">Izveidot jaunu ierakstu</button>
        <button onclick="loadPastEntry(1)">Iepriekšējais ieraksts</button>
        <button onclick="loadPastEntry(2)">Iepriekšējais ieraksts</button>
        <button onclick="loadPastEntry(3)">Iepriekšējais ieraksts</button>
    </div>
    <div class="entry-row">
        <button onclick="loadPastEntry(4)">Iepriekšējais ieraksts</button>
        <button onclick="loadPastEntry(5)">Iepriekšējais ieraksts</button>
        <button onclick="loadPastEntry(6)">Iepriekšējais ieraksts</button>
        <button onclick="loadPastEntry(7)">Iepriekšējais ieraksts</button>
    </div>
</div>

<script>
    function finishWork() {
        console.log("Beidzam darbu");
        window.location.href = "{{ route('lietotaja_interfeiss_buttons') }}";
    }

    function findEntry() {
        console.log("Meklējam ierakstu");
    }

    // Функция для перехода на страницу создания нового записи
    function createNewEntry() {
        console.log("Izveidojam jaunu ierakstu");
        window.location.href = "{{ route('entry_creation_page') }}";
    }

    function loadPastEntry(entryNumber) {
        console.log("Atveram iepriekšējo ierakstu Nr. " + entryNumber);
    }
</script>

</body>
</html>
